/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.distance.analysis.functional;

import fr.inrae.act.bagap.apiland.analysis.Analysis;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TabRCMDistanceAnalysis2
extends Analysis {
    private float[] outDatas;
    private float[] inDatas;
    private float[] frictionDatas;
    private int[] codes;
    private double threshold;
    private int width;
    private int height;
    private float cellSize;
    private int noDataValue;
    private boolean hasValue;
    private Map<Float, Set<Pixel>> waits;

    public TabRCMDistanceAnalysis2(float[] outDatas, float[] inDatas, float[] frictionDatas, int width, int height, float cellSize, int noDataValue, int[] codes) {
        this(outDatas, inDatas, frictionDatas, width, height, cellSize, noDataValue, codes, noDataValue);
    }

    public TabRCMDistanceAnalysis2(float[] outDatas, float[] inDatas, float[] frictionDatas, int width, int height, float cellSize, int noDataValue, int[] codes, int threshold) {
        this.outDatas = outDatas;
        this.inDatas = inDatas;
        this.frictionDatas = frictionDatas;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
        this.codes = codes;
        this.threshold = threshold == noDataValue ? 1000000.0 : (double)threshold;
        this.waits = new TreeMap<Float, Set<Pixel>>();
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    protected void doInit() {
        this.hasValue = false;
        for (int yt = 0; yt < this.height; ++yt) {
            for (int xt = 0; xt < this.width; ++xt) {
                float v = this.inDatas[yt * this.width + xt];
                boolean ok = false;
                if (v != (float)this.noDataValue) {
                    for (int c : this.codes) {
                        if ((float)c != v) continue;
                        ok = true;
                        this.hasValue = true;
                        break;
                    }
                    if (ok) {
                        this.outDatas[yt * this.width + xt] = 0.0f;
                        continue;
                    }
                    this.outDatas[yt * this.width + xt] = -2.0f;
                    continue;
                }
                this.outDatas[yt * this.width + xt] = this.noDataValue;
            }
        }
        this.inDatas = null;
        for (int yt = 0; yt < this.height; ++yt) {
            for (int xt = 0; xt < this.width; ++xt) {
                if (this.outDatas[yt * this.width + xt] != 0.0f) continue;
                boolean maj = true;
                if (!(xt != 0 && this.outDatas[xt - 1 + yt * this.width] != 0.0f || xt != 0 && yt != 0 && this.outDatas[xt - 1 + (yt - 1) * this.width] != 0.0f || yt != 0 && this.outDatas[xt + (yt - 1) * this.width] != 0.0f || xt != this.width - 1 && yt != 0 && this.outDatas[xt + 1 + (yt - 1) * this.width] != 0.0f || xt != this.width - 1 && this.outDatas[xt + 1 + yt * this.width] != 0.0f || xt != this.width - 1 && yt != this.height - 1 && this.outDatas[xt + 1 + (yt + 1) * this.width] != 0.0f || yt != this.height - 1 && this.outDatas[xt + (yt + 1) * this.width] != 0.0f || xt != 0 && yt != this.height - 1 && this.outDatas[xt - 1 + (yt + 1) * this.width] != 0.0f)) {
                    maj = false;
                }
                if (!maj) continue;
                this.setPixelAndValue(new Pixel(xt, yt), 0.0f);
            }
        }
    }

    @Override
    public void doRun() {
        while (this.waits.size() > 0) {
            this.diffusionPaquet();
        }
        this.setResult(this.outDatas);
    }

    public void setPixelAndValue(Pixel pixel, float value) {
        if (!this.waits.containsKey(Float.valueOf(value = (float)(Math.floor((double)value * 100.0) / 100.0)))) {
            this.waits.put(Float.valueOf(value), new HashSet());
        }
        this.waits.get(Float.valueOf(value)).add(pixel);
    }

    private void diffusionPaquet() {
        Iterator<Map.Entry<Float, Set<Pixel>>> iteEntry = this.waits.entrySet().iterator();
        Map.Entry<Float, Set<Pixel>> entry = iteEntry.next();
        iteEntry.remove();
        if (entry.getValue().size() != 0) {
            double dd = entry.getKey().floatValue();
            for (Pixel p : entry.getValue()) {
                this.diffusion(p, dd);
            }
        }
    }

    private void diffusion(Pixel p, double dd) {
        double vd;
        if (this.threshold > dd && (vd = (double)this.outDatas[p.x() + p.y() * this.width]) != (double)this.noDataValue) {
            float value;
            float d;
            float fc;
            float v;
            Pixel np;
            double fd = this.frictionDatas[p.x() + p.y() * this.width];
            Iterator ite = null;
            while (ite.hasNext()) {
                np = (Pixel)ite.next();
                if (np.x() < 0 || np.x() >= this.width || np.y() < 0 || np.y() >= this.height || (v = this.outDatas[np.x() + np.y() * this.width]) == (float)this.noDataValue) continue;
                fc = this.frictionDatas[np.x() + np.y() * this.width];
                d = (float)(dd + (double)(this.cellSize / 2.0f) * fd + (double)(this.cellSize / 2.0f * fc));
                if (v != -2.0f && !(d < v)) continue;
                this.outDatas[np.x() + np.y() * this.width] = d;
                if (v != -2.0f) {
                    value = (float)(Math.floor((double)v * 100.0) / 100.0);
                    this.waits.get(Float.valueOf(value)).remove(np);
                }
                this.setPixelAndValue(np, d);
            }
            while (ite.hasNext()) {
                np = (Pixel)ite.next();
                if (np.x() < 0 || np.x() >= this.width || np.y() < 0 || np.y() >= this.height || (v = this.outDatas[np.x() + np.y() * this.width]) == (float)this.noDataValue) continue;
                fc = this.frictionDatas[np.x() + np.y() * this.width];
                d = (float)(dd + (double)this.cellSize * Math.sqrt(2.0) / 2.0 * fd + (double)this.cellSize * Math.sqrt(2.0) / 2.0 * (double)fc);
                if (v != -2.0f && !(d < v)) continue;
                this.outDatas[np.x() + np.y() * this.width] = d;
                if (v != -2.0f) {
                    value = (float)(Math.floor((double)v * 100.0) / 100.0);
                    this.waits.get(Float.valueOf(value)).remove(np);
                }
                this.setPixelAndValue(np, d);
            }
        }
    }

    @Override
    protected void doClose() {
        this.waits = null;
    }
}

