/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.distance.analysis.functional;

import fr.inrae.act.bagap.apiland.analysis.Analysis;
import fr.inrae.act.bagap.apiland.core.space.impl.raster.Pixel;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Raster;
import fr.inrae.act.bagap.apiland.raster.Tile;
import fr.inrae.act.bagap.chloe.distance.analysis.functional.TabRCMDistanceAnalysis;
import fr.inrae.act.bagap.chloe.distance.output.TileGeoTiffDistanceOutput;
import fr.inrae.act.bagap.chloe.util.Util;
import java.awt.Rectangle;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.image.util.ImageUtilities;

public class HugeRCMDistanceAnalysis
extends Analysis {
    private String folder;
    private String name;
    private String temp;
    private int[] codes;
    private float threshold;
    private int maxTile = 5000;
    private int width;
    private int height;
    private double imageMinX;
    private double imageMinY;
    private double imageMaxX;
    private double imageMaxY;
    private float cellSize;
    private int noDataValue;
    private int dWidth;
    private int dHeight;
    private Map<Pixel, Map<String, float[]>> bords;
    private short[] calculTab;
    private short[] majTab;
    private Coverage inCoverage;
    private Coverage frictionCoverage;
    private Tile tile;

    public HugeRCMDistanceAnalysis(Coverage inCoverage, Coverage frictionCoverage, Tile tile, String output, String name, Collection<Integer> codes, float threshold) {
        this.inCoverage = inCoverage;
        this.frictionCoverage = frictionCoverage;
        this.folder = output;
        this.name = name;
        this.tile = tile;
        this.temp = output + "euclidian/";
        Util.createAccess(this.temp);
        this.temp = this.temp + "name";
        this.codes = new int[codes.size()];
        int index = 0;
        for (int i : codes) {
            this.codes[index++] = i;
        }
        this.threshold = threshold;
    }

    @Override
    protected void doInit() {
        EnteteRaster entete = this.inCoverage.getEntete();
        this.width = entete.width();
        this.height = entete.height();
        this.imageMinX = entete.minx();
        this.imageMinY = entete.miny();
        this.imageMaxX = entete.maxx();
        this.imageMaxY = entete.maxy();
        this.cellSize = entete.cellsize();
        this.noDataValue = entete.noDataValue();
        this.dWidth = 0;
        this.dHeight = 0;
        this.bords = new HashMap<Pixel, Map<String, float[]>>();
        int dx = 0;
        int dy = 0;
        for (int y = 0; y < this.height; y += this.maxTile - 1) {
            dx = 0;
            this.dWidth = 0;
            for (int x = 0; x < this.width; x += this.maxTile - 1) {
                float[] bord;
                ++this.dWidth;
                Pixel p = new Pixel(dx, dy);
                this.bords.put(p, new HashMap());
                int roiWidth = Math.min(this.maxTile, this.width - x);
                int roiHeight = Math.min(this.maxTile, this.height - y);
                if (dx > 0) {
                    bord = new float[roiHeight];
                    Arrays.fill(bord, -1.0f);
                    this.bords.get(p).put("left", bord);
                    this.bords.get(new Pixel(dx - 1, dy)).put("right", bord);
                }
                if (dy > 0) {
                    bord = new float[roiWidth];
                    Arrays.fill(bord, -1.0f);
                    this.bords.get(p).put("north", bord);
                    this.bords.get(new Pixel(dx, dy - 1)).put("south", bord);
                }
                ++dx;
            }
            ++this.dHeight;
            ++dy;
        }
        this.calculTab = new short[this.dWidth * this.dHeight];
        Arrays.fill(this.calculTab, (short)-1);
        this.majTab = new short[this.dWidth * this.dHeight];
        Arrays.fill(this.majTab, (short)0);
    }

    @Override
    protected void doRun() {
        boolean finish = false;
        int pass = 1;
        while (!finish) {
            boolean isFinish;
            TabRCMDistanceAnalysis rcm;
            float[] frictionDatas;
            float[] outDatas;
            double roiPosMaxY;
            double roiPosMinY;
            double roiPosMaxX;
            double roiPosMinX;
            int roiHeight;
            int roiWidth;
            int x;
            int y;
            int dy;
            int dx;
            finish = true;
            if (pass == 1) {
                dx = 0;
                dy = 0;
                for (y = 0; y < this.height; y += this.maxTile - 1) {
                    dx = 0;
                    for (x = 0; x < this.width; x += this.maxTile - 1) {
                        roiWidth = Math.min(this.maxTile, this.width - x);
                        roiHeight = Math.min(this.maxTile, this.height - y);
                        roiPosMinX = this.imageMinX + (double)((float)x * this.cellSize);
                        roiPosMaxX = roiPosMinX + (double)((float)roiWidth * this.cellSize);
                        roiPosMinY = Math.max(this.imageMinY, this.imageMaxY - (double)((float)(y + roiHeight) * this.cellSize));
                        roiPosMaxY = roiPosMinY + (double)((float)roiHeight * this.cellSize);
                        float[] inDatas = this.inCoverage.getData(new Rectangle(x, y, roiWidth, roiHeight));
                        outDatas = new float[roiHeight * roiWidth];
                        frictionDatas = this.frictionCoverage.getData(new Rectangle(x, y, roiWidth, roiHeight));
                        rcm = new TabRCMDistanceAnalysis(outDatas, inDatas, frictionDatas, roiWidth, roiHeight, this.cellSize, this.noDataValue, this.codes);
                        rcm.init();
                        inDatas = null;
                        if (rcm.hasValue()) {
                            rcm.run();
                            outDatas = (float[])rcm.getResult();
                            isFinish = this.bordUpdateFromData(dx, dy, roiWidth, roiHeight, roiPosMinX, roiPosMaxX, roiPosMinY, roiPosMaxY, outDatas);
                            if (!isFinish) {
                                finish = false;
                            }
                            this.calculTab[dy * this.dWidth + dx] = 1;
                        }
                        CoverageManager.writeGeotiff(new File(this.temp + "_" + dx + "-" + dy + ".tif"), outDatas, roiWidth, roiHeight, roiPosMinX, roiPosMaxX, roiPosMinY, roiPosMaxY, Raster.getNoDataValue());
                        ++dx;
                    }
                    ++dy;
                }
            } else {
                if (this.inCoverage != null) {
                    this.inCoverage.dispose();
                    this.inCoverage = null;
                }
                dx = 0;
                dy = 0;
                for (y = 0; y < this.height; y += this.maxTile - 1) {
                    dx = 0;
                    for (x = 0; x < this.width; x += this.maxTile - 1) {
                        if (this.majTab[dy * this.dWidth + dx] == 1) {
                            int i;
                            int j;
                            float[] bord;
                            roiWidth = Math.min(this.maxTile, this.width - x);
                            roiHeight = Math.min(this.maxTile, this.height - y);
                            roiPosMinX = this.imageMinX + (double)((float)x * this.cellSize);
                            roiPosMaxX = roiPosMinX + (double)((float)roiWidth * this.cellSize);
                            roiPosMinY = Math.max(this.imageMinY, this.imageMaxY - (double)((float)(y + roiHeight) * this.cellSize));
                            roiPosMaxY = roiPosMinY + (double)((float)roiHeight * this.cellSize);
                            GridCoverage2D cov = CoverageManager.get(this.temp + "_" + dx + "-" + dy + ".tif");
                            outDatas = CoverageManager.getData(cov, 0, 0, roiWidth, roiHeight);
                            cov.dispose(true);
                            ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)cov.getRenderedImage()));
                            cov = null;
                            frictionDatas = this.frictionCoverage.getData(new Rectangle(x, y, roiWidth, roiHeight));
                            rcm = new TabRCMDistanceAnalysis(outDatas, null, frictionDatas, roiWidth, roiHeight, this.cellSize, this.noDataValue, this.codes);
                            Pixel p = new Pixel(dx, dy);
                            if (this.calculTab[dy * this.dWidth + dx] == -1) {
                                if (dx > 0 && this.calculTab[dy * this.dWidth + (dx - 1)] >= 0) {
                                    bord = this.bords.get(p).get("left");
                                    for (j = 0; j < roiHeight; ++j) {
                                        outDatas[j * roiWidth + 0] = bord[j];
                                        rcm.setPixelAndValue(j * roiWidth + 0, bord[j]);
                                    }
                                }
                                if (dy > 0 && this.calculTab[(dy - 1) * this.dWidth + dx] >= 0) {
                                    bord = this.bords.get(p).get("north");
                                    for (i = 0; i < roiWidth; ++i) {
                                        outDatas[i] = bord[i];
                                        rcm.setPixelAndValue(i, bord[i]);
                                    }
                                }
                                if (dx < this.dWidth - 1 && this.calculTab[dy * this.dWidth + (dx + 1)] >= 0) {
                                    bord = this.bords.get(p).get("right");
                                    for (j = 0; j < roiHeight; ++j) {
                                        outDatas[j * roiWidth + (roiWidth - 1)] = bord[j];
                                        rcm.setPixelAndValue(j * roiWidth + (roiWidth - 1), bord[j]);
                                    }
                                }
                                if (dy < this.dHeight - 1 && this.calculTab[(dy + 1) * this.dWidth + dx] >= 0) {
                                    bord = this.bords.get(p).get("south");
                                    for (i = 0; i < roiWidth; ++i) {
                                        outDatas[(roiHeight - 1) * roiWidth + i] = bord[i];
                                        rcm.setPixelAndValue((roiHeight - 1) * roiWidth + i, bord[i]);
                                    }
                                }
                            } else {
                                if (dx > 0) {
                                    bord = this.bords.get(p).get("left");
                                    for (j = 0; j < roiHeight; ++j) {
                                        if (!(bord[j] < outDatas[j * roiWidth + 0])) continue;
                                        outDatas[j * roiWidth + 0] = bord[j];
                                        rcm.setPixelAndValue(j * roiWidth + 0, bord[j]);
                                    }
                                }
                                if (dy > 0) {
                                    bord = this.bords.get(p).get("north");
                                    for (i = 0; i < roiWidth; ++i) {
                                        if (!(bord[i] < outDatas[i])) continue;
                                        outDatas[i] = bord[i];
                                        rcm.setPixelAndValue(i, bord[i]);
                                    }
                                }
                                if (dx < this.dWidth - 1) {
                                    bord = this.bords.get(p).get("right");
                                    for (j = 0; j < roiHeight; ++j) {
                                        if (!(bord[j] < outDatas[j * roiWidth + (roiWidth - 1)])) continue;
                                        outDatas[j * roiWidth + (roiWidth - 1)] = bord[j];
                                        rcm.setPixelAndValue(j * roiWidth + (roiWidth - 1), bord[j]);
                                    }
                                }
                                if (dy < this.dHeight - 1) {
                                    bord = this.bords.get(p).get("south");
                                    for (i = 0; i < roiWidth; ++i) {
                                        if (!(bord[i] < outDatas[(roiHeight - 1) * roiWidth + i])) continue;
                                        outDatas[(roiHeight - 1) * roiWidth + i] = bord[i];
                                        rcm.setPixelAndValue((roiHeight - 1) * roiWidth + i, bord[i]);
                                    }
                                }
                            }
                            rcm.run();
                            outDatas = (float[])rcm.getResult();
                            isFinish = this.bordUpdateFromData(dx, dy, roiWidth, roiHeight, roiPosMinX, roiPosMaxX, roiPosMinY, roiPosMaxY, outDatas);
                            if (!isFinish) {
                                finish = false;
                            }
                            CoverageManager.writeGeotiff(new File(this.temp + "_" + dx + "-" + dy + ".tif"), outDatas, roiWidth, roiHeight, roiPosMinX, roiPosMaxX, roiPosMinY, roiPosMaxY, Raster.getNoDataValue());
                            this.majTab[dy * this.dWidth + dx] = 0;
                            this.calculTab[dy * this.dWidth + dx] = 1;
                        } else if (this.calculTab[dy * this.dWidth + dx] >= 0) {
                            this.calculTab[dy * this.dWidth + dx] = 0;
                        }
                        ++dx;
                    }
                    ++dy;
                }
            }
            ++pass;
        }
        this.exportRaster();
    }

    private boolean bordUpdateFromData(int dx, int dy, int roiWidth, int roiHeight, double roiPosMinX, double roiPosMaxX, double roiPosMinY, double roiPosMaxY, float[] outDatas) {
        int i;
        int j;
        float[] bord;
        boolean finish = true;
        Pixel p = new Pixel(dx, dy);
        if (dx > 0) {
            bord = this.bords.get(p).get("left");
            for (j = 0; j < roiHeight; ++j) {
                if (bord[j] == outDatas[j * roiWidth + 0]) continue;
                bord[j] = outDatas[j * roiWidth + 0];
                this.majTab[dy * this.dWidth + (dx - 1)] = 1;
                finish = false;
            }
        }
        if (dy > 0) {
            bord = this.bords.get(p).get("north");
            for (i = 0; i < roiWidth; ++i) {
                if (bord[i] == outDatas[i]) continue;
                bord[i] = outDatas[i];
                this.majTab[(dy - 1) * this.dWidth + dx] = 1;
                finish = false;
            }
        }
        if (dx < this.dWidth - 1) {
            bord = this.bords.get(p).get("right");
            for (j = 0; j < roiHeight; ++j) {
                if (bord[j] == outDatas[j * roiWidth + (roiWidth - 1)]) continue;
                bord[j] = outDatas[j * roiWidth + (roiWidth - 1)];
                this.majTab[dy * this.dWidth + (dx + 1)] = 1;
                finish = false;
            }
        }
        if (dy < this.dHeight - 1) {
            bord = this.bords.get(p).get("south");
            for (i = 0; i < roiWidth; ++i) {
                if (bord[i] == outDatas[(roiHeight - 1) * roiWidth + i]) continue;
                bord[i] = outDatas[(roiHeight - 1) * roiWidth + i];
                this.majTab[(dy + 1) * this.dWidth + dx] = 1;
                finish = false;
            }
        }
        return finish;
    }

    private void exportRaster() {
        TileGeoTiffDistanceOutput output = new TileGeoTiffDistanceOutput(this.folder, this.name, this.tile, this.width, this.height, this.maxTile, this.imageMinX, this.imageMaxX, this.imageMinY, this.imageMaxY, this.cellSize, this.noDataValue);
        output.init();
        int dx = 0;
        int dy = 0;
        int localHeight = -1;
        for (int y = 0; y < this.height - 1; y += this.maxTile - 1) {
            dx = 0;
            for (int x = 0; x < this.width - 1; x += this.maxTile - 1) {
                Coverage localCoverage = CoverageManager.getCoverage(this.temp + "_" + dx + "-" + dy + ".tif");
                float[] datas = localCoverage.getData();
                EnteteRaster entete = localCoverage.getEntete();
                localCoverage.dispose();
                localHeight = entete.height();
                output.post(x, y, entete.width(), entete.height(), datas);
                ++dx;
            }
            output.operate(y, localHeight);
            ++dy;
        }
        output.close();
    }

    private void deleteTempFolder() {
        int dx = 0;
        int dy = 0;
        for (int y = 0; y < this.height - 1; y += this.maxTile - 1) {
            dx = 0;
            for (int x = 0; x < this.width - 1; x += this.maxTile - 1) {
                new File(this.temp + "_" + dx + "-" + dy + ".tif").delete();
                ++dx;
            }
            ++dy;
        }
    }

    @Override
    protected void doClose() {
        this.deleteTempFolder();
        if (this.inCoverage != null) {
            this.inCoverage = null;
        }
        if (this.frictionCoverage != null) {
            this.frictionCoverage = null;
        }
        this.bords.clear();
        this.bords = null;
        this.codes = null;
        this.calculTab = null;
        this.majTab = null;
    }
}

