/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.distance.analysis.functional;

import fr.inrae.act.bagap.apiland.analysis.Analysis;
import fr.inrae.act.bagap.apiland.raster.Raster;
import java.util.ArrayList;
import java.util.List;

public class ArrayRCMDistanceAnalysis4
extends Analysis {
    private static final float sqrt2 = (float)Math.sqrt(2.0);
    private static final float coeffReg = 314.0f;
    private float[] outDatas;
    private float[] frictionDatas;
    private float[] everDatas;
    private double threshold;
    private int width;
    private int height;
    private float cellSize;
    private int noDataValue;
    private List<Integer>[] waits;
    private boolean hasValue;

    public ArrayRCMDistanceAnalysis4(float[] outDatas, float[] frictionDatas, int width, int height, float cellSize, int noDataValue, double threshold) {
        this.outDatas = outDatas;
        this.frictionDatas = frictionDatas;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
        this.threshold = threshold == (double)Raster.getNoDataValue() ? 2.147483647E9 : threshold;
    }

    @Override
    protected void doInit() {
        this.everDatas = new float[this.outDatas.length];
        this.waits = new ArrayList[(int)(this.threshold * 314.0 / (double)this.cellSize)];
        this.waits[0] = new ArrayList<Integer>();
        this.hasValue = false;
        for (int ind = 0; ind < this.frictionDatas.length; ++ind) {
            if (this.frictionDatas[ind] == (float)this.noDataValue) {
                this.outDatas[ind] = this.noDataValue;
                continue;
            }
            if (ind == (this.width * this.width - 1) / 2) {
                this.hasValue = true;
                this.outDatas[ind] = 0.0f;
                this.waits[0].add(ind);
                continue;
            }
            this.outDatas[ind] = -2.0f;
        }
    }

    @Override
    public void doRun() {
        if (this.hasValue) {
            int d = 0;
            while ((double)d < this.threshold * 314.0 / (double)this.cellSize) {
                List<Integer> wait = this.waits[d];
                if (wait != null) {
                    this.waits[d] = null;
                    this.diffusionPaquet(d, wait);
                    --d;
                }
                ++d;
            }
        }
        this.setResult(this.outDatas);
    }

    private void diffusionPaquet(int dd, List<Integer> wait) {
        for (int p : wait) {
            this.diffusion(p, (float)dd / 314.0f);
        }
    }

    private void setPixelAndValue(int pixel, float dist) {
        if ((double)dist < this.threshold / (double)this.cellSize) {
            if (this.waits[(int)(dist * 314.0f)] == null) {
                this.waits[(int)(dist * 314.0f)] = new ArrayList<Integer>();
            }
            this.waits[(int)(dist * 314.0f)].add(pixel);
        }
    }

    private void diffusion(int p, double dd) {
        if (this.everDatas[p] != 1.0f && this.threshold / (double)this.cellSize > dd) {
            this.everDatas[p] = 1.0f;
            if (this.outDatas[p] != (float)this.noDataValue) {
                float d;
                float fc;
                float v;
                float fd = this.frictionDatas[p];
                int x = p % this.width;
                int y = p / this.width;
                int np = p - this.width - 1;
                if (x > 0 && y > 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(sqrt2 / 2.0f * fd) + (double)(sqrt2 / 2.0f * fc));
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                np = p - this.width;
                if (y > 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + 0.5 * (double)fd + 0.5 * (double)fc);
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                np = p - this.width + 1;
                if (x < this.width - 1 && y > 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(sqrt2 / 2.0f * fd) + (double)(sqrt2 / 2.0f * fc));
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                np = p - 1;
                if (x > 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + 0.5 * (double)fd + 0.5 * (double)fc);
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                np = p + 1;
                if (x < this.width - 1 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + 0.5 * (double)fd + 0.5 * (double)fc);
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                np = p + this.width - 1;
                if (x > 0 && y < this.height - 1 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(sqrt2 / 2.0f * fd) + (double)(sqrt2 / 2.0f * fc));
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                np = p + this.width;
                if (y < this.height - 1 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + 0.5 * (double)fd + 0.5 * (double)fc);
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
                np = p + this.width + 1;
                if (x < this.width - 1 && y < this.height - 1 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(sqrt2 / 2.0f * fd) + (double)(sqrt2 / 2.0f * fc));
                    if (v == -2.0f || d * this.cellSize < v) {
                        this.outDatas[np] = d * this.cellSize;
                        this.setPixelAndValue(np, d);
                    }
                }
            }
        }
    }

    @Override
    protected void doClose() {
    }
}

