/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.distance.analysis.functional;

import fr.inrae.act.bagap.apiland.analysis.Analysis;
import fr.inrae.act.bagap.apiland.raster.Raster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ArrayRCMDistanceAnalysis3
extends Analysis {
    private int indexG = 0;
    private static final float sqrt2 = (float)Math.sqrt(2.0);
    private float[] outDatas;
    private float[] frictionDatas;
    private float[] everDatas;
    private double threshold;
    private int width;
    private int height;
    private float cellSize;
    private int noDataValue;
    private Map<Float, List<Integer>> waits;

    public ArrayRCMDistanceAnalysis3(float[] outDatas, float[] frictionDatas, int width, int height, float cellSize, int noDataValue, Map<Float, List<Integer>> waits) {
        this(outDatas, frictionDatas, width, height, cellSize, noDataValue, waits, Raster.getNoDataValue());
    }

    public ArrayRCMDistanceAnalysis3(float[] outDatas, float[] frictionDatas, int width, int height, float cellSize, int noDataValue, Map<Float, List<Integer>> waits, double threshold) {
        this.outDatas = outDatas;
        this.frictionDatas = frictionDatas;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
        this.waits = waits;
        this.threshold = threshold == (double)Raster.getNoDataValue() ? 2.147483647E9 : threshold;
    }

    @Override
    protected void doInit() {
        this.everDatas = new float[this.outDatas.length];
    }

    @Override
    public void doRun() {
        while (this.waits.size() > 0) {
            this.diffusionPaquet();
        }
        this.setResult(this.outDatas);
    }

    private void setPixelAndValue(Map<Float, List<Integer>> waits, int pixel, float value) {
        if (!waits.containsKey(Float.valueOf(value = (float)(Math.floor((double)value * 100.0) / 100.0)))) {
            waits.put(Float.valueOf(value), new ArrayList());
        }
        waits.get(Float.valueOf(value)).add(pixel);
    }

    private void diffusionPaquet() {
        Iterator<Map.Entry<Float, List<Integer>>> iteEntry = this.waits.entrySet().iterator();
        Map.Entry<Float, List<Integer>> entry = iteEntry.next();
        iteEntry.remove();
        if (entry.getValue().size() != 0) {
            double dd = entry.getKey().floatValue();
            for (int p : entry.getValue()) {
                this.diffusion(p, dd);
            }
        }
    }

    private void diffusion(int p, double dd) {
        ++this.indexG;
        if (this.everDatas[p] != 1.0f && this.threshold > dd) {
            this.everDatas[p] = 1.0f;
            double vd = this.outDatas[p];
            if (vd != (double)this.noDataValue) {
                float d;
                float fc;
                float v;
                float fd = this.frictionDatas[p];
                int np = p - this.width - 1;
                if (np >= 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(this.cellSize * sqrt2 / 2.0f * fd) + (double)(this.cellSize * sqrt2 / 2.0f * fc));
                    if (v == -2.0f || d < v) {
                        this.outDatas[np] = d;
                        this.setPixelAndValue(this.waits, np, d);
                    }
                }
                if ((np = p - this.width) >= 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(this.cellSize / 2.0f * fd) + (double)(this.cellSize / 2.0f * fc));
                    if (v == -2.0f || d < v) {
                        this.outDatas[np] = d;
                        this.setPixelAndValue(this.waits, np, d);
                    }
                }
                if ((np = p - this.width + 1) >= 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(this.cellSize * sqrt2 / 2.0f * fd) + (double)(this.cellSize * sqrt2 / 2.0f * fc));
                    if (v == -2.0f || d < v) {
                        this.outDatas[np] = d;
                        this.setPixelAndValue(this.waits, np, d);
                    }
                }
                if ((np = p - 1) >= 0 && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(this.cellSize / 2.0f * fd) + (double)(this.cellSize / 2.0f * fc));
                    if (v == -2.0f || d < v) {
                        this.outDatas[np] = d;
                        this.setPixelAndValue(this.waits, np, d);
                    }
                }
                if ((np = p + 1) < this.width * this.height && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(this.cellSize / 2.0f * fd) + (double)(this.cellSize / 2.0f * fc));
                    if (v == -2.0f || d < v) {
                        this.outDatas[np] = d;
                        this.setPixelAndValue(this.waits, np, d);
                    }
                }
                if ((np = p + this.width - 1) < this.width * this.height && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(this.cellSize * sqrt2 / 2.0f * fd) + (double)(this.cellSize * sqrt2 / 2.0f * fc));
                    if (v == -2.0f || d < v) {
                        this.outDatas[np] = d;
                        this.setPixelAndValue(this.waits, np, d);
                    }
                }
                if ((np = p + this.width) < this.width * this.height && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(this.cellSize / 2.0f * fd) + (double)(this.cellSize / 2.0f * fc));
                    if (v == -2.0f || d < v) {
                        this.outDatas[np] = d;
                        this.setPixelAndValue(this.waits, np, d);
                    }
                }
                if ((np = p + this.width + 1) < this.width * this.height && this.everDatas[np] != 1.0f && (v = this.outDatas[np]) != (float)this.noDataValue) {
                    fc = this.frictionDatas[np];
                    d = (float)(dd + (double)(this.cellSize * sqrt2 / 2.0f * fd) + (double)(this.cellSize * sqrt2 / 2.0f * fc));
                    if (v == -2.0f || d < v) {
                        this.outDatas[np] = d;
                        this.setPixelAndValue(this.waits, np, d);
                    }
                }
            }
        }
    }

    @Override
    protected void doClose() {
    }
}

