/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.distance.analysis.functional;

import fr.inrae.act.bagap.apiland.analysis.Analysis;
import fr.inrae.act.bagap.apiland.raster.Pixel;
import fr.inrae.act.bagap.apiland.raster.Raster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ArrayRCMDistanceAnalysis2
extends Analysis {
    private int indexG = 0;
    private float[] outDatas;
    private float[] frictionDatas;
    private double threshold;
    private int width;
    private int height;
    private float cellSize;
    private int noDataValue;
    private Map<Float, List<Pixel>> waits;

    public ArrayRCMDistanceAnalysis2(float[] outDatas, float[] frictionDatas, int width, int height, float cellSize, int noDataValue, Map<Float, List<Pixel>> waits) {
        this(outDatas, frictionDatas, width, height, cellSize, noDataValue, waits, Raster.getNoDataValue());
    }

    public ArrayRCMDistanceAnalysis2(float[] outDatas, float[] frictionDatas, int width, int height, float cellSize, int noDataValue, Map<Float, List<Pixel>> waits, double threshold) {
        this.outDatas = outDatas;
        this.frictionDatas = frictionDatas;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
        this.waits = waits;
        this.threshold = threshold == (double)Raster.getNoDataValue() ? 2.147483647E9 : threshold;
    }

    @Override
    protected void doInit() {
    }

    @Override
    public void doRun() {
        while (this.waits.size() > 0) {
            this.diffusionPaquet();
        }
        this.setResult(this.outDatas);
    }

    private void setPixelAndValue(Map<Float, List<Pixel>> waits, Pixel pixel, float value) {
        if (!waits.containsKey(Float.valueOf(value = (float)(Math.floor((double)value * 100.0) / 100.0)))) {
            waits.put(Float.valueOf(value), new ArrayList());
        }
        waits.get(Float.valueOf(value)).add(pixel);
    }

    private void diffusionPaquet() {
        Iterator<Map.Entry<Float, List<Pixel>>> iteEntry = this.waits.entrySet().iterator();
        Map.Entry<Float, List<Pixel>> entry = iteEntry.next();
        iteEntry.remove();
        if (entry.getValue().size() != 0) {
            double dd = entry.getKey().floatValue();
            for (Pixel p : entry.getValue()) {
                this.diffusion(p, dd);
            }
        }
    }

    private void diffusion(Pixel p, double dd) {
        double vd;
        ++this.indexG;
        if (this.threshold > dd && (vd = (double)this.outDatas[p.x() + p.y() * this.width]) != (double)this.noDataValue) {
            float d;
            float fc;
            float v;
            Pixel np;
            double fd = this.frictionDatas[p.x() + p.y() * this.width];
            Iterator ite = null;
            while (ite.hasNext()) {
                np = (Pixel)ite.next();
                if (np.x() < 0 || np.x() >= this.width || np.y() < 0 || np.y() >= this.height || (v = this.outDatas[np.x() + np.y() * this.width]) == (float)this.noDataValue) continue;
                fc = this.frictionDatas[np.x() + np.y() * this.width];
                d = (float)(dd + (double)(this.cellSize / 2.0f) * fd + (double)(this.cellSize / 2.0f * fc));
                if (v != -2.0f && !(d < v)) continue;
                this.outDatas[np.x() + np.y() * this.width] = d;
                this.setPixelAndValue(this.waits, np, d);
            }
            while (ite.hasNext()) {
                np = (Pixel)ite.next();
                if (np.x() < 0 || np.x() >= this.width || np.y() < 0 || np.y() >= this.height || (v = this.outDatas[np.x() + np.y() * this.width]) == (float)this.noDataValue) continue;
                fc = this.frictionDatas[np.x() + np.y() * this.width];
                d = (float)(dd + (double)this.cellSize * Math.sqrt(2.0) / 2.0 * fd + (double)this.cellSize * Math.sqrt(2.0) / 2.0 * (double)fc);
                if (v != -2.0f && !(d < v)) continue;
                this.outDatas[np.x() + np.y() * this.width] = d;
                this.setPixelAndValue(this.waits, np, d);
            }
        }
    }

    @Override
    protected void doClose() {
    }
}

