/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.distance.analysis.euclidian;

import fr.inrae.act.bagap.apiland.analysis.Analysis;
import java.util.Arrays;

public class TabChamferDistanceAnalysis
extends Analysis {
    private static final int[][] chamfer13 = new int[][]{{1, 0, 68}, {1, 1, 96}, {2, 1, 152}, {3, 1, 215}, {3, 2, 245}, {4, 1, 280}, {4, 3, 340}, {5, 1, 346}, {6, 1, 413}};
    private int[][] chamfer = chamfer13;
    private int normalizer = this.chamfer[0][2];
    private int width;
    private int height;
    private float[] outDatas;
    private float[] inDatas;
    private int[] codes;
    private float cellSize;
    private int noDataValue;
    private boolean hasValue;
    private double threshold;

    public TabChamferDistanceAnalysis(float[] outDatas, float[] inDatas, int width, int height, float cellSize, int noDataValue, int[] codes, double threshold) {
        this.outDatas = outDatas;
        this.inDatas = inDatas;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
        this.codes = codes;
        this.threshold = threshold;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    protected void doRun() {
        this.setResult(this.compute());
    }

    private void testAndSet(int x, int y, float newValue) {
        if (x < 0 || x >= this.width) {
            return;
        }
        if (y < 0 || y >= this.height) {
            return;
        }
        double v = this.outDatas[y * this.width + x];
        if (v == (double)this.noDataValue || v >= 0.0 && v < (double)newValue) {
            return;
        }
        this.outDatas[y * this.width + x] = newValue;
    }

    private float[] compute() {
        if (this.hasValue) {
            int dt;
            int dy;
            int dx;
            int k;
            float v;
            int x;
            int y;
            for (y = 0; y <= this.height - 1; ++y) {
                for (x = 0; x <= this.width - 1; ++x) {
                    v = this.outDatas[y * this.width + x];
                    if (v < 0.0f) continue;
                    for (k = 0; k < this.chamfer.length; ++k) {
                        dx = this.chamfer[k][0];
                        dy = this.chamfer[k][1];
                        dt = this.chamfer[k][2];
                        this.testAndSet(x + dx, y + dy, v + (float)dt);
                        if (dy != 0) {
                            this.testAndSet(x - dx, y + dy, v + (float)dt);
                        }
                        if (dx == dy) continue;
                        this.testAndSet(x + dy, y + dx, v + (float)dt);
                        if (dy == 0) continue;
                        this.testAndSet(x - dy, y + dx, v + (float)dt);
                    }
                }
            }
            for (y = this.height - 1; y >= 0; --y) {
                for (x = this.width - 1; x >= 0; --x) {
                    v = this.outDatas[y * this.width + x];
                    if (v < 0.0f) continue;
                    for (k = 0; k < this.chamfer.length; ++k) {
                        dx = this.chamfer[k][0];
                        dy = this.chamfer[k][1];
                        dt = this.chamfer[k][2];
                        this.testAndSet(x - dx, y - dy, v + (float)dt);
                        if (dy != 0) {
                            this.testAndSet(x + dx, y - dy, v + (float)dt);
                        }
                        if (dx == dy) continue;
                        this.testAndSet(x - dy, y - dx, v + (float)dt);
                        if (dy == 0) continue;
                        this.testAndSet(x + dy, y - dx, v + (float)dt);
                    }
                }
            }
        }
        return this.outDatas;
    }

    public float[] normalize() {
        if (this.hasValue) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    float v = this.outDatas[y * this.width + x];
                    if (v == (float)this.noDataValue) continue;
                    float d = v / (float)this.normalizer * this.cellSize;
                    if (this.threshold != (double)this.noDataValue && (double)d > this.threshold) {
                        d = (float)this.threshold;
                    }
                    this.outDatas[y * this.width + x] = d;
                }
            }
        } else {
            Arrays.fill(this.outDatas, (float)this.noDataValue);
        }
        return this.outDatas;
    }

    @Override
    protected void doInit() {
        this.hasValue = false;
        for (int yt = 0; yt < this.height; ++yt) {
            for (int xt = 0; xt < this.width; ++xt) {
                float v = this.inDatas[yt * this.width + xt];
                boolean ok = false;
                if (v != (float)this.noDataValue) {
                    for (int c : this.codes) {
                        if ((float)c != v) continue;
                        ok = true;
                        this.hasValue = true;
                        break;
                    }
                    if (ok) {
                        this.outDatas[yt * this.width + xt] = 0.0f;
                        continue;
                    }
                    this.outDatas[yt * this.width + xt] = -2.0f;
                    continue;
                }
                this.outDatas[yt * this.width + xt] = this.noDataValue;
            }
        }
        this.inDatas = null;
    }

    @Override
    protected void doClose() {
        this.setResult(this.normalize());
        this.inDatas = null;
    }
}

