/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.distance.analysis;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.distance.analysis.DistanceType;
import fr.inrae.act.bagap.chloe.distance.analysis.euclidian.TabChamferDistanceAnalysis;
import fr.inrae.act.bagap.chloe.distance.analysis.functional.TabRCMDistanceAnalysis;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysis;
import java.util.Set;

public class DistanceAnalysis
extends ChloeUtilAnalysis {
    private String outputRaster;
    private String inputRaster;
    private String frictionRaster;
    private DistanceType distanceType;
    private int[] distanceSources;
    private double threshold;
    private float[] inData;
    private float[] frictionData;
    private float[] outData;
    private EnteteRaster entete;

    public DistanceAnalysis(String outputRaster, String inputRaster, String frictionRaster, DistanceType distanceType, Set<Integer> distanceSources, double threshold) {
        this.outputRaster = outputRaster;
        this.inputRaster = inputRaster;
        this.frictionRaster = frictionRaster;
        this.distanceType = distanceType;
        this.distanceSources = new int[distanceSources.size()];
        int index = 0;
        for (Integer s : distanceSources) {
            this.distanceSources[index++] = s;
        }
        this.threshold = threshold;
    }

    @Override
    protected void doInit() {
        Coverage cov = CoverageManager.getCoverage(this.inputRaster);
        this.entete = cov.getEntete();
        this.inData = cov.getData();
        cov.dispose();
        if (this.distanceType == DistanceType.FUNCTIONAL) {
            Coverage covF = CoverageManager.getCoverage(this.frictionRaster);
            this.frictionData = covF.getData();
            covF.dispose();
        }
        this.outData = new float[this.entete.width() * this.entete.height()];
    }

    @Override
    protected void doRun() {
        if (this.distanceType == DistanceType.EUCLIDIAN) {
            TabChamferDistanceAnalysis analysis = new TabChamferDistanceAnalysis(this.outData, this.inData, this.entete.width(), this.entete.height(), this.entete.cellsize(), this.entete.noDataValue(), this.distanceSources, this.threshold);
            analysis.allRun();
        } else if (this.distanceType == DistanceType.FUNCTIONAL) {
            TabRCMDistanceAnalysis analysis = new TabRCMDistanceAnalysis(this.outData, this.inData, this.frictionData, this.entete.width(), this.entete.height(), this.entete.cellsize(), this.entete.noDataValue(), this.distanceSources, this.threshold);
            analysis.allRun();
        }
    }

    @Override
    protected void doClose() {
        CoverageManager.write(this.outputRaster, this.outData, this.entete);
        this.inputRaster = null;
        this.frictionRaster = null;
        this.outputRaster = null;
        this.entete = null;
        this.distanceSources = null;
        this.inData = null;
        this.frictionData = null;
        this.outData = null;
    }
}

