/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.distance;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.distance.analysis.functional.TabRCMDistanceAnalysis;
import fr.inrae.act.bagap.chloe.window.WindowDistanceType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;

public class Script {
    public static void main(String[] args) {
        String inGO2021 = "H:/temp/cont/GO_2021_ebr.tif";
        Coverage covGO = CoverageManager.getCoverage(inGO2021);
        float[] dataGo = covGO.getData();
        EnteteRaster entete = covGO.getEntete();
        covGO.dispose();
        String permGO2021 = "H:/temp/cont/permeability.tif";
        Coverage covPerm = CoverageManager.getCoverage(permGO2021);
        float[] dataPerm = covPerm.getData();
        covPerm.dispose();
        float[] data = new float[entete.width() * entete.height()];
        TabRCMDistanceAnalysis analysis = new TabRCMDistanceAnalysis(data, dataGo, dataPerm, entete.width(), entete.height(), entete.cellsize(), entete.noDataValue(), new int[]{13});
        analysis.allRun();
        String rasterCont = "H:/temp/cont/continuity.tif";
        CoverageManager.writeGeotiff(rasterCont, data, entete);
    }

    private static void scriptHeterogeneity() {
        String inGO2021 = "H:/temp/cont/GO_2021_ebr.tif";
        long begin = System.currentTimeMillis();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setRasterFile(inGO2021);
        builder.setWindowSize(201);
        builder.setDisplacement(20);
        builder.addMetric("SHDI");
        builder.addGeoTiffOutput("SHDI", "H:/temp/cont/shdi.tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }
}

