/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.util;

import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.util.Util;
import java.io.File;

public class CompileMNHC {
    public static void compile(String outputPath, String outputName, String ... inputPath) {
        Util.createAccess(outputPath);
        for (String input : inputPath) {
            File deptFolder = new File(input);
            for (String file : deptFolder.list()) {
                if (!file.endsWith(".tif")) continue;
                String[] f = file.replace(".tif", "").split("_");
                int it = Integer.parseInt(f[3]);
                int jt = Integer.parseInt(f[4]);
                String outFile = outputPath + outputName + "_" + it + "_" + jt + ".tif";
                if (new File(outFile).exists()) {
                    Coverage covOutFile = CoverageManager.getCoverage(outFile);
                    float[] dataOutFile = covOutFile.getData();
                    EnteteRaster entete = covOutFile.getEntete();
                    covOutFile.dispose();
                    Coverage covInFile = CoverageManager.getCoverage(deptFolder.getAbsolutePath() + "/" + file);
                    float[] dataInFile = covInFile.getData();
                    covInFile.dispose();
                    Pixel2PixelTabCalculation pptc = new Pixel2PixelTabCalculation(dataOutFile, new float[][]{dataOutFile, dataInFile}){

                        @Override
                        protected float doTreat(float[] v) {
                            return Math.max(v[0], v[1]);
                        }
                    };
                    pptc.run();
                    CoverageManager.writeGeotiff(outFile, dataOutFile, entete);
                    continue;
                }
                Tool.copy(deptFolder.getAbsolutePath() + "/" + file, outFile);
            }
        }
    }
}

