/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.script;

import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.territory.GrainBocagerTerritoire;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.territory.GrainBocagerTerritoireBuilder;

public class ScriptTerritoire {
    public static void main(String[] args) {
        ScriptTerritoire.scriptMartigneFerchaud();
    }

    private static void scriptRennesMetropole() {
        long begin = System.currentTimeMillis();
        GrainBocagerTerritoireBuilder builder = new GrainBocagerTerritoireBuilder();
        builder.setOutputPath("H:/rennes_metropole/grain_bocager/");
        builder.setBocage("H:/IGN/data/35_2020_5m/mean/");
        builder.setTerritoire("H:/rennes_metropole/data/communes_rennes_metropole_L93.shp");
        builder.setName("rm");
        builder.setBufferArea(5000);
        builder.setOutCellSize(50.0);
        GrainBocagerTerritoire gbTerritoire = builder.build();
        gbTerritoire.run();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void scriptRSELeRheu() {
        long begin = System.currentTimeMillis();
        GrainBocagerTerritoireBuilder builder = new GrainBocagerTerritoireBuilder();
        builder.setOutputPath("H:/rse/grain_bocager_50m/");
        builder.setBocage("H:/IGN/data/35_2020_5m/mean/");
        builder.setTerritoire("H:/rse/data/Donn\u00ef\u00bf\u00bdesRHEU_Hugues/rse_lerheu.shp");
        builder.setName("rse_lerheu_50m");
        builder.setOutCellSize(50.0);
        GrainBocagerTerritoire gbTerritoire = builder.build();
        gbTerritoire.run();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void test() {
        Coverage covGrainBocager = CoverageManager.getCoverage("H:/questembert/grain_bocager/grain_bocager.tif");
        EnteteRaster entete = covGrainBocager.getEntete();
        float[] dataGrainBocager = covGrainBocager.getData();
        covGrainBocager.dispose();
        Coverage covDistanceBoisement = CoverageManager.getCoverage("H:/questembert/grain_bocager/distance_boisement_questembert.tif");
        float[] dataDistanceBoisement = covDistanceBoisement.getData();
        covDistanceBoisement.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation pptcc = new Pixel2PixelTabCalculation(data, new float[][]{dataGrainBocager, dataDistanceBoisement}){

            @Override
            protected float doTreat(float[] v) {
                return 1.0f - (1.0f - v[0]) * (1.0f - v[1]);
            }
        };
        pptcc.run();
        CoverageManager.write("H:/questembert/grain_bocager/test.tif", data, entete);
    }

    private static void scriptCUMAQuestembert() {
        GrainBocagerTerritoireBuilder builder = new GrainBocagerTerritoireBuilder();
        builder.setOutputPath("H:/questembert/grain_bocager/");
        builder.setBocage("H:/IGN/data/56_2019_5m/mean/");
        builder.setTerritoire("H:/questembert/data/communes_CUMA_questembert.shp");
        builder.setName("questembert");
        GrainBocagerTerritoire gbTerritoire = builder.build();
        gbTerritoire.run();
    }

    private static void scriptMartigneFerchaud() {
        String scenario = "simule_";
    }
}

