/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.script;

import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import java.util.HashMap;
import org.locationtech.jts.geom.Envelope;

public class ScriptRetile {
    public static void main(String[] args) {
    }

    private static void retile() {
    }

    private static void compileMNH() {
        String path = "E:/FRC_AURA/data/grain2d/CVB/";
        Coverage cov38 = CoverageManager.getCoverage(path + "MNH_CVB_38.tif");
        float[] data38 = cov38.getData();
        EnteteRaster entete = cov38.getEntete();
        cov38.dispose();
        Coverage cov42 = CoverageManager.getCoverage(path + "MNH_CVB_42.tif");
        float[] data42 = cov42.getData();
        cov42.dispose();
        Coverage cov69 = CoverageManager.getCoverage(path + "MNH_CVB_69.tif");
        float[] data69 = cov69.getData();
        cov69.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{data38, data42, data69}){

            @Override
            protected float doTreat(float[] v) {
                float v0 = v[0];
                float v1 = v[1];
                float v2 = v[2];
                if (v0 == -1.0f || v1 == -1.0f || v2 == -1.0f) {
                    return -1.0f;
                }
                if (v0 == 10.0f || v1 == 10.0f || v2 == 10.0f) {
                    return 10.0f;
                }
                return 0.0f;
            }
        };
        cal.run();
        CoverageManager.write(path + "MNH_CVB.tif", data, entete);
    }

    private static Envelope getEnvelope() {
        String path = "E:/FRC_AURA/data/grain2d/CVB/";
        Envelope envIsere = ShapeFile2CoverageConverter.getEnvelope(path + "CVB_Isere.shp", 1000.0);
        Envelope envLoire = ShapeFile2CoverageConverter.getEnvelope(path + "CVB_Loire.shp", 1000.0);
        Envelope envRhone = ShapeFile2CoverageConverter.getEnvelope(path + "CVB_Rhone.shp", 1000.0);
        double minx = Math.min(Math.min(envIsere.getMinX(), envLoire.getMinX()), envRhone.getMinX());
        double maxx = Math.max(Math.max(envIsere.getMaxX(), envLoire.getMaxX()), envRhone.getMaxX());
        double miny = Math.min(Math.min(envIsere.getMinY(), envLoire.getMinY()), envRhone.getMinY());
        double maxy = Math.max(Math.max(envIsere.getMaxY(), envLoire.getMaxY()), envRhone.getMaxY());
        Envelope env = new Envelope(minx, maxx, miny, maxy);
        System.out.println(envIsere);
        System.out.println(envLoire);
        System.out.println(envRhone);
        System.out.println(env);
        return env;
    }

    private static void prepaMNH(String dpt, Envelope env) {
        String path = "E:/FRC_AURA/data/grain2d/";
        String localPath = path + dpt + "/";
        EnteteRaster entete = EnteteRaster.getEntete(env, 5.0f, -1);
        HashMap<String, Integer> codes = new HashMap<String, Integer>();
        codes.put("Bois", 10);
        codes.put("For\u00c3\u00aat ferm\u00c3\u00a9e de feuillus", 10);
        codes.put("For\u00c3\u00aat ferm\u00c3\u00a9e de conif\u00c3\u00a8res", 10);
        codes.put("For\u00c3\u00aat ferm\u00c3\u00a9e mixte", 10);
        codes.put("For\u00c3\u00aat ouverte", 10);
        codes.put("Haie", 10);
        codes.put("Lande ligneuse", 0);
        codes.put("Peupleraie", 10);
        codes.put("Verger", 0);
        codes.put("Vigne", 0);
        Coverage covWood = ShapeFile2CoverageConverter.getSurfaceCoverage(localPath + "data/ZONE_DE_VEGETATION.shp", "NATURE", codes, entete, 0.0f);
        float[] dataWood = covWood.getData();
        covWood.dispose();
        Coverage covHedge = ShapeFile2CoverageConverter.getLinearCoverage(localPath + "data/HAIE.shp", entete, 10.0f, 0.0f, 5.0);
        float[] dataHedge = covHedge.getData();
        covHedge.dispose();
        for (int i = 0; i < entete.width() * entete.height(); ++i) {
            dataWood[i] = Math.max(dataHedge[i], dataWood[i]);
        }
        String outputPath = "E:/FRC_AURA/data/grain2d/CVB/";
        CoverageManager.write(outputPath + "MNH_CVB_" + dpt + ".tif", dataWood, entete);
    }
}

