/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.script;

import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisType;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerManager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedure;
import fr.inrae.act.bagap.chloe.concept.grainbocager.util.CompileMNHC;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;

public class ScriptLeandre {
    public static void main(String[] args) {
    }

    private static void analyseGrainCommune() {
        ScriptLeandre.analyseGrainContinueCleanCommune();
        ScriptLeandre.analyseGrain4ClassesCleanCommune();
    }

    private static void analyseGrain4ClassesCommune() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile("H:/leandre/grain_bocager/grain_bocager_4Classes_50m.tif");
        builder.setEntityRasterFile("H:/leandre/data/communes.tif");
        builder.addMetric("pN-valid");
        builder.addMetric("pNVm_1&2");
        builder.addCsvOutput("H:/leandre/grain_bocager/analyse/analyse_communes_grain_bocager_4Classes.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void analyseGrain4ClassesCleanCommune() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile("H:/leandre/grain_bocager/grain_bocager_4Classes_50m_clean.tif");
        builder.setEntityRasterFile("H:/leandre/data/communes.tif");
        builder.addMetric("pNVm_1&2");
        builder.addCsvOutput("H:/leandre/grain_bocager/analyse/analyse_communes_grain_bocager_4Classes_clean.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void analyseGrainContinueCommune() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile("H:/leandre/grain_bocager/grain_bocager_50m.tif");
        builder.setEntityRasterFile("H:/leandre/data/communes.tif");
        builder.addMetric("pN-valid");
        builder.addCsvOutput("H:/leandre/grain_bocager/analyse/analyse_communes_grain_bocager_continue.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void analyseGrainContinueCleanCommune() {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setAnalysisType(ChloeAnalysisType.ENTITY);
        builder.setRasterFile("H:/leandre/grain_bocager/grain_bocager_50m_clean.tif");
        builder.setEntityRasterFile("H:/leandre/data/communes.tif");
        builder.addMetric("pN-valid");
        builder.addMetric("average");
        builder.addCsvOutput("H:/leandre/grain_bocager/analyse/analyse_communes_grain_bocager_clean_continue.csv");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void rasterizeCommune() {
        Coverage cov = CoverageManager.getCoverage("H:/leandre/grain_bocager/grain_bocager_50m.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage covCommune = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/leandre/data/communes.shp", "insee", entete, -1);
        CoverageManager.writeGeotiff("H:/leandre/data/communes.tif", covCommune.getData(), entete);
        covCommune.dispose();
    }

    private static void cleanGrainBocager() {
        Coverage covUrbain = CoverageManager.getCoverage("H:/leandre/grain_bocager/urbain.tif");
        EnteteRaster entete = covUrbain.getEntete();
        float[] dataUrbain = covUrbain.getData();
        covUrbain.dispose();
        Coverage covGC = CoverageManager.getCoverage("H:/leandre/grain_bocager/grain_bocager_50m.tif");
        float[] dataGC = covGC.getData();
        covGC.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation pptc = new Pixel2PixelTabCalculation(data, new float[][]{dataGC, dataUrbain}){

            @Override
            protected float doTreat(float[] v) {
                if (v[0] == -1.0f) {
                    return -1.0f;
                }
                if (v[1] == 1.0f) {
                    return -1.0f;
                }
                return v[0];
            }
        };
        pptc.run();
        CoverageManager.writeGeotiff("H:/leandre/grain_bocager/grain_bocager_50m_clean.tif", data, entete);
        Coverage covG4 = CoverageManager.getCoverage("H:/leandre/grain_bocager/grain_bocager_4Classes_50m.tif");
        float[] dataG4 = covG4.getData();
        covG4.dispose();
        data = new float[entete.width() * entete.height()];
        pptc = new Pixel2PixelTabCalculation(data, new float[][]{dataG4, dataUrbain}){

            @Override
            protected float doTreat(float[] v) {
                if (v[0] == -1.0f) {
                    return -1.0f;
                }
                if (v[1] == 1.0f) {
                    return -1.0f;
                }
                return v[0];
            }
        };
        pptc.run();
        CoverageManager.writeGeotiff("H:/leandre/grain_bocager/grain_bocager_4Classes_50m_clean.tif", data, entete);
    }

    private static void rasterizeUrbain() {
        Coverage cov = CoverageManager.getCoverage("H:/leandre/grain_bocager/grain_bocager_50m.tif");
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        Coverage covUrbain22 = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/bd_topo/zones_habitations/ZONE_D_HABITATION_22_2022.shp", entete, 1.0f, 0.0f);
        Coverage covUrbain29 = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/bd_topo/zones_habitations/ZONE_D_HABITATION_29_2021.shp", entete, 1.0f, 0.0f);
        Coverage covUrbain35 = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/bd_topo/zones_habitations/ZONE_D_HABITATION_35_2022.shp", entete, 1.0f, 0.0f);
        Coverage covUrbain44 = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/bd_topo/zones_habitations/ZONE_D_HABITATION_44_2022.shp", entete, 1.0f, 0.0f);
        Coverage covUrbain56 = ShapeFile2CoverageConverter.getSurfaceCoverage("H:/bd_topo/zones_habitations/ZONE_D_HABITATION_56_2021.shp", entete, 1.0f, 0.0f);
        float[] dataUrbain = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation pptc = new Pixel2PixelTabCalculation(dataUrbain, new float[][]{covUrbain22.getData(), covUrbain29.getData(), covUrbain35.getData(), covUrbain44.getData(), covUrbain56.getData()}){

            @Override
            protected float doTreat(float[] v) {
                if (v[0] == 1.0f || v[1] == 1.0f || v[2] == 1.0f || v[3] == 1.0f || v[4] == 1.0f) {
                    return 1.0f;
                }
                return 0.0f;
            }
        };
        pptc.run();
        covUrbain22.dispose();
        covUrbain29.dispose();
        covUrbain35.dispose();
        covUrbain44.dispose();
        covUrbain56.dispose();
        CoverageManager.writeGeotiff("H:/leandre/grain_bocager/urbain.tif", dataUrbain, entete);
    }

    private static void scriptDetectionTypeBoisement() {
        GrainBocagerManager gbManager = new GrainBocagerManager("detection_type_boisement");
        gbManager.setFastMode(true);
        gbManager.setTile("H:/leandre/grain_bocager/mnhc/");
        gbManager.setWoodHeight("H:/leandre/grain_bocager/mnhc/");
        gbManager.setOutputFolder("H:/leandre/grain_bocager/");
        gbManager.setWoodType("H:/leandre/grain_bocager/type_boisement/");
        GrainBocagerProcedure gbProcedure = gbManager.build();
        gbProcedure.run();
    }

    private static void scriptCalculDistanceInfluenceBoisement() {
        GrainBocagerManager gbManager = new GrainBocagerManager("calcul_distance_influence_boisement");
        gbManager.setFastMode(true);
        gbManager.setTile("H:/leandre/grain_bocager/mnhc/");
        gbManager.setWoodHeight("H:/leandre/grain_bocager/mnhc/");
        gbManager.setWoodType("H:/leandre/grain_bocager/type_boisement/");
        gbManager.setInfluenceDistance("H:/leandre/grain_bocager/distance_influence_boisement/");
        GrainBocagerProcedure gbProcedure = gbManager.build();
        gbProcedure.run();
    }

    private static void scriptCalculGrainBocager() {
        GrainBocagerManager gbManager = new GrainBocagerManager("calcul_grain_bocager");
        gbManager.setInfluenceDistance("H:/leandre/grain_bocager/distance_boisement/");
        gbManager.setGrainBocagerCellSize(50.0);
        gbManager.setGrainBocager("H:/leandre/grain_bocager/grain_bocager_50m.tif");
        gbManager.setGrainBocager4Classes("H:/leandre/grain_bocager/grain_bocager_4Classes_50m.tif");
        GrainBocagerProcedure gbProcedure = gbManager.build();
        gbProcedure.run();
    }

    private void compilationMNHC() {
        String outputPath = "H:/leandre/grain_bocager/mnhc/";
        String outputName = "mnhc";
        String[] inputPath = new String[]{"H:/IGN/data/22_2018_5m/mean/", "H:/IGN/data/29_2018_5m/mean/", "H:/IGN/data/35_2020_5m/mean/", "H:/IGN/data/44_2020_5m/mean/", "H:/IGN/data/56_2019_5m/mean/"};
        CompileMNHC.compile(outputPath, outputName, inputPath);
    }
}

