/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.script;

import fr.inrae.act.bagap.apiland.analysis.tab.ClassificationPixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.analysis.tab.SearchAndReplacePixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.domain.Domain;
import fr.inrae.act.bagap.apiland.domain.DomainFactory;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.cluster.chess.TabQueenClusteringAnalysis;
import fr.inrae.act.bagap.chloe.cluster.distance.TabDistanceClusteringAnalysis;
import fr.inrae.act.bagap.chloe.distance.analysis.euclidian.TabChamferDistanceAnalysis;
import fr.inrae.act.bagap.chloe.distance.analysis.functional.TabRCMDistanceAnalysis;
import fr.inrae.act.bagap.chloe.window.WindowDistanceType;
import fr.inrae.act.bagap.chloe.window.WindowShapeType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import java.awt.Rectangle;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.TreeMap;

public class ScriptGMB {
    private static String path = "C:/Data/projet/gmb/data/";

    public static void main(String[] args) {
        long begin = System.currentTimeMillis();
        long end = System.currentTimeMillis();
        System.out.println("time computing : " + (end - begin));
    }

    private static void analyseClustersHabitat(String cluster_continuite, int echelle) {
        File f = new File(cluster_continuite);
        String name = f.getName().replaceAll(".tif", "");
        int windowSize = echelle * 2 / 10 + 1;
        System.out.println(windowSize);
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterFile(cluster_continuite);
        builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        builder.setWindowSize(windowSize);
        builder.setDisplacement(20);
        builder.addMetric("pN-values");
        builder.addMetric("SHDI-frag");
        builder.addGeoTiffOutput("pN-values", path + "proportion_" + name + ".tif");
        builder.addGeoTiffOutput("SHDI-frag", path + "fragmentation_" + name + ".tif");
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void meanDistance(String classification_continuite, int nbDomains, int dMax) {
        File f = new File(classification_continuite);
        String name = f.getName().replaceAll(".tif", "");
        Coverage covK = CoverageManager.getCoverage(path + "distance_1_" + name + "_" + dMax + "m.tif");
        float[] data = covK.getData();
        EnteteRaster entete = covK.getEntete();
        covK.dispose();
        for (int k = 2; k < nbDomains; ++k) {
            covK = CoverageManager.getCoverage(path + "distance_" + k + "_" + name + "_" + dMax + "m.tif");
            float[] dataK = covK.getData();
            covK.dispose();
            for (int i = 0; i < data.length; ++i) {
                float v = data[i];
                if (v == (float)entete.noDataValue()) continue;
                data[i] = (v * (float)(k - 1) + dataK[i]) / (float)k;
            }
        }
        CoverageManager.writeGeotiff(path + "distance_mean_" + name + "_" + dMax + "m.tif", data, entete);
    }

    private static void clusteringContinuite(String classification_continuite, String permeabilite, int nbDomains, int dMax) {
        File f = new File(classification_continuite);
        String name = f.getName().replaceAll(".tif", "");
        Coverage covClassif = CoverageManager.getCoverage(classification_continuite);
        float[] dataClassif = covClassif.getData();
        EnteteRaster entete = covClassif.getEntete();
        covClassif.dispose();
        Coverage covPermeabilite = CoverageManager.getCoverage(permeabilite);
        float[] dataPermeabilite = covPermeabilite.getData();
        covPermeabilite.dispose();
        for (int k = nbDomains; k > 0; --k) {
            System.out.println(k);
            int[] values = new int[nbDomains - k + 1];
            int v = k;
            int i = 0;
            while (v <= nbDomains) {
                values[i] = v++;
                ++i;
            }
            float[] dataDistance = new float[entete.width() * entete.height()];
            TabRCMDistanceAnalysis da = new TabRCMDistanceAnalysis(dataDistance, dataClassif, dataPermeabilite, entete.width(), entete.height(), entete.cellsize(), entete.noDataValue(), values, entete.noDataValue());
            da.allRun();
            CoverageManager.writeGeotiff(path + "distance_" + k + "_" + name + "_" + dMax + "m.tif", dataDistance, entete);
            TabDistanceClusteringAnalysis ca = new TabDistanceClusteringAnalysis(dataClassif, dataDistance, entete.width(), entete.height(), values, dMax, entete.noDataValue());
            float[] dataCluster = (float[])ca.allRun();
            CoverageManager.writeGeotiff(path + "cluster_" + k + "_" + name + "_" + dMax + "m.tif", dataCluster, entete);
        }
    }

    private static void classificationContinuite(String indice_deplacement, double min, double max, double step) {
        File f = new File(indice_deplacement);
        String name = f.getName().replaceAll(".tif", "");
        Coverage cov = CoverageManager.getCoverage(indice_deplacement);
        float[] inData = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        entete.setNoDataValue(-1);
        float[] dataClassif = new float[entete.width() * entete.height()];
        double dmin = min * 10.0;
        double dstep = step * 10.0;
        double dmax = max * 10.0;
        int domain = 0;
        LinkedHashMap<Domain<Float, Float>, Integer> domains = new LinkedHashMap<Domain<Float, Float>, Integer>();
        domains.put(DomainFactory.getFloatDomain("[0," + dmin / 10.0 + "]"), domain++);
        for (double d = dmin + dstep; d <= dmax; d += dstep) {
            System.out.println(dmin / 10.0 + " " + d / 10.0 + " " + dmax / 10.0 + " " + domain);
            if (d < dmax) {
                domains.put(DomainFactory.getFloatDomain("]" + dmin / 10.0 + "," + d / 10.0 + "]"), domain++);
            } else {
                domains.put(DomainFactory.getFloatDomain("]" + dmin / 10.0 + ",]"), domain++);
            }
            dmin = d;
        }
        for (Domain d : domains.keySet()) {
            System.out.println(d);
        }
        ClassificationPixel2PixelTabCalculation cal = new ClassificationPixel2PixelTabCalculation(dataClassif, inData, entete.noDataValue(), domains);
        cal.run();
        CoverageManager.write(path + "classif_" + name + ".tif", dataClassif, entete);
    }

    private static void distanceFromHabitat(int dMax) {
        Coverage covHabitat = CoverageManager.getCoverage(path + "habitats.tif");
        float[] dataHabitat = covHabitat.getData();
        EnteteRaster entete = covHabitat.getEntete();
        covHabitat.dispose();
        Coverage covPermeabilite = CoverageManager.getCoverage(path + "Couts_0-10_MusAve2025_SansSeuillage_modelANN_13var.tif");
        float[] dataPermeabilite = covPermeabilite.getData();
        covPermeabilite.dispose();
        float[] dataDistance = new float[entete.width() * entete.height()];
        TabRCMDistanceAnalysis da = new TabRCMDistanceAnalysis(dataDistance, dataHabitat, dataPermeabilite, entete.width(), entete.height(), entete.cellsize(), entete.noDataValue(), new int[]{1}, dMax);
        da.allRun();
        CoverageManager.write(path + "distance_habitat_" + dMax + "m.tif", dataDistance, entete);
    }

    private static void clusterFromHabitat(int dMax) {
        Coverage covHabitat = CoverageManager.getCoverage(path + "habitats_clean.tif");
        float[] dataHabitat = covHabitat.getData();
        EnteteRaster entete = covHabitat.getEntete();
        covHabitat.dispose();
        Coverage covDistance = CoverageManager.getCoverage(path + "distance_habitat_clean_" + dMax + "m.tif");
        float[] dataDistance = covDistance.getData();
        covDistance.dispose();
        float[] dataCluster = new float[entete.width() * entete.height()];
        TabDistanceClusteringAnalysis ca = new TabDistanceClusteringAnalysis(dataHabitat, dataDistance, entete.width(), entete.height(), new int[]{1}, dMax, entete.noDataValue());
        dataCluster = (float[])ca.allRun();
        CoverageManager.write(path + "cluster_habitat_clean_" + dMax + "m.tif", dataCluster, entete);
    }

    private static void clusteringContinuity(String indice_deplacement) {
        int nbDomains;
        File f = new File(indice_deplacement);
        String name = f.getName().replaceAll(".tif", "");
        Coverage cov = CoverageManager.getCoverage(indice_deplacement);
        float[] inData = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        entete.setNoDataValue(-1);
        float[] dataClassif = new float[entete.width() * entete.height()];
        HashMap<Domain<Float, Float>, Integer> domains = new HashMap<Domain<Float, Float>, Integer>();
        float dmin = 0.0f;
        float dstep = 0.5f;
        float dmax = 5.0f;
        int domain = 1;
        float d = dmin + dstep;
        while (d <= dmax) {
            if (domain == 0) {
                domains.put(DomainFactory.getFloatDomain("[" + dmin + "," + d + "]"), domain);
            }
            if (d < dmax) {
                domains.put(DomainFactory.getFloatDomain("]" + dmin + "," + d + "]"), domain);
            } else {
                domains.put(DomainFactory.getFloatDomain("]" + dmin + ",]"), domain);
            }
            dmin = d;
            d += dstep;
            ++domain;
        }
        ClassificationPixel2PixelTabCalculation cal = new ClassificationPixel2PixelTabCalculation(dataClassif, inData, entete.noDataValue(), domains);
        cal.run();
        CoverageManager.write(path + "classif_" + name + ".tif", dataClassif, entete);
        for (int k = nbDomains = domains.size() - 1; k > 0; --k) {
            int[] values = new int[nbDomains - k + 1];
            int v = k;
            int i = 0;
            while (v <= nbDomains) {
                values[i] = v++;
                ++i;
            }
            TabQueenClusteringAnalysis ca = new TabQueenClusteringAnalysis(dataClassif, entete.width(), entete.height(), values, entete.noDataValue());
            float[] dataCluster = (float[])ca.allRun();
            CoverageManager.writeGeotiff(path + "cluster_" + k + "_" + name + ".tif", dataCluster, entete);
        }
    }

    private static void calculIndiceContinuite(String output, String input, final int dMax) {
        Coverage cov = CoverageManager.getCoverage(input);
        float[] data = cov.getData();
        EnteteRaster entete = cov.getEntete();
        cov.dispose();
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, (float[][])new float[][]{data}){

            @Override
            protected float doTreat(float[] v) {
                return (float)((double)v[0] / (Math.pow(dMax, 2.0) * Math.PI * (double)dMax) / 3.0);
            }
        };
        cal.run();
        CoverageManager.write(output, outData, entete);
    }

    private static void continuitesBoisees(String continuites, String permeabilite, int dMax, int windowSize) {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setRasterFile(permeabilite);
        builder.setRasterFile2(permeabilite);
        builder.setWindowSize(windowSize);
        builder.addMetric("volume");
        builder.setDMax(dMax);
        builder.addGeoTiffOutput("volume", continuites);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    private static void cleanPermeabilite(String output, String input) {
        Coverage cov = CoverageManager.getCoverage(input);
        EnteteRaster entete = cov.getEntete();
        float[] data = cov.getData();
        cov.dispose();
        final int newNoDataValue = -1;
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, (float[][])new float[][]{data}){

            @Override
            protected float doTreat(float[] v) {
                float vD = v[0];
                if (vD < 0.0f) {
                    return newNoDataValue;
                }
                return vD;
            }
        };
        cal.run();
        entete.setNoDataValue(newNoDataValue);
        CoverageManager.write(output, data, entete);
    }

    private static void convertPermeabilite() {
        Coverage covDist = CoverageManager.getCoverage(path + "Couts_0-100_MusAve2025_SansSeuillage_modelANN_13var.tif");
        final EnteteRaster entete = covDist.getEntete();
        float[] dataDist = covDist.getData();
        covDist.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, (float[][])new float[][]{dataDist}){

            @Override
            protected float doTreat(float[] v) {
                float vD = v[0];
                if (vD != (float)entete.noDataValue()) {
                    if ((vD /= 10.0f) == 0.0f) {
                        return 0.1f;
                    }
                    return vD;
                }
                return entete.noDataValue();
            }
        };
        cal.run();
        CoverageManager.write(path + "Couts_0-10_MusAve2025_SansSeuillage_modelANN_13var.tif", data, entete);
    }

    private static void convertHabitat() {
        Coverage covDist = CoverageManager.getCoverage(path + "Couts_MusAve2025_Seuil0.188_modelANN_13var.tif");
        final EnteteRaster entete = covDist.getEntete();
        float[] dataDist = covDist.getData();
        covDist.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, (float[][])new float[][]{dataDist}){

            @Override
            protected float doTreat(float[] v) {
                float vD = v[0];
                if (vD != (float)entete.noDataValue()) {
                    if (vD != 1.0f) {
                        return 2.0f;
                    }
                    return 1.0f;
                }
                return entete.noDataValue();
            }
        };
        cal.run();
        CoverageManager.write(path + "habitats.tif", data, entete);
    }

    private static void generatePermeabiliteDistribution() {
        Coverage covDist = CoverageManager.getCoverage(path + "DistributionPotentielleMuscardin2025_Modelisation13var-Raster10m_BzhHisto_L93.tif");
        final EnteteRaster entete = covDist.getEntete();
        float[] dataDist = covDist.getData();
        covDist.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, (float[][])new float[][]{dataDist}){

            @Override
            protected float doTreat(float[] v) {
                float vD = v[0];
                if (vD != (float)entete.noDataValue()) {
                    return (float)(-0.1 * (double)vD + 10.0);
                }
                return entete.noDataValue();
            }
        };
        cal.run();
        CoverageManager.write(path + "permeabilite_distribution.tif", data, entete);
    }

    private static void generatePermeabiliteTest() {
        Coverage covDist = CoverageManager.getCoverage(path + "test.tif");
        final EnteteRaster entete = covDist.getEntete();
        float[] dataDist = covDist.getData();
        covDist.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, (float[][])new float[][]{dataDist}){

            @Override
            protected float doTreat(float[] v) {
                float vD = v[0];
                if (vD != (float)entete.noDataValue()) {
                    return (float)(-0.1 * (double)vD + 10.0);
                }
                return entete.noDataValue();
            }
        };
        cal.run();
        CoverageManager.write(path + "test_permeabilite.tif", data, entete);
    }

    private static void generatePermeabilite() {
        Coverage covOS = CoverageManager.getCoverage(path + "sousOS.tif");
        EnteteRaster entete = covOS.getEntete();
        float[] dataOS = covOS.getData();
        covOS.dispose();
        TreeMap<Float, Float> sarMap = new TreeMap<Float, Float>();
        sarMap.put(Float.valueOf(1.0f), Float.valueOf(100.0f));
        sarMap.put(Float.valueOf(2.0f), Float.valueOf(100.0f));
        sarMap.put(Float.valueOf(3.0f), Float.valueOf(100.0f));
        sarMap.put(Float.valueOf(4.0f), Float.valueOf(1.0f));
        sarMap.put(Float.valueOf(5.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(6.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(7.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(9.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(10.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(12.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(13.0f), Float.valueOf(2.0f));
        sarMap.put(Float.valueOf(14.0f), Float.valueOf(2.0f));
        sarMap.put(Float.valueOf(15.0f), Float.valueOf(5.0f));
        sarMap.put(Float.valueOf(16.0f), Float.valueOf(10.0f));
        sarMap.put(Float.valueOf(17.0f), Float.valueOf(0.1f));
        sarMap.put(Float.valueOf(18.0f), Float.valueOf(0.1f));
        sarMap.put(Float.valueOf(19.0f), Float.valueOf(2.0f));
        sarMap.put(Float.valueOf(20.0f), Float.valueOf(0.1f));
        sarMap.put(Float.valueOf(23.0f), Float.valueOf(100.0f));
        float[] data = new float[entete.width() * entete.height()];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(data, dataOS, sarMap);
        cal.run();
        float[] distanceData = new float[entete.width() * entete.height()];
        TabChamferDistanceAnalysis distance = new TabChamferDistanceAnalysis(distanceData, dataOS, entete.width(), entete.height(), entete.cellsize(), entete.noDataValue(), new int[]{16}, 10.0);
        distance.allRun();
        for (int i = 0; i < data.length; ++i) {
            float dd = distanceData[i];
            if (!(dd > 0.0f) || !(dd < 10.0f)) continue;
            data[i] = 0.1f;
        }
        CoverageManager.write(path + "sous_permeabilite.tif", data, entete);
    }

    private static void retile2() {
        Coverage covOS = CoverageManager.getCoverage("F:/data/sig/bretagne/bretagne_2021_ebr_clean.tif");
        EnteteRaster entete = covOS.getEntete();
        Rectangle ROI = new Rectangle(26000, 11800, 2000, 2000);
        EnteteRaster localEntete = EnteteRaster.getEntete(entete, ROI);
        float[] dataOS = covOS.getData(ROI);
        covOS.dispose();
        CoverageManager.write(path + "sousOS.tif", dataOS, localEntete);
    }

    private static void retile() {
        Coverage covOS = CoverageManager.getCoverage(path + "DistributionPotentielleMuscardin2025_Modelisation13var-Raster10m_BzhHisto_L93.tif");
        EnteteRaster entete = covOS.getEntete();
        Rectangle ROI = new Rectangle(10000, 5000, 1000, 1000);
        EnteteRaster localEntete = EnteteRaster.getEntete(entete, ROI);
        float[] dataOS = covOS.getData(ROI);
        covOS.dispose();
        CoverageManager.write(path + "test.tif", dataOS, localEntete);
    }
}

