/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.script;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.farm.DiagnosticGrainBocagerExploitation;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.farm.DiagnosticGrainBocagerExploitationManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.TreeMap;
import java.util.TreeSet;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.jumpmind.symmetric.csv.CsvWriter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class ScriptDiagEABretagne {
    public static void main(String[] args) {
        ScriptDiagEABretagne.recuperationEnveloppesExploitations();
    }

    private static void scriptExploitationsBretagne() {
        String[] codesExploitation = ScriptDiagEABretagne.recuperationCodesExploitation();
        String outputFolder = "F:/FDCCA/diag_ea/data/analyse_bretagne/";
        boolean exportMap = true;
        CsvWriter writer = DiagnosticGrainBocagerExploitation.prepareIndices("F:/FDCCA/diag_ea/data/analyse_bretagne/analyse_bretagne_ea.csv");
        int nb = 0;
        for (String codeExploitation : codesExploitation) {
            System.out.println("diagnostique sur exploitation " + codeExploitation);
            if (!ScriptDiagEABretagne.scriptExploitation(outputFolder, codeExploitation, 5, writer, exportMap)) continue;
            ++nb;
        }
        System.out.println("nombre d'EA analysees = " + nb + " / " + codesExploitation.length);
        DiagnosticGrainBocagerExploitation.fermeIndices(writer);
    }

    private static boolean scriptExploitation(String outputFolder, String exploitation, int outCellSize, CsvWriter writer, boolean exportMap) {
        DiagnosticGrainBocagerExploitationManager manager = new DiagnosticGrainBocagerExploitationManager();
        manager.setOutputFolder(outputFolder);
        if (writer != null) {
            manager.setWriter(writer);
        }
        manager.setParcellaire(outputFolder + "056046330/056046330.shp");
        manager.setAttributCodeEA("pacage");
        manager.setCodeEA(exploitation);
        manager.setBocage("F:/FDCCA/diag_ea/data/mnhc/");
        manager.setScenario("initial");
        manager.setGrainBocagerCellSize(outCellSize);
        manager.setExportMap(exportMap);
        DiagnosticGrainBocagerExploitation diagEA = manager.build();
        return diagEA.run();
    }

    private static void cleanMNHC() {
        File f = new File("F:/FDCCA/diag_ea/data/mnhc/");
        for (File file : f.listFiles()) {
            Coverage cov = CoverageManager.getCoverage(file.getAbsolutePath());
            float[] data = cov.getData();
            EnteteRaster entete = cov.getEntete();
            cov.dispose();
            entete = new EnteteRaster(entete.width(), entete.height(), Math.round(entete.minx()), Math.round(entete.maxx()), Math.round(entete.miny()), Math.round(entete.maxy()), entete.cellsize(), entete.noDataValue(), entete.crs());
            CoverageManager.write(file.getAbsolutePath(), data, entete);
        }
    }

    private static String[] recuperationCodesExploitation() {
        String parcellaire = "C:/Data/data/rpg/bretagne_2023/parcelles_geom_2023_r53.shp";
        String attributeCodeEA = "pacage";
        try {
            ShpFiles sf = new ShpFiles(parcellaire);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader header = dfr.getHeader();
            int ideaNumber = -1;
            for (int i = 0; i < header.getNumFields(); ++i) {
                if (!header.getFieldName(i).equalsIgnoreCase(attributeCodeEA)) continue;
                ideaNumber = i;
            }
            if (ideaNumber == -1) {
                throw new IllegalArgumentException("l'attribut '" + attributeCodeEA + "' n'existe pas.");
            }
            TreeSet<String> codesExploitation = new TreeSet<String>();
            while (sfr.hasNext()) {
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                Object[] entry = dfr.readEntry();
                String code = (String)entry[ideaNumber];
                codesExploitation.add(code);
            }
            sfr.close();
            dfr.close();
            return codesExploitation.toArray(new String[codesExploitation.size()]);
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void recuperationEnveloppesExploitations() {
        String parcellaire = "C:/Data/data/rpg/bretagne_2023/parcelles_geom_2023_r53.shp";
        String attributeCodeEA = "pacage";
        try {
            ShpFiles sf = new ShpFiles(parcellaire);
            ShapefileReader sfr = new ShapefileReader(sf, true, false, new GeometryFactory());
            DbaseFileReader dfr = new DbaseFileReader(sf, true, Charset.defaultCharset());
            DbaseFileHeader header = dfr.getHeader();
            int ideaNumber = -1;
            for (int i = 0; i < header.getNumFields(); ++i) {
                if (!header.getFieldName(i).equalsIgnoreCase(attributeCodeEA)) continue;
                ideaNumber = i;
            }
            if (ideaNumber == -1) {
                throw new IllegalArgumentException("l'attribut '" + attributeCodeEA + "' n'existe pas.");
            }
            TreeMap<String, Double> minXEnveloppesExploitation = new TreeMap<String, Double>();
            TreeMap<String, Double> maxXEnveloppesExploitation = new TreeMap<String, Double>();
            TreeMap<String, Double> minYEnveloppesExploitation = new TreeMap<String, Double>();
            TreeMap<String, Double> maxYEnveloppesExploitation = new TreeMap<String, Double>();
            while (sfr.hasNext()) {
                Geometry the_geom = (Geometry)sfr.nextRecord().shape();
                Object[] entry = dfr.readEntry();
                String code = (String)entry[ideaNumber];
                if (!minXEnveloppesExploitation.containsKey(code)) {
                    minXEnveloppesExploitation.put(code, the_geom.getEnvelopeInternal().getMinX());
                    maxXEnveloppesExploitation.put(code, the_geom.getEnvelopeInternal().getMaxX());
                    minYEnveloppesExploitation.put(code, the_geom.getEnvelopeInternal().getMinY());
                    maxYEnveloppesExploitation.put(code, the_geom.getEnvelopeInternal().getMaxY());
                    continue;
                }
                minXEnveloppesExploitation.put(code, Math.min((Double)minXEnveloppesExploitation.get(code), the_geom.getEnvelopeInternal().getMinX()));
                maxXEnveloppesExploitation.put(code, Math.max((Double)maxXEnveloppesExploitation.get(code), the_geom.getEnvelopeInternal().getMaxX()));
                minYEnveloppesExploitation.put(code, Math.min((Double)minYEnveloppesExploitation.get(code), the_geom.getEnvelopeInternal().getMinY()));
                maxYEnveloppesExploitation.put(code, Math.max((Double)maxYEnveloppesExploitation.get(code), the_geom.getEnvelopeInternal().getMaxY()));
            }
            sfr.close();
            dfr.close();
            TreeMap<String, Envelope> enveloppesExploitation = new TreeMap<String, Envelope>();
            double max = 0.0;
            String eaMax = "";
            for (String ea : minXEnveloppesExploitation.keySet()) {
                Envelope env = new Envelope(((Double)minXEnveloppesExploitation.get(ea)).doubleValue(), ((Double)maxXEnveloppesExploitation.get(ea)).doubleValue(), ((Double)minYEnveloppesExploitation.get(ea)).doubleValue(), ((Double)maxYEnveloppesExploitation.get(ea)).doubleValue());
                enveloppesExploitation.put(ea, env);
                System.out.println("ea " + ea + " : " + env.getArea() / 10000.0 + " ha");
                if (!(env.getArea() / 10000.0 > max)) continue;
                max = env.getArea() / 10000.0;
                eaMax = ea;
            }
            System.out.println("max " + eaMax + " : " + max + " ha");
        }
        catch (ShapefileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

