/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.script;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerManager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedure;
import fr.inrae.act.bagap.chloe.util.Util;
import java.util.HashMap;
import org.locationtech.jts.geom.Envelope;

public class ScriptDepartementGrain2D {
    private static final String path = "D:/grain_bocager/grain2d/";

    public static void main(String[] args) {
        ScriptDepartementGrain2D.analyseDepartement("47");
    }

    private static void analyseDepartement(String codeDpt) {
        ScriptDepartementGrain2D.prepaMNH(codeDpt);
        ScriptDepartementGrain2D.calculGrainBocager5m(codeDpt);
        ScriptDepartementGrain2D.calculGrainBocager50m(codeDpt);
        ScriptDepartementGrain2D.calculZoneEnjeux(codeDpt, 1);
        ScriptDepartementGrain2D.calculZoneEnjeux(codeDpt, 5);
    }

    private static void prepaMNH(String dpt) {
        String localPath = path + dpt + "/";
        Util.createAccess(localPath + "data/");
        Envelope env = ShapeFile2CoverageConverter.getEnvelope(localPath + "data/dpt_" + dpt + ".shp", 2500.0);
        EnteteRaster entete = EnteteRaster.getEntete(env, 5.0f, -1);
        HashMap<String, Integer> codes = new HashMap<String, Integer>();
        codes.put("Bois", 10);
        codes.put("For\u00c3\u00aat ferm\u00c3\u00a9e de feuillus", 10);
        codes.put("For\u00c3\u00aat ferm\u00c3\u00a9e de conif\u00c3\u00a8res", 10);
        codes.put("For\u00c3\u00aat ferm\u00c3\u00a9e mixte", 10);
        codes.put("For\u00c3\u00aat ouverte", 10);
        codes.put("Haie", 10);
        codes.put("Lande ligneuse", 0);
        codes.put("Peupleraie", 10);
        codes.put("Verger", 0);
        codes.put("Vigne", 0);
        Coverage covWood = ShapeFile2CoverageConverter.getSurfaceCoverage(localPath + "data/ZONE_DE_VEGETATION.shp", "NATURE", codes, entete, 0.0f);
        float[] dataWood = covWood.getData();
        covWood.dispose();
        Coverage covHedge = ShapeFile2CoverageConverter.getLinearCoverage(localPath + "data/HAIE.shp", entete, 10.0f, 0.0f, 5.0);
        float[] dataHedge = covHedge.getData();
        covHedge.dispose();
        for (int i = 0; i < entete.width() * entete.height(); ++i) {
            dataWood[i] = Math.max(dataHedge[i], dataWood[i]);
        }
        CoverageManager.write(localPath + "data/MNH_" + dpt + ".tif", dataWood, entete);
    }

    private static void calculGrainBocager5m(String dpt) {
        String localPath = path + dpt + "/";
        String outputPath = localPath + "grain_bocager/";
        GrainBocagerManager gbManager = new GrainBocagerManager("grain_bocager_calculation");
        gbManager.setFastMode(true);
        gbManager.setBufferArea(0.0);
        gbManager.setThresholds(0.2, 0.33, 0.45);
        gbManager.setWoodHeight(localPath + "data/MNH_" + dpt + ".tif");
        gbManager.setWoodType(outputPath + dpt + "_type_boisement.tif");
        gbManager.setInfluenceDistance(outputPath + dpt + "_distance_influence.tif");
        gbManager.setGrainBocager(outputPath + dpt + "_grain_bocager_5m.tif");
        gbManager.setGrainBocager4Classes(outputPath + dpt + "_grain_bocager_5m_4classes.tif");
        GrainBocagerProcedure gbProcedure = gbManager.build();
        gbProcedure.run();
    }

    private static void calculGrainBocager50m(String dpt) {
        String localPath = path + dpt + "/";
        String outputPath = localPath + "grain_bocager/";
        GrainBocagerManager gbManager = new GrainBocagerManager("grain_bocager_calculation");
        gbManager.setFastMode(true);
        gbManager.setBufferArea(0.0);
        gbManager.setThresholds(0.2, 0.33, 0.45);
        gbManager.setGrainBocagerCellSize(50.0);
        gbManager.setInfluenceDistance(outputPath + dpt + "_distance_influence.tif");
        gbManager.setGrainBocager(outputPath + dpt + "_grain_bocager_50m.tif");
        gbManager.setGrainBocager4Classes(outputPath + dpt + "_grain_bocager_50m_4classes.tif");
        GrainBocagerProcedure gbProcedure = gbManager.build();
        gbProcedure.run();
    }

    private static void calculZoneEnjeux(String dpt, int km) {
        int ewr = km * 1000;
        String localPath = path + dpt + "/grain_bocager/";
        GrainBocagerManager gbManager = new GrainBocagerManager("global_issues_calculation");
        gbManager.setFastMode(true);
        gbManager.setGrainBocager(localPath + dpt + "_grain_bocager_50m.tif");
        gbManager.setFunctionalGrainBocager(localPath + dpt + "_grain_bocager_fonctionnel_50m.tif");
        gbManager.setFunctionalGrainBocagerClustering(localPath + dpt + "_grain_bocager_cluster_50m.tif");
        gbManager.setIssuesCellSize(200.0);
        gbManager.setIssuesWindowRadius(ewr);
        gbManager.setFunctionalGrainBocagerProportion(localPath + dpt + "_proportion_grain_bocager_fonc_" + km + "km.tif");
        gbManager.setFunctionalGrainBocagerFragmentation(localPath + dpt + "_fragmentation_grain_bocager_fonc_" + km + "km.tif");
        GrainBocagerProcedure gbProcedure = gbManager.build();
        gbProcedure.run();
    }
}

