/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.api;

import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.farm.DiagnosticGrainBocagerExploitation;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.farm.DiagnosticGrainBocagerExploitationManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;

public class GrainBocagerExploitationAPI {
    public static void main(String[] args) {
        if (!args[0].endsWith(".properties")) {
            throw new IllegalArgumentException("argument " + args[0] + " is not recognize");
        }
        GrainBocagerExploitationAPI.launchBatch(args[0]);
    }

    public static void launchBatch(String file) {
        try {
            Properties properties = new Properties();
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF8");
            properties.load(in);
            ((Reader)in).close();
            long begin = System.currentTimeMillis();
            DiagnosticGrainBocagerExploitationManager manager = new DiagnosticGrainBocagerExploitationManager();
            GrainBocagerExploitationAPI.importParameters(manager, properties);
            DiagnosticGrainBocagerExploitation diagnostic = manager.build();
            diagnostic.run();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void importParameters(DiagnosticGrainBocagerExploitationManager manager, Properties properties) {
        GrainBocagerExploitationAPI.importExportMap(manager, properties);
        GrainBocagerExploitationAPI.importAttributCodeEA(manager, properties);
        GrainBocagerExploitationAPI.importCodeEA(manager, properties);
        GrainBocagerExploitationAPI.importParcellaire(manager, properties);
        GrainBocagerExploitationAPI.importBocage(manager, properties);
        GrainBocagerExploitationAPI.importAmenagement(manager, properties);
        GrainBocagerExploitationAPI.importScenario(manager, properties);
        GrainBocagerExploitationAPI.importAttributScenario(manager, properties);
        GrainBocagerExploitationAPI.importGrainBocagerCellSize(manager, properties);
        GrainBocagerExploitationAPI.importGrainBocagerWindowRadius(manager, properties);
        GrainBocagerExploitationAPI.importThresholds(manager, properties);
        GrainBocagerExploitationAPI.importOutputFolder(manager, properties);
    }

    private static void importExportMap(DiagnosticGrainBocagerExploitationManager manager, Properties properties) {
        if (properties.containsKey("export_map")) {
            boolean exportMap = Boolean.parseBoolean(properties.getProperty("export_map"));
            manager.setExportMap(exportMap);
        }
    }

    private static void importAttributCodeEA(DiagnosticGrainBocagerExploitationManager manager, Properties properties) {
        if (properties.containsKey("attribut_code_ea")) {
            String prop = properties.getProperty("attribut_code_ea");
            manager.setAttributCodeEA(prop);
        }
    }

    private static void importCodeEA(DiagnosticGrainBocagerExploitationManager manager, Properties properties) {
        if (properties.containsKey("code_ea")) {
            String prop = properties.getProperty("code_ea");
            manager.setCodeEA(prop);
        }
    }

    private static void importBocage(DiagnosticGrainBocagerExploitationManager manager, Properties properties) {
        if (properties.containsKey("bocage")) {
            String prop = properties.getProperty("bocage");
            manager.setBocage(prop);
        }
    }

    private static void importParcellaire(DiagnosticGrainBocagerExploitationManager manager, Properties properties) {
        if (properties.containsKey("parcellaire")) {
            String prop = properties.getProperty("parcellaire");
            manager.setParcellaire(prop);
        }
    }

    private static void importAmenagement(DiagnosticGrainBocagerExploitationManager manager, Properties properties) {
        if (properties.containsKey("amenagement")) {
            String prop = properties.getProperty("amenagement");
            manager.setAmenagement(prop);
        }
    }

    private static void importScenario(DiagnosticGrainBocagerExploitationManager manager, Properties properties) {
        if (properties.containsKey("scenario")) {
            String prop = properties.getProperty("scenario");
            manager.setScenario(prop);
        }
    }

    private static void importAttributScenario(DiagnosticGrainBocagerExploitationManager manager, Properties properties) {
        if (properties.containsKey("attribut_scenario")) {
            String prop = properties.getProperty("attribut_scenario");
            manager.setAttributScenario(prop);
        }
    }

    private static void importOutputFolder(DiagnosticGrainBocagerExploitationManager manager, Properties properties) {
        if (properties.containsKey("output_folder")) {
            String prop = properties.getProperty("output_folder");
            manager.setOutputFolder(prop);
        }
    }

    private static void importThresholds(DiagnosticGrainBocagerExploitationManager manager, Properties properties) {
        if (properties.containsKey("thresholds")) {
            String prop = properties.getProperty("thresholds");
            String[] s = prop.replace("{", "").replace("}", "").replaceAll(" ", "").split(";");
            double s1 = Double.parseDouble(s[0]);
            double s2 = Double.parseDouble(s[1]);
            double s3 = Double.parseDouble(s[2]);
            manager.setThresholds(s1, s2, s3);
        }
    }

    private static void importGrainBocagerWindowRadius(DiagnosticGrainBocagerExploitationManager manager, Properties properties) {
        if (properties.containsKey("grain_bocager_window_radius")) {
            String prop = properties.getProperty("grain_bocager_window_radius");
            manager.setGrainBocagerWindowRadius(Double.parseDouble(prop));
        }
    }

    private static void importGrainBocagerCellSize(DiagnosticGrainBocagerExploitationManager manager, Properties properties) {
        if (properties.containsKey("grain_bocager_cellsize")) {
            String prop = properties.getProperty("grain_bocager_cellsize");
            manager.setGrainBocagerCellSize(Double.parseDouble(prop));
        }
    }
}

