/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.territory;

import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.territory.GrainBocagerTerritoire;

public class GrainBocagerTerritoireBuilder {
    private double seuil;
    private String outputPath;
    private String territoire;
    private String name;
    private String bocage;
    private String replantationBocagere;
    private boolean modeFast;
    private double outCellSize;
    private int bufferArea;

    public GrainBocagerTerritoireBuilder() {
        this.reset();
    }

    private void reset() {
        this.seuil = 0.33;
        this.modeFast = true;
        this.outCellSize = 5.0;
        this.bufferArea = 350;
        this.outputPath = "";
        this.territoire = "";
        this.name = "";
        this.bocage = "";
        this.replantationBocagere = "";
    }

    public void setOutCellSize(double outputCellSize) {
        this.outCellSize = outputCellSize;
    }

    public void setSeuil(double seuil) {
        this.seuil = seuil;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setTerritoire(String territoire) {
        this.territoire = territoire;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBocage(String bocage) {
        this.bocage = bocage;
    }

    public void setReplantationBocagere(String replantationBocagere) {
        this.replantationBocagere = replantationBocagere;
    }

    public void setModeFast(boolean modeFast) {
        this.modeFast = modeFast;
    }

    public void setBufferArea(int bufferArea) {
        this.bufferArea = bufferArea;
    }

    private boolean check() {
        boolean ok = true;
        if (this.seuil < 0.0 || this.seuil > 1.0) {
            System.out.println("threshold parameter 'seuil' is unconsistant " + this.seuil);
            ok = false;
        }
        if (this.outCellSize < 5.0 && this.outCellSize % 5.0 != 0.0) {
            System.out.println("output cellsize parameter 'outputCellSize' is unconsistant " + this.outCellSize);
            ok = false;
        }
        if (this.bufferArea < 0) {
            System.out.println("buffer area parameter 'bufferArea' is unconsistant " + this.outCellSize);
            ok = false;
        }
        if (this.outputPath.equalsIgnoreCase("")) {
            System.out.println("output folder 'outpath' is missing");
            ok = false;
        }
        if (this.territoire.equalsIgnoreCase("")) {
            System.out.println("input shapefile for 'territoire' is missing");
            ok = false;
        }
        if (this.name.equalsIgnoreCase("")) {
            System.out.println("input shapefile for 'name' is missing");
            ok = false;
        }
        if (this.bocage.equalsIgnoreCase("")) {
            System.out.println("input MNHC folder for 'bocage' is missing");
            ok = false;
        }
        return ok;
    }

    public GrainBocagerTerritoire build() {
        if (this.check()) {
            GrainBocagerTerritoire gbTerritoire = new GrainBocagerTerritoire(this.outputPath, this.territoire, this.name, this.bocage, this.seuil, this.replantationBocagere, this.modeFast, this.outCellSize, this.bufferArea);
            this.reset();
            return gbTerritoire;
        }
        throw new IllegalArgumentException("parameters are unconsistant");
    }
}

