/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.territory;

import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import org.locationtech.jts.geom.Envelope;

public class GrainBocagerTerritoire {
    private String outputPath;
    private String bocage;
    private double seuil;
    private String territoire;
    private String name;
    private String replantationBocagere;
    private boolean modeFast;
    private double outputCellSize;
    private int bufferArea;
    private EnteteRaster entete;

    public GrainBocagerTerritoire(String outputPath, String territoire, String name, String bocage, double seuil, String replantationBocagere, boolean modeFast, double outputCellSize, int bufferArea) {
        this.outputPath = outputPath;
        this.territoire = territoire;
        this.name = name;
        this.bocage = bocage;
        this.seuil = seuil;
        this.replantationBocagere = replantationBocagere;
        this.modeFast = modeFast;
        this.outputCellSize = outputCellSize;
        this.bufferArea = bufferArea;
    }

    public void run() {
        Coverage covBocage = CoverageManager.getCoverage(this.bocage);
        this.entete = covBocage.getEntete();
        covBocage.dispose();
        Envelope envelope = ShapeFile2CoverageConverter.getEnvelope(this.territoire, this.bufferArea);
        this.entete = EnteteRaster.getEntete(this.entete, envelope);
        this.runGrainBocager();
        if (this.replantationBocagere != null && !this.replantationBocagere.equalsIgnoreCase("")) {
            this.runGrainBocagerAlternatif("simule");
        }
    }

    private void runGrainBocager() {
        float[] dataHauteurBoisementTotal = this.getElementsBoises(this.bocage, this.entete);
        CoverageManager.writeGeotiff(this.outputPath + this.name + "_hauteur_boisement.tif", dataHauteurBoisementTotal, this.entete);
        String size = (int)this.outputCellSize + "";
    }

    private void runGrainBocagerAlternatif(String scenario) {
        float[] dataHauteurBoisementTotal = this.getElementsBoises(this.bocage, this.entete);
        Coverage covReplantation = ShapeFile2CoverageConverter.getLinearCoverage(this.replantationBocagere, "code", this.entete.cellsize(), this.entete.noDataValue(), this.entete.crs(), this.entete.minx(), this.entete.maxx(), this.entete.miny(), this.entete.maxy(), 0.0f, this.entete.cellsize());
        float[] dataReplantation = covReplantation.getData();
        covReplantation.dispose();
        CoverageManager.writeGeotiff(this.outputPath + this.name + "_" + scenario + "_replantation.tif", dataReplantation, this.entete);
        Pixel2PixelTabCalculation pptc = new Pixel2PixelTabCalculation(dataHauteurBoisementTotal, (float[][])new float[][]{dataHauteurBoisementTotal, dataReplantation}){

            @Override
            protected float doTreat(float[] v) {
                return Math.max(v[0], v[1]);
            }
        };
        pptc.run();
        CoverageManager.writeGeotiff(this.outputPath + this.name + "_" + scenario + "_hauteur_boisement.tif", dataHauteurBoisementTotal, this.entete);
        String size = (int)this.outputCellSize + "";
    }

    private float[] getElementsBoises(String bocage, EnteteRaster entete) {
        Coverage covBoisement = CoverageManager.getCoverage(bocage);
        EnteteRaster enteteMNHC = covBoisement.getEntete();
        float[] dataBoisement = covBoisement.getData(EnteteRaster.getROI(enteteMNHC, new Envelope(entete.minx(), entete.maxx(), entete.miny(), entete.maxy())));
        covBoisement.dispose();
        return dataBoisement;
    }
}

