/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.recuperationhauteur;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.GrainBocager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerManager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedure;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedureFactory;
import java.io.IOException;

public class GBPRecuperationHauteurBoisement
extends GrainBocagerProcedure {
    public GBPRecuperationHauteurBoisement(GrainBocagerProcedureFactory factory, GrainBocagerManager manager) {
        super(factory, manager);
    }

    @Override
    public void doInit() {
    }

    @Override
    public void doRun() {
        float[] dataHauteurBoisement;
        Coverage covHauteurBoisement = GrainBocager.recuperationHauteurBoisement(this.manager().bocage(), this.manager().entete());
        if (this.manager().woodRemoval() != null) {
            Coverage covZoneArrachage = GrainBocager.recuperationZoneArrachage(this.manager().woodRemoval(), this.manager().entete());
            dataHauteurBoisement = covHauteurBoisement.getData();
            float[] dataZoneArrachage = covZoneArrachage.getData();
            covHauteurBoisement.dispose();
            covZoneArrachage.dispose();
            covHauteurBoisement = GrainBocager.supprimeZoneArrachage(dataHauteurBoisement, dataZoneArrachage, this.manager().entete());
        }
        if (this.manager().woodPlanting() != null) {
            Coverage covHauteurPlantation = null;
            covHauteurPlantation = this.manager().heightPlanting() != -1.0f ? GrainBocager.recuperationHauteurPlantation(this.manager().woodPlanting(), this.manager().heightPlanting(), this.manager().entete()) : GrainBocager.recuperationHauteurPlantation(this.manager().woodPlanting(), this.manager().heightPlantingAttribute(), this.manager().entete());
            dataHauteurBoisement = covHauteurBoisement.getData();
            float[] dataHauteurPlantation = covHauteurPlantation.getData();
            covHauteurBoisement.dispose();
            covHauteurPlantation.dispose();
            covHauteurBoisement = GrainBocager.ajouteHauteurPlantation(dataHauteurBoisement, dataHauteurPlantation, this.manager().entete());
        }
        CoverageManager.write(this.manager().woodHeight(), covHauteurBoisement.getData(), covHauteurBoisement.getEntete());
        covHauteurBoisement.dispose();
        try {
            Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_hauteur_boisement.qml"), Tool.deleteExtension(this.manager().woodHeight()) + ".qml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

