/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.farm;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.farm.DiagnosticGrainBocagerExploitation;
import fr.inrae.act.bagap.chloe.util.Util;
import java.io.File;
import org.jumpmind.symmetric.csv.CsvWriter;
import org.locationtech.jts.geom.Envelope;

public class DiagnosticGrainBocagerExploitationManager {
    private String attributCodeEA;
    private double[] thresholds;
    private String outputFolder;
    private String parcellaire;
    private EnteteRaster entete;
    private String bocage;
    private String codeEA;
    private String amenagement;
    private String scenario;
    private String attributScenario;
    private double grainBocagerCellSize;
    private double grainBocagerWindowRadius;
    private CsvWriter writer;
    private boolean exportMap;
    private int buffer;

    public DiagnosticGrainBocagerExploitationManager() {
        this.init();
    }

    private void init() {
        this.attributCodeEA = "id_ea";
        this.thresholds = new double[]{0.2, 0.33, 0.45};
        this.scenario = "initial";
        this.attributScenario = null;
        this.grainBocagerCellSize = 5.0;
        this.grainBocagerWindowRadius = 250.0;
        this.exportMap = false;
        this.buffer = 500;
        this.outputFolder = new File(System.getProperty("java.io.tmpdir")).toString().replace("\\", "/") + "/grain_bocager_exploitation/";
        Util.createAccess(this.outputFolder);
        this.parcellaire = null;
        this.bocage = null;
        this.codeEA = null;
        this.amenagement = null;
        this.writer = null;
    }

    public void setWriter(CsvWriter writer) {
        this.writer = writer;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public void setAttributScenario(String attributScenario) {
        this.attributScenario = attributScenario;
    }

    public void setAttributCodeEA(String attributeCodeEA) {
        this.attributCodeEA = attributeCodeEA;
    }

    public void setThresholds(double threshold1, double threshold2, double threshold3) {
        this.thresholds[0] = threshold1;
        this.thresholds[1] = threshold2;
        this.thresholds[2] = threshold3;
    }

    public void setOutputFolder(String outputFolder) {
        Util.createAccess(outputFolder);
        this.outputFolder = outputFolder;
        if (!this.outputFolder.endsWith("/")) {
            this.outputFolder = this.outputFolder + "/";
        }
    }

    public void setGrainBocagerCellSize(double grainBocagerCellSize) {
        this.grainBocagerCellSize = grainBocagerCellSize;
    }

    public void setGrainBocagerWindowRadius(double grainWindowRadius) {
        this.grainBocagerWindowRadius = grainWindowRadius;
    }

    public void setParcellaire(String parcellaire) {
        this.parcellaire = parcellaire;
    }

    public void setBocage(String bocage) {
        this.bocage = bocage;
    }

    public void setAmenagement(String amenagement) {
        this.amenagement = amenagement;
    }

    public void setCodeEA(String codeEA) {
        this.codeEA = codeEA;
    }

    public void setExportMap(boolean exportMap) {
        this.exportMap = exportMap;
    }

    public String attributCodeEA() {
        return this.attributCodeEA;
    }

    public double threshold() {
        return this.thresholds[1];
    }

    public double[] thresholds() {
        return this.thresholds;
    }

    public String outputFolder() {
        return this.outputFolder;
    }

    public String parcellaire() {
        return this.parcellaire;
    }

    public String bocage() {
        return this.bocage;
    }

    public String codeEA() {
        return this.codeEA;
    }

    public String amenagement() {
        return this.amenagement;
    }

    public String scenario() {
        return this.scenario;
    }

    public String attributScenario() {
        return this.attributScenario;
    }

    public double grainBocagerCellSize() {
        return this.grainBocagerCellSize;
    }

    public double grainBocagerWindowRadius() {
        return this.grainBocagerWindowRadius;
    }

    public CsvWriter writer() {
        return this.writer;
    }

    public boolean exportMap() {
        return this.exportMap;
    }

    public int buffer() {
        return this.buffer;
    }

    public EnteteRaster entete() {
        return this.entete;
    }

    private boolean initEntete() {
        if (this.parcellaire != null && this.bocage != null) {
            Coverage covBocage = CoverageManager.getCoverage(this.bocage);
            EnteteRaster enteteBocage = covBocage.getEntete();
            covBocage.dispose();
            Envelope envelope = ShapeFile2CoverageConverter.getEnvelope(this.parcellaire, this.buffer * 2, this.attributCodeEA, this.codeEA);
            this.entete = EnteteRaster.getEntete(enteteBocage, envelope);
            return true;
        }
        return false;
    }

    private boolean check() {
        boolean ok = true;
        if (this.attributCodeEA == null || this.attributCodeEA.equalsIgnoreCase("")) {
            System.out.println("attribute for code farm 'attributCodeEA' is missing");
            ok = false;
        }
        if (this.outputFolder == null || this.outputFolder.equalsIgnoreCase("")) {
            System.out.println("output folder 'outpath' is missing");
        }
        if (this.parcellaire == null || this.parcellaire.equalsIgnoreCase("")) {
            System.out.println("input shapefile for 'parcellaire' is missing");
            ok = false;
        }
        if (this.bocage == null || this.bocage.equalsIgnoreCase("")) {
            System.out.println("input file for 'bocage' is missing");
            ok = false;
        }
        if (this.codeEA == null || this.codeEA.equalsIgnoreCase("")) {
            System.out.println("code farm 'codeEA' is missing");
            ok = false;
        }
        if (this.scenario == null || this.scenario.equalsIgnoreCase("")) {
            System.out.println("scenario name 'scenario' is missing");
            ok = false;
        }
        if (this.grainBocagerCellSize < 5.0 && this.grainBocagerCellSize % 5.0 != 0.0) {
            System.out.println("output cellsize parameter 'grain_bocager_cellsize' is unconsistant " + this.grainBocagerCellSize);
            ok = false;
        }
        return ok;
    }

    public DiagnosticGrainBocagerExploitation build() {
        if (this.check() && this.initEntete()) {
            DiagnosticGrainBocagerExploitation diagEA = new DiagnosticGrainBocagerExploitation(this);
            return diagEA;
        }
        throw new IllegalArgumentException("parameters are unconsistant");
    }
}

