/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.farm;

import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.GrainBocager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerManager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.farm.DiagnosticGrainBocagerExploitationManager;
import fr.inrae.act.bagap.chloe.distance.analysis.euclidian.TabChamferDistanceAnalysis;
import fr.inrae.act.bagap.chloe.util.Util;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import org.jumpmind.symmetric.csv.CsvWriter;
import org.locationtech.jts.geom.Envelope;

public class DiagnosticGrainBocagerExploitation {
    private static DecimalFormat format;
    private DiagnosticGrainBocagerExploitationManager manager;

    public DiagnosticGrainBocagerExploitation(DiagnosticGrainBocagerExploitationManager manager) {
        this.manager = manager;
    }

    public boolean run() {
        Envelope envelope = this.manager.entete().getEnvelope();
        System.out.println(envelope);
        if (envelope.getMaxX() - envelope.getMinX() > 15000.0 || envelope.getMaxY() - envelope.getMinY() > 15000.0) {
            System.out.println("trop eclate");
            return false;
        }
        return true;
    }

    private void runDiagnostic(String scenario, String attributScenario) {
        boolean manageWriter = false;
        if (this.manager.writer() == null) {
            this.manager.setWriter(DiagnosticGrainBocagerExploitation.prepareIndices(this.manager.outputFolder() + this.manager.codeEA() + "/diag_" + this.manager.codeEA() + "_" + scenario + ".csv"));
            manageWriter = true;
        }
        this.runDiagnostic(scenario, attributScenario, "total");
        if (manageWriter) {
            DiagnosticGrainBocagerExploitation.fermeIndices(this.manager.writer());
            this.manager.setWriter(null);
        }
    }

    public static void fermeIndices(CsvWriter writer) {
        writer.close();
    }

    private void runDiagnostic(String scenario, String attributScenario, String secteur) {
        if (attributScenario == null) {
            this.runDiagnosticInitial(scenario, attributScenario, secteur);
        } else {
            this.runDiagnosticScenarise(scenario, attributScenario, secteur);
        }
    }

    private void runDiagnosticInitial(String scenario, String attributScenario, String secteur) {
        final EnteteRaster entete = this.manager.entete();
        float[] dataParcellaire = this.getParcellaire(entete);
        float[] dataHauteurBoisement = this.getElementsBoises(dataParcellaire, entete, attributScenario, null, true, true);
        Coverage covTypeBoisement = GrainBocager.detectionTypeBoisement(dataHauteurBoisement, entete, true);
        float[] dataTypeBoisement = covTypeBoisement.getData();
        covTypeBoisement.dispose();
        Coverage covDistanceInfluence = GrainBocager.calculDistancesInfluences(dataHauteurBoisement, dataTypeBoisement, entete, true);
        float[] dataDistanceInfluence = covDistanceInfluence.getData();
        covDistanceInfluence.dispose();
        Coverage covGrainBocager = GrainBocager.calculGrainBocager(dataDistanceInfluence, entete, this.manager.grainBocagerWindowRadius(), this.manager.grainBocagerCellSize(), true);
        float[] dataGrainBocager = covGrainBocager.getData();
        covGrainBocager.dispose();
        Pixel2PixelTabCalculation pptc = new Pixel2PixelTabCalculation(dataGrainBocager, (float[][])new float[][]{dataGrainBocager, dataParcellaire}){

            @Override
            protected float doTreat(float[] v) {
                float vp = v[1];
                if (vp == 1.0f || vp == 2.0f) {
                    return v[0];
                }
                return entete.noDataValue();
            }
        };
        pptc.run();
        Coverage covGrainBocager4Classes = GrainBocager.runClassificationNClasses(dataGrainBocager, entete, entete.noDataValue(), this.manager.thresholds());
        float[] dataGrainBocager4Classes = covGrainBocager4Classes.getData();
        covGrainBocager4Classes.dispose();
        float[] dataHauteurBoisementExterne = this.getElementsBoises(dataParcellaire, entete, attributScenario, null, false, true);
        float[] dataTypeBoisementExterne = this.getTypeBoisement(dataTypeBoisement, dataParcellaire, entete, false, true);
        Coverage covDistanceInfluenceExterne = GrainBocager.calculDistancesInfluences(dataHauteurBoisementExterne, dataTypeBoisementExterne, entete, true);
        float[] dataDistanceInfluenceExterne = covDistanceInfluenceExterne.getData();
        covDistanceInfluenceExterne.dispose();
        Coverage covGrainBocagerExterne = GrainBocager.calculGrainBocager(dataDistanceInfluenceExterne, entete, this.manager.grainBocagerWindowRadius(), this.manager.grainBocagerCellSize(), true);
        float[] dataGrainBocagerExterne = covGrainBocagerExterne.getData();
        covGrainBocagerExterne.dispose();
        pptc = new Pixel2PixelTabCalculation(dataGrainBocagerExterne, (float[][])new float[][]{dataGrainBocagerExterne, dataParcellaire}){

            @Override
            protected float doTreat(float[] v) {
                float vp = v[1];
                if (vp == 1.0f || vp == 2.0f) {
                    return v[0];
                }
                return entete.noDataValue();
            }
        };
        pptc.run();
        Coverage covGrainBocagerExterne4Classes = GrainBocager.runClassificationNClasses(dataGrainBocagerExterne, entete, entete.noDataValue(), this.manager.thresholds());
        float[] dataGrainBocagerExterne4Classes = covGrainBocagerExterne4Classes.getData();
        covGrainBocagerExterne4Classes.dispose();
        if (this.manager.exportMap()) {
            Util.createAccess(this.manager.outputFolder() + this.manager.codeEA() + "/");
            CoverageManager.writeGeotiff(this.manager.outputFolder() + this.manager.codeEA() + "/ea_" + secteur + "_" + this.manager.codeEA() + ".tif", dataParcellaire, entete);
            CoverageManager.writeGeotiff(this.manager.outputFolder() + this.manager.codeEA() + "/hauteur_boisement_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + ".tif", dataHauteurBoisement, entete);
            CoverageManager.writeGeotiff(this.manager.outputFolder() + this.manager.codeEA() + "/type_boisement_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + ".tif", dataTypeBoisement, entete);
            CoverageManager.writeGeotiff(this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + "_4classes.tif", dataGrainBocager4Classes, entete);
            CoverageManager.writeGeotiff(this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_externe_4classes.tif", dataGrainBocagerExterne4Classes, entete);
            CoverageManager.writeGeotiff(this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + ".tif", dataGrainBocager, entete);
            CoverageManager.writeGeotiff(this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_externe.tif", dataGrainBocagerExterne, entete);
            try {
                Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_ea.qml"), this.manager.outputFolder() + this.manager.codeEA() + "/ea_" + secteur + "_" + this.manager.codeEA() + ".qml");
                Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_hauteur_boisement.qml"), this.manager.outputFolder() + this.manager.codeEA() + "/hauteur_boisement_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + ".qml");
                Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_type_boisement.qml"), this.manager.outputFolder() + this.manager.codeEA() + "/type_boisement_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + ".qml");
                Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_grain_bocager.qml"), this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + ".qml");
                Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_grain_bocager.qml"), this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_externe.qml");
                Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_grain_bocager_4classes.qml"), this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + "_4classes.qml");
                Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_grain_bocager_4classes.qml"), this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_externe_4classes.qml");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.calculIndices(this.manager.writer(), scenario, secteur, dataParcellaire, dataHauteurBoisement, dataTypeBoisement, dataGrainBocager, dataGrainBocager4Classes, dataGrainBocagerExterne, dataGrainBocagerExterne4Classes, this.manager.grainBocagerCellSize());
    }

    private void runDiagnosticScenarise(String scenario, String attributScenario, String secteur) {
        float[] dataGrainBocagerExterne4Classes;
        float[] dataGrainBocagerExterne;
        Coverage covParcellaire = CoverageManager.getCoverage(this.manager.outputFolder() + this.manager.codeEA() + "/ea_" + secteur + "_" + this.manager.codeEA() + ".tif");
        float[] dataParcellaire = covParcellaire.getData();
        final EnteteRaster entete = covParcellaire.getEntete();
        covParcellaire.dispose();
        float[] dataHauteurBoisement = this.getElementsBoises(dataParcellaire, entete, attributScenario, this.manager.amenagement(), true, true);
        Coverage covTypeBoisement = GrainBocager.detectionTypeBoisement(dataHauteurBoisement, entete, true);
        float[] dataTypeBoisement = covTypeBoisement.getData();
        covTypeBoisement.dispose();
        Coverage covTypeBoisementInitial = CoverageManager.getCoverage(this.manager.outputFolder() + this.manager.codeEA() + "/type_boisement_" + secteur + "_" + this.manager.codeEA() + "_initial.tif");
        float[] dataTypeBoisementInitial = covTypeBoisementInitial.getData();
        covTypeBoisementInitial.dispose();
        dataTypeBoisement = this.getTypeBoisement(dataTypeBoisement, dataTypeBoisementInitial, entete);
        Coverage covDistanceInfluence = GrainBocager.calculDistancesInfluences(dataHauteurBoisement, dataTypeBoisement, entete, true);
        float[] dataDistanceInfluence = covDistanceInfluence.getData();
        covDistanceInfluence.dispose();
        Coverage covGrainBocager = GrainBocager.calculGrainBocager(dataDistanceInfluence, entete, this.manager.grainBocagerWindowRadius(), this.manager.grainBocagerCellSize(), true);
        float[] dataGrainBocager = covGrainBocager.getData();
        covGrainBocager.dispose();
        Pixel2PixelTabCalculation pptc = new Pixel2PixelTabCalculation(dataGrainBocager, (float[][])new float[][]{dataGrainBocager, dataParcellaire}){

            @Override
            protected float doTreat(float[] v) {
                float vp = v[1];
                if (vp == 1.0f || vp == 2.0f) {
                    return v[0];
                }
                return entete.noDataValue();
            }
        };
        pptc.run();
        Coverage covGrainBocager4Classes = GrainBocager.runClassificationNClasses(dataGrainBocager, entete, entete.noDataValue(), this.manager.thresholds());
        float[] dataGrainBocager4Classes = covGrainBocager4Classes.getData();
        covGrainBocager4Classes.dispose();
        String grainBocagerExterne = this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_externe.tif";
        if (new File(grainBocagerExterne).exists()) {
            Coverage covGrainBocagerExterne = CoverageManager.getCoverage(this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_externe.tif");
            dataGrainBocagerExterne = covGrainBocagerExterne.getData();
            covGrainBocagerExterne.dispose();
            Coverage covGrainBocagerExterne4Classes = CoverageManager.getCoverage(this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_externe_4classes.tif");
            dataGrainBocagerExterne4Classes = covGrainBocagerExterne4Classes.getData();
            covGrainBocagerExterne4Classes.dispose();
        } else {
            float[] dataHauteurBoisementExterne = this.getElementsBoises(dataParcellaire, entete, attributScenario, null, false, true);
            float[] dataTypeBoisementExterne = this.getTypeBoisement(dataTypeBoisement, dataParcellaire, entete, false, true);
            Coverage covDistanceInfluenceExterne = GrainBocager.calculDistancesInfluences(dataHauteurBoisementExterne, dataTypeBoisementExterne, entete, true);
            float[] dataDistanceInfluenceExterne = covDistanceInfluenceExterne.getData();
            covDistanceInfluenceExterne.dispose();
            Coverage covGrainBocagerExterne = GrainBocager.calculGrainBocager(dataDistanceInfluenceExterne, entete, this.manager.grainBocagerWindowRadius(), this.manager.grainBocagerCellSize(), true);
            dataGrainBocagerExterne = covGrainBocagerExterne.getData();
            covGrainBocagerExterne.dispose();
            pptc = new Pixel2PixelTabCalculation(dataGrainBocagerExterne, (float[][])new float[][]{dataGrainBocagerExterne, dataParcellaire}){

                @Override
                protected float doTreat(float[] v) {
                    float vp = v[1];
                    if (vp == 1.0f || vp == 2.0f) {
                        return v[0];
                    }
                    return entete.noDataValue();
                }
            };
            pptc.run();
            Coverage covGrainBocagerExterne4Classes = GrainBocager.runClassificationNClasses(dataGrainBocagerExterne, entete, entete.noDataValue(), this.manager.thresholds());
            dataGrainBocagerExterne4Classes = covGrainBocagerExterne4Classes.getData();
            covGrainBocagerExterne4Classes.dispose();
            if (this.manager.exportMap()) {
                CoverageManager.writeGeotiff(this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_externe_4classes.tif", dataGrainBocagerExterne4Classes, entete);
                CoverageManager.writeGeotiff(this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_externe.tif", dataGrainBocagerExterne, entete);
                try {
                    Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_grain_bocager.qml"), this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_externe.qml");
                    Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_grain_bocager_4classes.qml"), this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_externe_4classes.qml");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.manager.exportMap()) {
            Util.createAccess(this.manager.outputFolder() + this.manager.codeEA() + "/");
            CoverageManager.writeGeotiff(this.manager.outputFolder() + this.manager.codeEA() + "/hauteur_boisement_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + ".tif", dataHauteurBoisement, entete);
            CoverageManager.writeGeotiff(this.manager.outputFolder() + this.manager.codeEA() + "/type_boisement_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + ".tif", dataTypeBoisement, entete);
            CoverageManager.writeGeotiff(this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + ".tif", dataGrainBocager, entete);
            CoverageManager.writeGeotiff(this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + "_4classes.tif", dataGrainBocager4Classes, entete);
            try {
                Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_hauteur_boisement.qml"), this.manager.outputFolder() + this.manager.codeEA() + "/hauteur_boisement_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + ".qml");
                Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_type_boisement.qml"), this.manager.outputFolder() + this.manager.codeEA() + "/type_boisement_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + ".qml");
                Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_grain_bocager.qml"), this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + ".qml");
                Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_grain_bocager_4classes.qml"), this.manager.outputFolder() + this.manager.codeEA() + "/grain_bocager_" + secteur + "_" + this.manager.codeEA() + "_" + scenario + "_4classes.qml");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.calculIndices(this.manager.writer(), scenario, secteur, dataParcellaire, dataHauteurBoisement, dataTypeBoisement, dataGrainBocager, dataGrainBocager4Classes, dataGrainBocagerExterne, dataGrainBocagerExterne4Classes, this.manager.grainBocagerCellSize());
    }

    private float[] getTypeBoisement(float[] dataTypeBoisement, float[] dataParcellaire, final EnteteRaster entete, final boolean interne, final boolean externe) {
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation pptc = new Pixel2PixelTabCalculation(data, (float[][])new float[][]{dataTypeBoisement, dataParcellaire}){

            @Override
            protected float doTreat(float[] v) {
                float vp = v[1];
                if ((vp == 0.0f || vp == 2.0f) && externe) {
                    return v[0];
                }
                if (vp == 1.0f && interne) {
                    return v[0];
                }
                return entete.noDataValue();
            }
        };
        pptc.run();
        return data;
    }

    private float[] getTypeBoisement(float[] dataTypeBoisement, float[] dataTypeBoisementInitial, EnteteRaster entete) {
        Pixel2PixelTabCalculation pptc = new Pixel2PixelTabCalculation(dataTypeBoisement, (float[][])new float[][]{dataTypeBoisement, dataTypeBoisementInitial}){

            @Override
            protected float doTreat(float[] v) {
                float vtb = v[0];
                float vtbi = v[1];
                if (vtb != 0.0f && vtbi != 0.0f) {
                    return Math.max(vtb, vtbi);
                }
                return vtb;
            }
        };
        pptc.run();
        return dataTypeBoisement;
    }

    private float[] getElementsBoises(float[] dataParcellaire, final EnteteRaster entete, String attributScenario, String amenagement, final boolean interne, final boolean externe) {
        Coverage covBoisement = CoverageManager.getCoverage(this.manager.bocage());
        EnteteRaster enteteMNHC = covBoisement.getEntete();
        float[] dataBoisement = covBoisement.getData(EnteteRaster.getROI(enteteMNHC, entete.getEnvelope()));
        covBoisement.dispose();
        Pixel2PixelTabCalculation pptc = new Pixel2PixelTabCalculation(dataBoisement, (float[][])new float[][]{dataBoisement, dataParcellaire}){

            @Override
            protected float doTreat(float[] v) {
                float vp = v[1];
                if ((vp == 0.0f || vp == 2.0f) && externe) {
                    return v[0];
                }
                if (vp == 1.0f && interne) {
                    return v[0];
                }
                return entete.noDataValue();
            }
        };
        pptc.run();
        if (interne && amenagement != null) {
            float[] dataAmenagement = this.getAmenagements(attributScenario, amenagement, entete);
            for (int index = 0; index < dataBoisement.length; ++index) {
                float va = dataAmenagement[index];
                float vp = dataParcellaire[index];
                if (va == -1.0f || vp != 1.0f) continue;
                dataBoisement[index] = va;
            }
        }
        return dataBoisement;
    }

    private float[] getAmenagements(String attributScenario, String amenagement, EnteteRaster entete) {
        Coverage covAmenagement = GrainBocager.recuperationHauteurPlantation(amenagement, attributScenario, entete, -1.0f);
        float[] dataAmenagement = covAmenagement.getData();
        covAmenagement.dispose();
        return dataAmenagement;
    }

    private float[] getParcellaire(final EnteteRaster entete) {
        HashMap<String, Integer> codesEA = new HashMap<String, Integer>();
        codesEA.put(this.manager.codeEA(), 1);
        Coverage covParcellaire = ShapeFile2CoverageConverter.getSurfaceCoverage(this.manager.parcellaire(), this.manager.attributCodeEA(), codesEA, entete.cellsize(), entete.noDataValue(), entete.crs(), entete.minx(), entete.maxx(), entete.miny(), entete.maxy(), 0.0f);
        float[] dataParcellaire = covParcellaire.getData();
        covParcellaire.dispose();
        int[] codes = new int[]{1};
        float[] dataDistance = new float[entete.width() * entete.height()];
        TabChamferDistanceAnalysis da = new TabChamferDistanceAnalysis(dataDistance, dataParcellaire, entete.width(), entete.height(), entete.cellsize(), entete.noDataValue(), codes, entete.noDataValue());
        da.allRun();
        dataParcellaire = null;
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation pptc = new Pixel2PixelTabCalculation(data, (float[][])new float[][]{dataDistance}){

            @Override
            protected float doTreat(float[] v) {
                double value = v[0];
                if (value == 0.0) {
                    return 1.0f;
                }
                if (value <= (double)DiagnosticGrainBocagerExploitation.this.manager.buffer()) {
                    return 2.0f;
                }
                if (value <= (double)(2 * DiagnosticGrainBocagerExploitation.this.manager.buffer())) {
                    return 0.0f;
                }
                return entete.noDataValue();
            }
        };
        pptc.run();
        return data;
    }

    private float[] getElementsBoises(float[] dataZoneBocageExploitation, float[] dataReplantations, EnteteRaster entete, boolean interne, boolean externe) {
        return this.getElementsBoises(dataZoneBocageExploitation, dataReplantations, entete, interne, externe, -1);
    }

    private float[] getElementsBoises(float[] dataZoneBocageExploitation, float[] dataReplantations, EnteteRaster entete, boolean interne, boolean externe, int scenar) {
        Pixel2PixelTabCalculation pptc;
        Coverage covBoisement = CoverageManager.getCoverage(this.manager.bocage());
        EnteteRaster enteteMNHC = covBoisement.getEntete();
        float[] dataBoisement = covBoisement.getData(EnteteRaster.getROI(enteteMNHC, new Envelope(entete.minx(), entete.maxx(), entete.miny(), entete.maxy())));
        covBoisement.dispose();
        if (!interne) {
            pptc = new Pixel2PixelTabCalculation(dataBoisement, (float[][])new float[][]{dataBoisement, dataZoneBocageExploitation}){

                @Override
                protected float doTreat(float[] v) {
                    if (v[1] == 1.0f) {
                        return 0.0f;
                    }
                    return v[0];
                }
            };
            pptc.run();
        }
        if (!externe) {
            pptc = new Pixel2PixelTabCalculation(dataBoisement, (float[][])new float[][]{dataBoisement, dataZoneBocageExploitation}){

                @Override
                protected float doTreat(float[] v) {
                    if (v[1] == 1.0f) {
                        return v[0];
                    }
                    return 0.0f;
                }
            };
            pptc.run();
        }
        if (interne && dataReplantations != null) {
            pptc = new Pixel2PixelTabCalculation(dataBoisement, (float[][])new float[][]{dataBoisement, dataReplantations}){

                @Override
                protected float doTreat(float[] v) {
                    return Math.max(v[0], v[1]);
                }
            };
            pptc.run();
        }
        return dataBoisement;
    }

    private float[] getElementsBoisesMaximum(float[] dataZoneBocageExploitation, float[] dataReplantations, EnteteRaster entete, boolean externe) {
        return this.getElementsBoisesMaximum(dataZoneBocageExploitation, dataReplantations, entete, externe, -1);
    }

    private float[] getElementsBoisesMaximum(float[] dataZoneBocageExploitation, float[] dataReplantations, EnteteRaster entete, boolean externe, int scenar) {
        Coverage covBoisement = CoverageManager.getCoverage(this.manager.bocage());
        EnteteRaster enteteMNHC = covBoisement.getEntete();
        float[] dataBoisement = covBoisement.getData(EnteteRaster.getROI(enteteMNHC, new Envelope(entete.minx(), entete.maxx(), entete.miny(), entete.maxy())));
        covBoisement.dispose();
        Pixel2PixelTabCalculation pptc = new Pixel2PixelTabCalculation(dataBoisement, (float[][])new float[][]{dataBoisement, dataZoneBocageExploitation}){

            @Override
            protected float doTreat(float[] v) {
                if (v[1] == 1.0f) {
                    return 10.0f;
                }
                return v[0];
            }
        };
        pptc.run();
        if (!externe) {
            pptc = new Pixel2PixelTabCalculation(dataBoisement, (float[][])new float[][]{dataBoisement, dataZoneBocageExploitation}){

                @Override
                protected float doTreat(float[] v) {
                    if (v[1] == 1.0f) {
                        return v[0];
                    }
                    return 0.0f;
                }
            };
            pptc.run();
        }
        if (dataReplantations != null) {
            pptc = new Pixel2PixelTabCalculation(dataBoisement, (float[][])new float[][]{dataBoisement, dataReplantations}){

                @Override
                protected float doTreat(float[] v) {
                    return Math.max(v[0], v[1]);
                }
            };
            pptc.run();
        }
        return dataBoisement;
    }

    public static double f(double v) {
        return Math.log10(9.0 * v + 1.0);
    }

    public static CsvWriter prepareIndices(String outputCsv) {
        Util.createAccess(outputCsv);
        try {
            CsvWriter cw = new CsvWriter(outputCsv);
            cw.setDelimiter(';');
            cw.write("exploitation");
            cw.write("scenario");
            cw.write("secteur");
            cw.write("nb_pixel");
            cw.write("surface");
            cw.write("surface_boisement");
            cw.write("surface_arbre");
            cw.write("surface_haie");
            cw.write("surface_massif");
            cw.write("tx_boisement");
            cw.write("tx_arbre");
            cw.write("tx_haie");
            cw.write("tx_massif");
            cw.write("surface_interne");
            cw.write("surface_boisement_interne");
            cw.write("surface_arbre_interne");
            cw.write("surface_haie_interne");
            cw.write("surface_massif_interne");
            cw.write("tx_boisement_interne");
            cw.write("tx_arbre_interne");
            cw.write("tx_haie_interne");
            cw.write("tx_massif_interne");
            cw.write("surface_externe");
            cw.write("surface_boisement_externe");
            cw.write("surface_arbre_externe");
            cw.write("surface_haie_externe");
            cw.write("surface_massif_externe");
            cw.write("tx_boisement_externe");
            cw.write("tx_arbre_externe");
            cw.write("tx_haie_externe");
            cw.write("tx_massif_externe");
            cw.write("gb");
            cw.write("gb_externe");
            cw.write("delta_gb");
            cw.write("gb_fin");
            cw.write("gb_fonctionnel");
            cw.write("gb_potentiel");
            cw.write("gb_grossier");
            cw.write("tx_gb_fin");
            cw.write("tx_gb_fonctionnel");
            cw.write("tx_gb_potentiel");
            cw.write("tx_gb_grossier");
            cw.write("gb_fin_externe");
            cw.write("gb_fonctionnel_externe");
            cw.write("gb_potentiel_externe");
            cw.write("gb_grossier_externe");
            cw.write("tx_gb_fin_externe");
            cw.write("tx_gb_fonctionnel_externe");
            cw.write("tx_gb_potentiel_externe");
            cw.write("tx_gb_grossier_externe");
            cw.write("delta_gb_fin");
            cw.write("delta_gb_fonctionnel");
            cw.write("delta_gb_potentiel");
            cw.write("delta_gb_grossier");
            cw.write("tx_delta_gb_fin");
            cw.write("tx_delta_gb_fonctionnel");
            cw.write("tx_delta_gb_potentiel");
            cw.write("tx_delta_gb_grossier");
            cw.write("seuil_gb");
            cw.write("seuil_gb_externe");
            cw.write("delta_seuil_gb");
            cw.write("tx_seuil_gb");
            cw.write("tx_seuil_gb_externe");
            cw.write("tx_delta_seuil_gb");
            cw.endRecord();
            return cw;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void calculIndices(CsvWriter writer, String scenario, String secteur, float[] dataParcellaire, float[] dataHauteurBoisement, float[] dataTypeBoisement, float[] dataGrainBocager, float[] dataGrainBocager4Classes, float[] dataGrainBocagerExterne, float[] dataGrainBocagerExterne4Classes, double cellsize) {
        System.out.println("calculs des indices");
        try {
            int nb = 0;
            int nbBoisement = 0;
            int nbArbre = 0;
            int nbHaie = 0;
            int nbMassif = 0;
            int nbInterne = 0;
            int nbBoisementInterne = 0;
            int nbArbreInterne = 0;
            int nbHaieInterne = 0;
            int nbMassifInterne = 0;
            int nbExterne = 0;
            int nbBoisementExterne = 0;
            int nbArbreExterne = 0;
            int nbHaieExterne = 0;
            int nbMassifExterne = 0;
            int nbGrain1 = 0;
            int nbGrain2 = 0;
            int nbGrain3 = 0;
            int nbGrainExterne1 = 0;
            int nbGrainExterne2 = 0;
            int nbGrainExterne3 = 0;
            double grainBocager = 0.0;
            double grainBocagerExterne = 0.0;
            double deltaGrainBocager = 0.0;
            for (int i = 0; i < dataParcellaire.length; ++i) {
                if (!(dataParcellaire[i] > 0.0f)) continue;
                ++nb;
                if (dataHauteurBoisement[i] > 0.0f) {
                    ++nbBoisement;
                    if (dataTypeBoisement[i] == 1.0f) {
                        ++nbArbre;
                    } else if (dataTypeBoisement[i] == 5.0f) {
                        ++nbMassif;
                    } else if (dataTypeBoisement[i] == 10.0f) {
                        ++nbHaie;
                    }
                }
                if (dataParcellaire[i] == 1.0f) {
                    ++nbInterne;
                    if (dataHauteurBoisement[i] > 0.0f) {
                        ++nbBoisementInterne;
                        if (dataTypeBoisement[i] == 1.0f) {
                            ++nbArbreInterne;
                        } else if (dataTypeBoisement[i] == 5.0f) {
                            ++nbMassifInterne;
                        } else if (dataTypeBoisement[i] == 10.0f) {
                            ++nbHaieInterne;
                        }
                    }
                }
                if (dataParcellaire[i] == 2.0f) {
                    ++nbExterne;
                    if (dataHauteurBoisement[i] > 0.0f) {
                        ++nbBoisementExterne;
                        if (dataTypeBoisement[i] == 1.0f) {
                            ++nbArbreExterne;
                        } else if (dataTypeBoisement[i] == 5.0f) {
                            ++nbMassifExterne;
                        } else if (dataTypeBoisement[i] == 10.0f) {
                            ++nbHaieExterne;
                        }
                    }
                }
                grainBocager += (double)dataGrainBocager[i];
                grainBocagerExterne += (double)dataGrainBocagerExterne[i];
                deltaGrainBocager += (double)(dataGrainBocagerExterne[i] - dataGrainBocager[i]);
                if (dataGrainBocager4Classes[i] == 1.0f) {
                    ++nbGrain1;
                } else if (dataGrainBocager4Classes[i] == 2.0f) {
                    ++nbGrain2;
                } else if (dataGrainBocager4Classes[i] == 3.0f) {
                    ++nbGrain3;
                }
                if (dataGrainBocagerExterne4Classes[i] == 1.0f) {
                    ++nbGrainExterne1;
                    continue;
                }
                if (dataGrainBocagerExterne4Classes[i] == 2.0f) {
                    ++nbGrainExterne2;
                    continue;
                }
                if (dataGrainBocagerExterne4Classes[i] != 3.0f) continue;
                ++nbGrainExterne3;
            }
            double surface = (double)nb * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceBoisement = (double)nbBoisement * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceArbre = (double)nbArbre * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceHaie = (double)nbHaie * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceMassif = (double)nbMassif * Math.pow(cellsize, 2.0) / 10000.0;
            double txBoisement = (double)nbBoisement * 100.0 / (double)nb;
            double txArbre = (double)nbArbre * 100.0 / (double)nb;
            double txHaie = (double)nbHaie * 100.0 / (double)nb;
            double txMassif = (double)nbMassif * 100.0 / (double)nb;
            double surfaceInterne = (double)nbInterne * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceBoisementInterne = (double)nbBoisementInterne * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceArbreInterne = (double)nbArbreInterne * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceHaieInterne = (double)nbHaieInterne * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceMassifInterne = (double)nbMassifInterne * Math.pow(cellsize, 2.0) / 10000.0;
            double txBoisementInterne = (double)nbBoisementInterne * 100.0 / (double)nbInterne;
            double txArbreInterne = (double)nbArbreInterne * 100.0 / (double)nbInterne;
            double txHaieInterne = (double)nbHaieInterne * 100.0 / (double)nbInterne;
            double txMassifInterne = (double)nbMassifInterne * 100.0 / (double)nbInterne;
            double surfaceExterne = (double)nbExterne * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceBoisementExterne = (double)nbBoisementExterne * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceArbreExterne = (double)nbArbreExterne * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceHaieExterne = (double)nbHaieExterne * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceMassifExterne = (double)nbMassifExterne * Math.pow(cellsize, 2.0) / 10000.0;
            double txBoisementExterne = (double)nbBoisementExterne * 100.0 / (double)nbExterne;
            double txArbreExterne = (double)nbArbreExterne * 100.0 / (double)nbExterne;
            double txHaieExterne = (double)nbHaieExterne * 100.0 / (double)nbExterne;
            double txMassifExterne = (double)nbMassifExterne * 100.0 / (double)nbExterne;
            double moyGrainBocager = grainBocager / (double)nb;
            double moyGrainBocagerExterne = grainBocagerExterne / (double)nb;
            double surfaceGrainBocagerFin = (double)nbGrain1 * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceGrainBocagerFonctionnel = (double)nbGrain2 * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceGrainBocagerPotentiel = (double)nbGrain3 * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceGrainBocagerGrossier = (double)(nb - nbGrain1 - nbGrain2 - nbGrain3) * Math.pow(cellsize, 2.0) / 10000.0;
            double moyenneGrainBocagerFin = surfaceGrainBocagerFin * 100.0 / (double)nb;
            double moyenneGrainBocagerFonctionnel = surfaceGrainBocagerFonctionnel * 100.0 / (double)nb;
            double moyenneGrainBocagerPotentiel = surfaceGrainBocagerPotentiel * 100.0 / (double)nb;
            double moyenneGrainBocagerGrossier = surfaceGrainBocagerGrossier * 100.0 / (double)nb;
            double surfaceGrainBocagerFinExterne = (double)nbGrainExterne1 * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceGrainBocagerFonctionnelExterne = (double)nbGrainExterne2 * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceGrainBocagerPotentielExterne = (double)nbGrainExterne3 * Math.pow(cellsize, 2.0) / 10000.0;
            double surfaceGrainBocagerGrossierExterne = (double)(nb - nbGrainExterne1 - nbGrainExterne2 - nbGrainExterne3) * Math.pow(cellsize, 2.0) / 10000.0;
            double moyenneGrainBocagerFinExterne = surfaceGrainBocagerFinExterne * 100.0 / (double)nb;
            double moyenneGrainBocagerFonctionnelExterne = surfaceGrainBocagerFonctionnelExterne * 100.0 / (double)nb;
            double moyenneGrainBocagerPotentielExterne = surfaceGrainBocagerPotentielExterne * 100.0 / (double)nb;
            double moyenneGrainBocagerGrossierExterne = surfaceGrainBocagerGrossierExterne * 100.0 / (double)nb;
            double deltaGrainBocagerFin = surfaceGrainBocagerFin - surfaceGrainBocagerFinExterne;
            double deltaGrainBocagerFonctionnel = surfaceGrainBocagerFonctionnel - surfaceGrainBocagerFonctionnelExterne;
            double deltaGrainBocagerPotentiel = surfaceGrainBocagerPotentiel - surfaceGrainBocagerPotentielExterne;
            double deltaGrainBocagerGrossier = surfaceGrainBocagerGrossier - surfaceGrainBocagerGrossierExterne;
            double moyenneDeltaGrainBocagerFin = deltaGrainBocagerFin * 100.0 / (double)nb;
            double moyenneDeltaGrainBocagerFonctionnel = deltaGrainBocagerFonctionnel * 100.0 / (double)nb;
            double moyenneDeltaGrainBocagerPotentiel = deltaGrainBocagerPotentiel * 100.0 / (double)nb;
            double moyenneDeltaGrainBocagerGrossier = deltaGrainBocagerGrossier * 100.0 / (double)nb;
            double moyDeltaGrainBocager = deltaGrainBocager * 100.0 / (double)nb;
            double indiceSeuilGrainBocager = nbGrain1 * 3 + nbGrain2 * 2 + nbGrain3;
            double indiceSeuilGrainBocagerExterne = nbGrainExterne1 * 3 + nbGrainExterne2 * 2 + nbGrainExterne3;
            double deltaSeuilGrainBocager = indiceSeuilGrainBocager - indiceSeuilGrainBocagerExterne;
            double moyenneSeuilGrainBocager = indiceSeuilGrainBocager * 100.0 / (double)nb;
            double moyenneSeuilGrainBocagerExterne = indiceSeuilGrainBocagerExterne * 100.0 / (double)nb;
            double moyenneDeltaSeuilGrainBocager = deltaSeuilGrainBocager * 100.0 / (double)nb;
            writer.write(this.manager.codeEA());
            writer.write(scenario);
            writer.write(secteur);
            writer.write(format.format(nb) + "");
            writer.write(format.format(surface) + "");
            writer.write(format.format(surfaceBoisement) + "");
            writer.write(format.format(surfaceArbre) + "");
            writer.write(format.format(surfaceHaie) + "");
            writer.write(format.format(surfaceMassif) + "");
            writer.write(format.format(txBoisement) + "");
            writer.write(format.format(txArbre) + "");
            writer.write(format.format(txHaie) + "");
            writer.write(format.format(txMassif) + "");
            writer.write(format.format(surfaceInterne) + "");
            writer.write(format.format(surfaceBoisementInterne) + "");
            writer.write(format.format(surfaceArbreInterne) + "");
            writer.write(format.format(surfaceHaieInterne) + "");
            writer.write(format.format(surfaceMassifInterne) + "");
            writer.write(format.format(txBoisementInterne) + "");
            writer.write(format.format(txArbreInterne) + "");
            writer.write(format.format(txHaieInterne) + "");
            writer.write(format.format(txMassifInterne) + "");
            writer.write(format.format(surfaceExterne) + "");
            writer.write(format.format(surfaceBoisementExterne) + "");
            writer.write(format.format(surfaceArbreExterne) + "");
            writer.write(format.format(surfaceHaieExterne) + "");
            writer.write(format.format(surfaceMassifExterne) + "");
            writer.write(format.format(txBoisementExterne) + "");
            writer.write(format.format(txArbreExterne) + "");
            writer.write(format.format(txHaieExterne) + "");
            writer.write(format.format(txMassifExterne) + "");
            writer.write(format.format(moyGrainBocager) + "");
            writer.write(format.format(moyGrainBocagerExterne) + "");
            writer.write(format.format(moyDeltaGrainBocager) + "");
            writer.write(format.format(surfaceGrainBocagerFin) + "");
            writer.write(format.format(surfaceGrainBocagerFonctionnel) + "");
            writer.write(format.format(surfaceGrainBocagerPotentiel) + "");
            writer.write(format.format(surfaceGrainBocagerGrossier) + "");
            writer.write(format.format(moyenneGrainBocagerFin) + "");
            writer.write(format.format(moyenneGrainBocagerFonctionnel) + "");
            writer.write(format.format(moyenneGrainBocagerPotentiel) + "");
            writer.write(format.format(moyenneGrainBocagerGrossier) + "");
            writer.write(format.format(surfaceGrainBocagerFinExterne) + "");
            writer.write(format.format(surfaceGrainBocagerFonctionnelExterne) + "");
            writer.write(format.format(surfaceGrainBocagerPotentielExterne) + "");
            writer.write(format.format(surfaceGrainBocagerGrossierExterne) + "");
            writer.write(format.format(moyenneGrainBocagerFinExterne) + "");
            writer.write(format.format(moyenneGrainBocagerFonctionnelExterne) + "");
            writer.write(format.format(moyenneGrainBocagerPotentielExterne) + "");
            writer.write(format.format(moyenneGrainBocagerGrossierExterne) + "");
            writer.write(format.format(deltaGrainBocagerFin) + "");
            writer.write(format.format(deltaGrainBocagerFonctionnel) + "");
            writer.write(format.format(deltaGrainBocagerPotentiel) + "");
            writer.write(format.format(deltaGrainBocagerGrossier) + "");
            writer.write(format.format(moyenneDeltaGrainBocagerFin) + "");
            writer.write(format.format(moyenneDeltaGrainBocagerFonctionnel) + "");
            writer.write(format.format(moyenneDeltaGrainBocagerPotentiel) + "");
            writer.write(format.format(moyenneDeltaGrainBocagerGrossier) + "");
            writer.write(format.format(indiceSeuilGrainBocager) + "");
            writer.write(format.format(indiceSeuilGrainBocagerExterne) + "");
            writer.write(format.format(deltaSeuilGrainBocager) + "");
            writer.write(format.format(moyenneSeuilGrainBocager) + "");
            writer.write(format.format(moyenneSeuilGrainBocagerExterne) + "");
            writer.write(format.format(moyenneDeltaSeuilGrainBocager) + "");
            writer.endRecord();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format = new DecimalFormat("0.000", symbols);
    }
}

