/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.enjeuxglobaux;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.GrainBocager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerManager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedure;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedureFactory;
import java.io.File;
import java.io.IOException;

public class GBPCalculEnjeuxGlobaux
extends GrainBocagerProcedure {
    public GBPCalculEnjeuxGlobaux(GrainBocagerProcedureFactory factory, GrainBocagerManager manager) {
        super(factory, manager);
    }

    @Override
    public void doInit() {
        if (this.manager().force() || !new File(this.manager().functionalGrainBocagerClustering()).exists()) {
            this.factory().parentFactory().create(this.manager()).run();
        }
    }

    @Override
    public void doRun() {
        Coverage covClusterFonctionnel = CoverageManager.getCoverage(this.manager().functionalGrainBocagerClustering());
        System.out.println("calcul des zones de fragmentation de grain bocager fonctionnel a " + this.manager().issuesCellSize() + "m en utilisant une fenetre de " + this.manager().issuesWindowRadius() + "m");
        Coverage covFragmentationGrainBocagerFonctionnel = GrainBocager.runSHDIClusterGrainBocagerFonctionnel(covClusterFonctionnel, this.manager().issuesWindowRadius(), this.manager().issuesCellSize(), this.manager().fastMode());
        covClusterFonctionnel.dispose();
        CoverageManager.write(this.manager().functionalGrainBocagerFragmentation(), covFragmentationGrainBocagerFonctionnel.getData(), covFragmentationGrainBocagerFonctionnel.getEntete());
        try {
            Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_fragmentation_grain_bocager_fonctionnel.qml"), Tool.deleteExtension(this.manager().functionalGrainBocagerFragmentation()) + ".qml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        covFragmentationGrainBocagerFonctionnel.dispose();
        Coverage covGrainBocagerFonctionnel = CoverageManager.getCoverage(this.manager().functionalGrainBocager());
        System.out.println("calcul des proportions de grain bocager fonctionnel dans une fenetre de " + this.manager().issuesWindowRadius() + "m avec une resolution de " + this.manager().issuesCellSize() + "m");
        Coverage covProportionGrainBocagerFonctionnel = GrainBocager.runProportionGrainBocagerFonctionnel(covGrainBocagerFonctionnel, this.manager().issuesWindowRadius(), this.manager().issuesCellSize(), this.manager().fastMode());
        covGrainBocagerFonctionnel.dispose();
        CoverageManager.write(this.manager().functionalGrainBocagerProportion(), covProportionGrainBocagerFonctionnel.getData(), covProportionGrainBocagerFonctionnel.getEntete());
        try {
            Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_proportion_grain_bocager_fonctionnel.qml"), Tool.deleteExtension(this.manager().functionalGrainBocagerProportion()) + ".qml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        covProportionGrainBocagerFonctionnel.dispose();
    }
}

