/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.distanceinfluence;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.GrainBocager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerManager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedure;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedureFactory;
import java.io.File;
import java.io.IOException;

public class GBPCalculDistanceInfluenceBoisement
extends GrainBocagerProcedure {
    public GBPCalculDistanceInfluenceBoisement(GrainBocagerProcedureFactory factory, GrainBocagerManager manager) {
        super(factory, manager);
    }

    @Override
    public void doInit() {
        if (this.manager().force() || !new File(this.manager().woodType()).exists() || !new File(this.manager().woodHeight()).exists()) {
            this.factory().parentFactory().create(this.manager()).run();
        }
    }

    @Override
    public void doRun() {
        Coverage covTypeBoisement = CoverageManager.getCoverage(this.manager().woodType());
        Coverage covHauteurBoisement = CoverageManager.getCoverage(this.manager().woodHeight());
        System.out.println("calcul des distances d'influences des boisements");
        Coverage covDistanceInfluence = GrainBocager.calculDistancesInfluences(covHauteurBoisement, covTypeBoisement, this.manager().fastMode());
        covHauteurBoisement.dispose();
        covTypeBoisement.dispose();
        CoverageManager.write(this.manager().influenceDistance(), covDistanceInfluence.getData(), covDistanceInfluence.getEntete());
        covDistanceInfluence.dispose();
        try {
            Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_distance_influence_boisement.qml"), Tool.deleteExtension(this.manager().influenceDistance()) + ".qml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

