/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.detectionboisement;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.GrainBocager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerManager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedure;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedureFactory;
import java.io.File;
import java.io.IOException;

public class GBPDetectionTypeBoisement
extends GrainBocagerProcedure {
    public GBPDetectionTypeBoisement(GrainBocagerProcedureFactory factory, GrainBocagerManager manager) {
        super(factory, manager);
    }

    @Override
    public void doInit() {
        if (this.manager().force() || !new File(this.manager().woodHeight()).exists()) {
            this.factory().parentFactory().create(this.manager()).run();
        }
    }

    @Override
    public void doRun() {
        Coverage covHauteurBoisement = CoverageManager.getCoverage(this.manager().woodHeight());
        System.out.println("detection des types de boisements");
        Coverage covTypeBoisement = GrainBocager.detectionTypeBoisement(this.manager().woodHeight(), this.manager().fastMode());
        covHauteurBoisement.dispose();
        CoverageManager.write(this.manager().woodType(), covTypeBoisement.getData(), covTypeBoisement.getEntete());
        covTypeBoisement.dispose();
        try {
            Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_type_boisement.qml"), Tool.deleteExtension(this.manager().woodType()) + ".qml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

