/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.clusterisationfonctionnalite;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.GrainBocager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerManager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedure;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedureFactory;
import java.io.File;
import java.io.IOException;

public class GBPClusterisationFonctionnalite
extends GrainBocagerProcedure {
    public GBPClusterisationFonctionnalite(GrainBocagerProcedureFactory factory, GrainBocagerManager manager) {
        super(factory, manager);
    }

    @Override
    public void doInit() {
        if (this.manager().force() || !new File(this.manager().grainBocager()).exists()) {
            this.factory().parentFactory().create(this.manager()).run();
        }
    }

    @Override
    public void doRun() {
        Coverage covGrainBocager = CoverageManager.getCoverage(this.manager().grainBocager());
        System.out.println("seuillage des zones fonctionnelles en utilisant le seuil " + this.manager().threshold());
        Coverage covSeuillageFonctionnel = GrainBocager.runClassificationFonctionnelle(covGrainBocager, this.manager().threshold());
        covGrainBocager.dispose();
        CoverageManager.write(this.manager().functionalGrainBocager(), covSeuillageFonctionnel.getData(), covSeuillageFonctionnel.getEntete());
        try {
            Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_grain_bocager_fonctionnel.qml"), Tool.deleteExtension(this.manager().functionalGrainBocager()) + ".qml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("clusterisation des zones fonctionnelles");
        Coverage covClusterFonctionnel = GrainBocager.runClusterisationGrainFonctionnel(covSeuillageFonctionnel);
        covSeuillageFonctionnel.dispose();
        CoverageManager.write(this.manager().functionalGrainBocagerClustering(), covClusterFonctionnel.getData(), covClusterFonctionnel.getEntete());
        covClusterFonctionnel.dispose();
    }
}

