/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.calculgrainbocager;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.GrainBocager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerManager;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedure;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedureFactory;
import java.io.File;
import java.io.IOException;

public class GBPCalculGrainBocager
extends GrainBocagerProcedure {
    public GBPCalculGrainBocager(GrainBocagerProcedureFactory factory, GrainBocagerManager manager) {
        super(factory, manager);
    }

    @Override
    public void doInit() {
        if (this.manager().force() || !new File(this.manager().influenceDistance()).exists()) {
            this.factory().parentFactory().create(this.manager()).run();
        }
    }

    @Override
    public void doRun() {
        System.out.println("recuperation des distances d'infuence");
        Coverage covDistanceInfluenceBoisement = CoverageManager.getCoverage(this.manager().influenceDistance());
        System.out.println("calcul du grain bocager a " + this.manager().grainBocagerCellSize() + "m dans une fenetre de " + this.manager().grainBocagerWindowRadius() + "m");
        Coverage covGrainBocager = GrainBocager.calculGrainBocager(covDistanceInfluenceBoisement, this.manager().grainBocagerWindowRadius(), this.manager().grainBocagerCellSize(), this.manager().fastMode());
        CoverageManager.write(this.manager().grainBocager(), covGrainBocager.getData(), covGrainBocager.getEntete());
        try {
            Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_grain_bocager.qml"), Tool.deleteExtension(this.manager().grainBocager()) + ".qml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("calcul des seuils du grain bocager");
        Coverage covGrainBocager4Classes = GrainBocager.runClassificationNClasses(covGrainBocager, (float)this.manager().entete().noDataValue(), this.manager().thresholds());
        covGrainBocager.dispose();
        CoverageManager.write(this.manager().grainBocager4Classes(), covGrainBocager4Classes.getData(), covGrainBocager4Classes.getEntete());
        try {
            Tool.copy(GrainBocagerManager.class.getResourceAsStream("style_grain_bocager_4classes.qml"), Tool.deleteExtension(this.manager().grainBocager4Classes()) + ".qml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        covGrainBocager4Classes.dispose();
    }
}

