/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Tile;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedure;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.GrainBocagerProcedureFactory;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.calculgrainbocager.GBPCalculGrainBocagerFactory;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.clusterisationfonctionnalite.GBPClusterisationFonctionnaliteFactory;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.detectionboisement.GBPDetectionTypeBoisementFactory;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.distanceinfluence.GBPCalculDistanceInfluenceBoisementFactory;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.enjeuxglobaux.GBPCalculEnjeuxGlobauxFactory;
import fr.inrae.act.bagap.chloe.concept.grainbocager.analysis.procedure.recuperationhauteur.GBPRecuperationHauteurBoisementFactory;
import fr.inrae.act.bagap.chloe.util.Util;
import java.io.File;
import org.locationtech.jts.geom.Envelope;

public class GrainBocagerManager {
    private GrainBocagerProcedureFactory factory;
    private EnteteRaster entete;
    private Tile tile;
    private String outputFolder;
    private String outputPrefix;
    private String territory;
    private String envelope;
    private double bufferArea;
    private String bocage;
    private String woodHeight;
    private String woodType;
    private String influenceDistance;
    private String grainBocager;
    private String grainBocager4Classes;
    private String functionalGrainBocager;
    private String functionalGrainBocagerClustering;
    private String functionalGrainBocagerProportion;
    private String functionalGrainBocagerFragmentation;
    private String woodPlanting;
    private String heightPlantingAttribute;
    private float heightPlanting;
    private String woodRemoval;
    private boolean fastMode;
    private boolean force;
    private double grainBocagerCellSize;
    private double grainBocagerWindowRadius;
    private double issuesCellSize;
    private double issuesWindowRadius;
    private double[] thresholds;

    public GrainBocagerManager(String treatment) {
        this.setTreatment(treatment);
        this.init();
    }

    private void setTreatment(String treatment) {
        switch (treatment) {
            case "wood_height_recovery": {
                this.factory = new GBPRecuperationHauteurBoisementFactory();
                break;
            }
            case "wood_type_detection": {
                this.factory = new GBPDetectionTypeBoisementFactory();
                break;
            }
            case "influence_distance_calculation": {
                this.factory = new GBPCalculDistanceInfluenceBoisementFactory();
                break;
            }
            case "grain_bocager_calculation": {
                this.factory = new GBPCalculGrainBocagerFactory();
                break;
            }
            case "functional_clustering": {
                this.factory = new GBPClusterisationFonctionnaliteFactory();
                break;
            }
            case "global_issues_calculation": {
                this.factory = new GBPCalculEnjeuxGlobauxFactory();
                break;
            }
            default: {
                throw new IllegalArgumentException("treatment '" + treatment + "' do not exists");
            }
        }
    }

    private void init() {
        this.tile = null;
        this.thresholds = new double[]{0.2, 0.33, 0.45};
        this.fastMode = true;
        this.force = false;
        this.grainBocagerCellSize = 5.0;
        this.grainBocagerWindowRadius = 250.0;
        this.issuesCellSize = 50.0;
        this.issuesWindowRadius = 1000.0;
        this.bufferArea = 0.0;
        this.heightPlantingAttribute = "hauteur";
        this.heightPlanting = -1.0f;
        this.outputFolder = new File(System.getProperty("java.io.tmpdir")).toString().replace("\\", "/") + "/grain_bocager/";
        Util.createAccess(this.outputFolder);
        this.outputPrefix = "";
        this.bocage = null;
        this.territory = null;
        this.envelope = null;
        this.woodPlanting = null;
        this.woodRemoval = null;
        this.woodHeight = null;
        this.woodType = null;
        this.influenceDistance = null;
        this.grainBocager = null;
        this.grainBocager4Classes = null;
        this.functionalGrainBocager = null;
        this.functionalGrainBocagerClustering = null;
        this.functionalGrainBocagerProportion = null;
        this.functionalGrainBocagerFragmentation = null;
    }

    private boolean initEntete() {
        if (this.bocage() != null) {
            Coverage covBocage = CoverageManager.getCoverage(this.bocage());
            this.entete = covBocage.getEntete();
            covBocage.dispose();
            if (this.envelope != null) {
                String[] bornes = this.envelope.replace("{", "").replace("}", "").split(";");
                Envelope envelope = new Envelope(Double.parseDouble(bornes[0]) - this.bufferArea, Double.parseDouble(bornes[1]) + this.bufferArea, Double.parseDouble(bornes[2]) - this.bufferArea, Double.parseDouble(bornes[3]) + this.bufferArea);
                this.entete = EnteteRaster.getEntete(this.entete, envelope);
            } else if (this.territory != null) {
                Envelope envelope = ShapeFile2CoverageConverter.getEnvelope(this.territory, this.bufferArea);
                this.entete = EnteteRaster.getEntete(this.entete, envelope);
            }
            return true;
        }
        if (new File(this.woodHeight()).exists()) {
            Coverage covHauteurBoisement = CoverageManager.getCoverage(this.woodHeight());
            this.entete = covHauteurBoisement.getEntete();
            covHauteurBoisement.dispose();
            return true;
        }
        if (new File(this.influenceDistance()).exists()) {
            Coverage covDistanceInfluence = CoverageManager.getCoverage(this.influenceDistance());
            this.entete = covDistanceInfluence.getEntete();
            covDistanceInfluence.dispose();
            return true;
        }
        if (new File(this.grainBocager()).exists()) {
            Coverage covGrainBocager = CoverageManager.getCoverage(this.grainBocager());
            this.entete = covGrainBocager.getEntete();
            covGrainBocager.dispose();
            return true;
        }
        if (new File(this.functionalGrainBocagerClustering()).exists()) {
            Coverage covClusterGrainBocager = CoverageManager.getCoverage(this.functionalGrainBocagerClustering());
            this.entete = covClusterGrainBocager.getEntete();
            covClusterGrainBocager.dispose();
            return true;
        }
        return false;
    }

    public GrainBocagerProcedure build() {
        if (this.factory.check(this) && this.initEntete()) {
            GrainBocagerProcedure gbProcedure = this.factory.create(this);
            return gbProcedure;
        }
        throw new IllegalArgumentException("parameters are unconsistant");
    }

    public void setTile(String tileDir) {
        this.tile = Tile.getTile(tileDir);
    }

    public void setBocage(String bocage) {
        this.bocage = bocage;
    }

    public void setWoodHeight(String woodHeight) {
        this.woodHeight = woodHeight;
    }

    public void setWoodType(String woodType) {
        Util.createAccess(woodType);
        this.woodType = woodType;
    }

    public void setInfluenceDistance(String influenceDistance) {
        Util.createAccess(influenceDistance);
        this.influenceDistance = influenceDistance;
    }

    public void setGrainBocager(String grainBocager) {
        Util.createAccess(grainBocager);
        this.grainBocager = grainBocager;
    }

    public void setGrainBocager4Classes(String grainBocager4Classes) {
        Util.createAccess(grainBocager4Classes);
        this.grainBocager4Classes = grainBocager4Classes;
    }

    public void setFunctionalGrainBocager(String functionalGrainBocager) {
        Util.createAccess(functionalGrainBocager);
        this.functionalGrainBocager = functionalGrainBocager;
    }

    public void setFunctionalGrainBocagerClustering(String functionalGrainBocagerClustering) {
        Util.createAccess(functionalGrainBocagerClustering);
        this.functionalGrainBocagerClustering = functionalGrainBocagerClustering;
    }

    public void setFunctionalGrainBocagerProportion(String functionalGrainBocagerProportion) {
        Util.createAccess(functionalGrainBocagerProportion);
        this.functionalGrainBocagerProportion = functionalGrainBocagerProportion;
    }

    public void setFunctionalGrainBocagerFragmentation(String functionalGrainBocagerFragmentation) {
        Util.createAccess(functionalGrainBocagerFragmentation);
        this.functionalGrainBocagerFragmentation = functionalGrainBocagerFragmentation;
    }

    public void setGrainBocagerCellSize(double grainCellSize) {
        this.grainBocagerCellSize = grainCellSize;
    }

    public void setGrainBocagerWindowRadius(double grainWindowRadius) {
        this.grainBocagerWindowRadius = grainWindowRadius;
    }

    public void setIssuesCellSize(double issuesCellSize) {
        this.issuesCellSize = issuesCellSize;
    }

    public void setIssuesWindowRadius(double issuesWindowRadius) {
        this.issuesWindowRadius = issuesWindowRadius;
    }

    public void setThresholds(double threshold1, double threshold2, double threshold3) {
        this.thresholds[0] = threshold1;
        this.thresholds[1] = threshold2;
        this.thresholds[2] = threshold3;
    }

    public void setThreshold(double threshold) {
        this.thresholds[1] = threshold;
    }

    public void setTerritory(String territory) {
        this.territory = territory;
    }

    public void setEnvelope(String envelope) {
        this.envelope = envelope;
    }

    public void setBufferArea(double bufferArea) {
        this.bufferArea = bufferArea;
    }

    public void setOutputFolder(String outputFolder) {
        Util.createAccess(outputFolder);
        this.outputFolder = outputFolder;
    }

    public void setOuputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    public void setWoodPlanting(String woodPlanting) {
        this.woodPlanting = woodPlanting;
    }

    public void setHeightPlantingAttribute(String heightPlantingAttribute) {
        this.heightPlantingAttribute = heightPlantingAttribute;
    }

    public void setHeightPlanting(float heightPlanting) {
        this.heightPlanting = heightPlanting;
    }

    public void setWoodRemoval(String woodRemoval) {
        this.woodRemoval = woodRemoval;
    }

    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public Tile tile() {
        return this.tile;
    }

    public boolean hugeMode() {
        return this.tile != null;
    }

    public double threshold() {
        return this.thresholds[1];
    }

    public double[] thresholds() {
        return this.thresholds;
    }

    public String outputFolder() {
        return this.outputFolder;
    }

    public String outputPrefix() {
        return this.outputPrefix;
    }

    public String bocage() {
        return this.bocage;
    }

    public String woodHeight() {
        if (this.woodHeight == null) {
            if (this.tile == null) {
                this.setWoodHeight(this.outputFolder() + this.outputPrefix() + "hauteur_boisement.tif");
            } else {
                this.setWoodHeight(this.outputFolder() + this.outputPrefix() + "hauteur_boisement/");
            }
        }
        return this.woodHeight;
    }

    public String woodType() {
        if (this.woodType == null) {
            if (this.tile == null) {
                this.setWoodType(this.outputFolder() + this.outputPrefix() + "type_boisement.tif");
            } else {
                this.setWoodType(this.outputFolder() + this.outputPrefix() + "type_boisement/");
            }
        }
        return this.woodType;
    }

    public String influenceDistance() {
        if (this.influenceDistance == null) {
            if (this.tile == null) {
                this.setInfluenceDistance(this.outputFolder() + this.outputPrefix() + "distance_influence.tif");
            } else {
                this.setInfluenceDistance(this.outputFolder() + this.outputPrefix() + "distance_influence/");
            }
        }
        return this.influenceDistance;
    }

    public String grainBocager() {
        if (this.grainBocager == null) {
            if (this.tile == null) {
                this.setGrainBocager(this.outputFolder() + this.outputPrefix() + "grain_bocager_" + (int)this.grainBocagerCellSize() + "m.tif");
            } else {
                this.setGrainBocager(this.outputFolder() + this.outputPrefix() + "grain_bocager_" + (int)this.grainBocagerCellSize() + "m/");
            }
        }
        return this.grainBocager;
    }

    public String grainBocager4Classes() {
        if (this.grainBocager4Classes == null) {
            if (this.tile == null) {
                this.setGrainBocager4Classes(this.outputFolder() + this.outputPrefix() + "grain_bocager_4classes_" + (int)this.grainBocagerCellSize() + "m.tif");
            } else {
                this.setGrainBocager4Classes(this.outputFolder() + this.outputPrefix() + "grain_bocager_4classes_" + (int)this.grainBocagerCellSize() + "m/");
            }
        }
        return this.grainBocager4Classes;
    }

    public String functionalGrainBocager() {
        if (this.functionalGrainBocager == null) {
            if (this.tile == null) {
                this.setFunctionalGrainBocager(this.outputFolder() + this.outputPrefix() + "grain_bocager_fonctionnel_" + (int)this.grainBocagerCellSize() + "m.tif");
            } else {
                this.setFunctionalGrainBocager(this.outputFolder() + this.outputPrefix() + "grain_bocager_fonctionnel_" + (int)this.grainBocagerCellSize() + "m/");
            }
        }
        return this.functionalGrainBocager;
    }

    public String functionalGrainBocagerClustering() {
        if (this.functionalGrainBocagerClustering == null) {
            if (this.tile == null) {
                this.setFunctionalGrainBocagerClustering(this.outputFolder() + this.outputPrefix() + "cluster_grain_bocager_fonctionnel_" + (int)this.grainBocagerCellSize() + "m.tif");
            } else {
                this.setFunctionalGrainBocagerClustering(this.outputFolder() + this.outputPrefix() + "cluster_grain_bocager_fonctionnel_" + (int)this.grainBocagerCellSize() + "m/");
            }
        }
        return this.functionalGrainBocagerClustering;
    }

    public String functionalGrainBocagerProportion() {
        if (this.functionalGrainBocagerProportion == null) {
            if (this.tile == null) {
                this.setFunctionalGrainBocagerProportion(this.outputFolder() + this.outputPrefix() + "proportion_grain_bocager_fonctionnel_" + (int)this.issuesWindowRadius() + "m.tif");
            } else {
                this.setFunctionalGrainBocagerProportion(this.outputFolder() + this.outputPrefix() + "proportion_grain_bocager_fonctionnel_" + (int)this.issuesWindowRadius() + "m/");
            }
        }
        return this.functionalGrainBocagerProportion;
    }

    public String functionalGrainBocagerFragmentation() {
        if (this.functionalGrainBocagerFragmentation == null) {
            if (this.tile == null) {
                this.setFunctionalGrainBocagerFragmentation(this.outputFolder() + this.outputPrefix() + "fragmentation_grain_bocager_fonctionnel_" + (int)this.issuesWindowRadius() + "m.tif");
            } else {
                this.setFunctionalGrainBocagerFragmentation(this.outputFolder() + this.outputPrefix() + "fragmentation_grain_bocager_fonctionnel_" + (int)this.issuesWindowRadius() + "m/");
            }
        }
        return this.functionalGrainBocagerFragmentation;
    }

    public String woodPlanting() {
        return this.woodPlanting;
    }

    public String woodRemoval() {
        return this.woodRemoval;
    }

    public boolean fastMode() {
        return this.fastMode;
    }

    public boolean force() {
        return this.force;
    }

    public double grainBocagerCellSize() {
        return this.grainBocagerCellSize;
    }

    public double grainBocagerWindowRadius() {
        return this.grainBocagerWindowRadius;
    }

    public double issuesCellSize() {
        return this.issuesCellSize;
    }

    public double issuesWindowRadius() {
        return this.issuesWindowRadius;
    }

    public String heightPlantingAttribute() {
        return this.heightPlantingAttribute;
    }

    public float heightPlanting() {
        return this.heightPlanting;
    }

    public EnteteRaster entete() {
        return this.entete;
    }
}

