/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.grainbocager.analysis;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.Raster;
import fr.inrae.act.bagap.apiland.raster.Tile;
import fr.inrae.act.bagap.apiland.raster.TileCoverage;
import fr.inrae.act.bagap.apiland.raster.analysis.Pixel2PixelTileCoverageCalculation;
import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.cluster.chess.TileQueenClusteringAnalysis;
import fr.inrae.act.bagap.chloe.distance.analysis.euclidian.HugeChamferDistanceAnalysis;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.WindowDistanceType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;

public class HugeGrainBocager {
    public static Coverage detectionTypeBoisement(String rasterTypeBoisement, String rasterTypeBoisementPhase1, String rasterDistanceBoisement, String rasterHauteurBoisement, Tile tile, boolean fastMode) {
        Coverage covHauteurBoisement = CoverageManager.getCoverage(rasterHauteurBoisement);
        Coverage covTypeBoisement = HugeGrainBocager.detectionTypeBoisement(rasterTypeBoisement, rasterTypeBoisementPhase1, rasterDistanceBoisement, covHauteurBoisement, tile, fastMode);
        covHauteurBoisement.dispose();
        return covTypeBoisement;
    }

    public static Coverage detectionTypeBoisement(String rasterTypeBoisement, String rasterTypeBoisementPhase1, String rasterDistanceBoisement, Coverage covHauteurBoisement, Tile tile, boolean fastMode) {
        Coverage covTypeBoisementPhase1 = HugeGrainBocager.detectionTypeBoisementPhase1(rasterTypeBoisementPhase1, covHauteurBoisement, tile, fastMode);
        Coverage covTypeBoisementDistanceBoisement = HugeGrainBocager.calculDistanceMassifsBoisesEuclidian_2(rasterDistanceBoisement, covTypeBoisementPhase1, tile);
        covTypeBoisementPhase1 = CoverageManager.getCoverage(rasterTypeBoisementPhase1);
        Coverage covTypeBoisement = HugeGrainBocager.detectionTypeBoisementPhase2_2(rasterTypeBoisement, covTypeBoisementPhase1, covTypeBoisementDistanceBoisement);
        covTypeBoisementPhase1.dispose();
        covTypeBoisementDistanceBoisement.dispose();
        Tool.deleteFolder(rasterTypeBoisementPhase1);
        Tool.deleteFolder(rasterDistanceBoisement);
        return covTypeBoisement;
    }

    public static Coverage detectionTypeBoisementPhase1(String rasterHauteurBoisement, String rasterTypeBoisementPhase1, Tile tile, boolean fastMode) {
        Coverage covHauteurBoisement = CoverageManager.getCoverage(rasterHauteurBoisement);
        Coverage covTypeBoisementPhase1 = HugeGrainBocager.detectionTypeBoisementPhase1(rasterTypeBoisementPhase1, covHauteurBoisement, tile, fastMode);
        covHauteurBoisement.dispose();
        return covTypeBoisementPhase1;
    }

    public static Coverage detectionTypeBoisementPhase1(String rasterTypeBoisementPhase1, Coverage covHauteurBoisement, Tile tile, boolean fastMode) {
        Util.createAccess(rasterTypeBoisementPhase1);
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        if (fastMode) {
            builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        } else {
            builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        }
        builder.setCoverage(covHauteurBoisement);
        builder.setWindowSize(21);
        builder.addMetric("GBBocage");
        builder.addTileGeoTiffOutput("GBBocage", rasterTypeBoisementPhase1, tile);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        return CoverageManager.getCoverage(rasterTypeBoisementPhase1);
    }

    public static Coverage calculDistanceMassifsBoisesEuclidian(String rasterDistanceBoisement, String rasterTypeBoisementPhase1, Tile tile) {
        Coverage covTypeBoisementPhase1 = CoverageManager.getCoverage(rasterTypeBoisementPhase1);
        Coverage covDistanceMassifsBoisesEuclidian = HugeGrainBocager.calculDistanceMassifsBoisesEuclidian(rasterDistanceBoisement, covTypeBoisementPhase1, tile);
        covTypeBoisementPhase1.dispose();
        return covDistanceMassifsBoisesEuclidian;
    }

    public static Coverage calculDistanceMassifsBoisesEuclidian(String rasterDistanceBoisement, Coverage covTypeBoisementPhase1, Tile tile) {
        Util.createAccess(rasterDistanceBoisement);
        HugeChamferDistanceAnalysis da = new HugeChamferDistanceAnalysis(covTypeBoisementPhase1, tile, rasterDistanceBoisement, "massif", new int[]{5}, covTypeBoisementPhase1.getEntete().noDataValue());
        da.allRun();
        Coverage covDistanceBoisement = CoverageManager.getCoverage(rasterDistanceBoisement);
        return covDistanceBoisement;
    }

    public static Coverage calculDistanceMassifsBoisesEuclidian_2(String rasterDistanceBoisement, Coverage covTypeBoisementPhase1, Tile tile) {
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setCoverage(covTypeBoisementPhase1);
        builder.addMetric("pNV_5");
        builder.setWindowSize(9);
        builder.addTileGeoTiffOutput("pNV_5", rasterDistanceBoisement, tile);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        Coverage covDistanceBoisement = CoverageManager.getCoverage(rasterDistanceBoisement);
        return covDistanceBoisement;
    }

    public static Coverage detectionTypeBoisementPhase2(String rasterTypeBoisement, String rasterTypeBoisementPhase1, String rasterTypeBoisementDistanceBoisement) {
        Coverage covTypeBoisementPhase1 = CoverageManager.getCoverage(rasterTypeBoisementPhase1);
        Coverage covDistanceBoisement = CoverageManager.getCoverage(rasterTypeBoisementDistanceBoisement);
        Coverage covTypeBoisement = HugeGrainBocager.detectionTypeBoisementPhase2(rasterTypeBoisement, covTypeBoisementPhase1, covDistanceBoisement);
        covTypeBoisementPhase1.dispose();
        covDistanceBoisement.dispose();
        return covTypeBoisement;
    }

    public static Coverage detectionTypeBoisementPhase2(String rasterTypeBoisement, Coverage covTypeBoisementPhase1, Coverage covDistanceBoisement) {
        Util.createAccess(rasterTypeBoisement);
        Pixel2PixelTileCoverageCalculation pptcc = new Pixel2PixelTileCoverageCalculation(rasterTypeBoisement, new Coverage[]{covTypeBoisementPhase1, covDistanceBoisement}){

            @Override
            protected float doTreat(float[] v) {
                float vtb = v[0];
                if (vtb == (float)Raster.getNoDataValue()) {
                    return Raster.getNoDataValue();
                }
                if (v[1] <= 20.0f && v[0] == 10.0f) {
                    return 5.0f;
                }
                return vtb;
            }
        };
        pptcc.run();
        Coverage covTypeBoisement = CoverageManager.getCoverage(rasterTypeBoisement);
        return covTypeBoisement;
    }

    public static Coverage detectionTypeBoisementPhase2_2(String rasterTypeBoisement, Coverage covTypeBoisementPhase1, Coverage covDistanceBoisement) {
        System.out.println("detection phase 3");
        Util.createAccess(rasterTypeBoisement);
        Pixel2PixelTileCoverageCalculation pptcc = new Pixel2PixelTileCoverageCalculation(rasterTypeBoisement, new Coverage[]{covTypeBoisementPhase1, covDistanceBoisement}){

            @Override
            protected float doTreat(float[] v) {
                float vtb = v[0];
                if (vtb == (float)Raster.getNoDataValue()) {
                    return Raster.getNoDataValue();
                }
                if (v[1] > 0.0f && v[0] == 10.0f) {
                    return 5.0f;
                }
                return vtb;
            }
        };
        pptcc.run();
        Coverage covTypeBoisement = CoverageManager.getCoverage(rasterTypeBoisement);
        return covTypeBoisement;
    }

    public static Coverage calculDistancesInfluences(String rasterDistanceInfluenceBoisement, Coverage covHauteurBoisement, Coverage covTypeBoisement, Tile tile, boolean fastMode) {
        Util.createAccess(rasterDistanceInfluenceBoisement);
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        if (fastMode) {
            builder.setWindowDistanceType(WindowDistanceType.FAST_SQUARE);
        }
        builder.setCoverage(covHauteurBoisement);
        builder.setCoverage2(covTypeBoisement);
        builder.addMetric("GBDistance");
        builder.setWindowSize(121);
        builder.addTileGeoTiffOutput("GBDistance", rasterDistanceInfluenceBoisement, tile);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        return CoverageManager.getCoverage(rasterDistanceInfluenceBoisement);
    }

    public static Coverage calculGrainBocager(String rasterGrainBocager, Coverage covDistanceInfluence, EnteteRaster entete, double windowRadius, double outputCellSize, Tile tile, boolean fastMode) {
        Util.createAccess(rasterGrainBocager);
        int windowSize = LandscapeMetricAnalysis.getWindowSize(entete.cellsize(), windowRadius);
        int displacement = LandscapeMetricAnalysis.getDisplacement(entete.cellsize(), outputCellSize);
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        if (fastMode) {
            builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        }
        builder.setCoverage(covDistanceInfluence);
        builder.setDisplacement(displacement);
        builder.addMetric("average");
        if (fastMode) {
            builder.setWindowSize((int)((double)windowSize * 1.5));
        } else {
            builder.setWindowSize(windowSize);
        }
        builder.addTileGeoTiffOutput("average", rasterGrainBocager, tile);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        return CoverageManager.getCoverage(rasterGrainBocager);
    }

    public static Coverage runClassificationNClasses(String rasterGrainBocager4Classes, Coverage covGrainBocager, final float noDataValue, final double ... seuils) {
        Util.createAccess(rasterGrainBocager4Classes);
        Pixel2PixelTileCoverageCalculation pptcc = new Pixel2PixelTileCoverageCalculation(rasterGrainBocager4Classes, new Coverage[]{covGrainBocager}){

            @Override
            protected float doTreat(float[] v) {
                float value = v[0];
                if (value == noDataValue) {
                    return noDataValue;
                }
                int classe = 1;
                for (double s : seuils) {
                    if ((double)value <= s) {
                        return classe;
                    }
                    ++classe;
                }
                return classe;
            }
        };
        pptcc.run();
        Coverage covGrainBocager4Classes = CoverageManager.getCoverage(rasterGrainBocager4Classes);
        return covGrainBocager4Classes;
    }

    public static Coverage runClassificationFonctionnelle(String rasterGrainBocagerFonctionnel, Coverage covGrainBocager, final double seuil) {
        Util.createAccess(rasterGrainBocagerFonctionnel);
        Pixel2PixelTileCoverageCalculation pptcc = new Pixel2PixelTileCoverageCalculation(rasterGrainBocagerFonctionnel, new Coverage[]{covGrainBocager}){

            @Override
            protected float doTreat(float[] v) {
                if ((double)v[0] <= seuil) {
                    return 1.0f;
                }
                return 0.0f;
            }
        };
        pptcc.run();
        Coverage covGrainBocagerFonctionnel = CoverageManager.getCoverage(rasterGrainBocagerFonctionnel);
        return covGrainBocagerFonctionnel;
    }

    public static Coverage runClusterisationGrainFonctionnel(String rasterClusterisationGrainBocagerFonctionnel, Coverage covGrainBocagerFonctionnel, int noDataValue) {
        TileQueenClusteringAnalysis clustering = new TileQueenClusteringAnalysis(rasterClusterisationGrainBocagerFonctionnel, (TileCoverage)covGrainBocagerFonctionnel, new int[]{1}, noDataValue);
        clustering.allRun();
        Coverage covClusterisationGrainBocagerFonctionnel = CoverageManager.getCoverage(rasterClusterisationGrainBocagerFonctionnel);
        return covClusterisationGrainBocagerFonctionnel;
    }

    public static Coverage runSHDIClusterGrainBocagerFonctionnel(String rasterZoneFragmentationGrainBocagerFonctionnel, Coverage covClusterGrainFonctionnel, EnteteRaster entete, double windowRadius, double outputCellSize, Tile tile, boolean fastMode) {
        int windowSize = LandscapeMetricAnalysis.getWindowSize(entete.cellsize(), windowRadius);
        int displacement = LandscapeMetricAnalysis.getDisplacement(entete.cellsize(), outputCellSize);
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setCoverage(covClusterGrainFonctionnel);
        if (fastMode) {
            builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        } else {
            builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        }
        builder.addMetric("SHDI");
        builder.setWindowSize(windowSize);
        builder.setDisplacement(displacement);
        builder.addTileGeoTiffOutput("SHDI", rasterZoneFragmentationGrainBocagerFonctionnel, tile);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        Coverage covZoneFragmentationGrainBocagerFonctionnel = CoverageManager.getCoverage(rasterZoneFragmentationGrainBocagerFonctionnel);
        return covZoneFragmentationGrainBocagerFonctionnel;
    }

    public static Coverage runProportionGrainBocagerFonctionnel(String rasterProportionGrainBocagerFonctionnel, Coverage covGrainBocagerFonctionnel, EnteteRaster entete, double windowRadius, double outputCellSize, Tile tile, boolean fastMode) {
        int windowSize = LandscapeMetricAnalysis.getWindowSize(entete.cellsize(), windowRadius);
        int displacement = LandscapeMetricAnalysis.getDisplacement(entete.cellsize(), outputCellSize);
        System.out.println(entete.width() + " " + entete.height() + " " + windowSize + " " + displacement);
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setCoverage(covGrainBocagerFonctionnel);
        if (fastMode) {
            builder.setWindowDistanceType(WindowDistanceType.FAST_GAUSSIAN);
        } else {
            builder.setWindowDistanceType(WindowDistanceType.WEIGHTED);
        }
        builder.addMetric("pNV_1");
        builder.setWindowSize(windowSize);
        builder.setDisplacement(displacement);
        builder.addTileGeoTiffOutput("pNV_1", rasterProportionGrainBocagerFonctionnel, tile);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
        Coverage covProportionGrainBocagerFonctionnel = CoverageManager.getCoverage(rasterProportionGrainBocagerFonctionnel);
        return covProportionGrainBocagerFonctionnel;
    }
}

