/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.erosion.api;

import fr.inrae.act.bagap.chloe.api.NoParameterException;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.ErosionManager;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.ErosionProcedure;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;

public class ErosionAPI {
    public static void main(String[] args) {
        if (!args[0].endsWith(".properties")) {
            throw new IllegalArgumentException("argument " + args[0] + " is not recognize");
        }
        ErosionAPI.launchBatch(args[0]);
    }

    public static void launchBatch(String file) {
        try {
            Properties properties = new Properties();
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF8");
            properties.load(in);
            ((Reader)in).close();
            if (properties.containsKey("treatment")) {
                long begin = System.currentTimeMillis();
                String treatment = properties.getProperty("treatment");
                ErosionManager manager = new ErosionManager(treatment);
                ErosionAPI.importParameters(manager, properties);
                ErosionProcedure procedure = manager.build();
                procedure.run();
                long end = System.currentTimeMillis();
                System.out.println("time computing : " + (end - begin));
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void importParameters(ErosionManager manager, Properties properties) {
        try {
            ErosionAPI.importForce(manager, properties);
            ErosionAPI.importEventType(manager, properties);
            ErosionAPI.importDisplacement(manager, properties);
            ErosionAPI.importOutputFolder(manager, properties);
            ErosionAPI.importOutputPrefix(manager, properties);
            ErosionAPI.importTerritoryShape(manager, properties);
            ErosionAPI.importTerritoryIDAttribute(manager, properties);
            ErosionAPI.importTerritoryIDValues(manager, properties);
            ErosionAPI.importElevationFolder(manager, properties);
            ErosionAPI.importOsSource(manager, properties);
            ErosionAPI.importSurfaceWoodShape(manager, properties);
            ErosionAPI.importSurfaceWoodAttribute(manager, properties);
            ErosionAPI.importSurfaceWoodCode(manager, properties);
            ErosionAPI.importLinearWoodShape(manager, properties);
            ErosionAPI.importLinearWoodCode(manager, properties);
            ErosionAPI.importLinearRoadShape(manager, properties);
            ErosionAPI.importLinearRoadAttribute(manager, properties);
            ErosionAPI.importLinearRoadCode(manager, properties);
            ErosionAPI.importLinearTrainShape(manager, properties);
            ErosionAPI.importLinearTrainCode(manager, properties);
            ErosionAPI.importSurfaceWaterShape(manager, properties);
            ErosionAPI.importSurfaceWaterCode(manager, properties);
            ErosionAPI.importLinearWaterShape(manager, properties);
            ErosionAPI.importLinearWaterCode(manager, properties);
            ErosionAPI.importInfiltrationMapFile(manager, properties);
            ErosionAPI.importErodibilityMapFile(manager, properties);
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void importForce(ErosionManager manager, Properties properties) {
        if (properties.containsKey("force")) {
            boolean force = Boolean.parseBoolean(properties.getProperty("force"));
            manager.setForce(force);
        }
    }

    public static void importEventType(ErosionManager manager, Properties properties) {
        if (properties.containsKey("event_type")) {
            manager.setEventType(properties.getProperty("event_type"));
        }
    }

    public static void importDisplacement(ErosionManager manager, Properties properties) {
        if (properties.containsKey("displacement")) {
            manager.setDisplacement(Integer.parseInt(properties.getProperty("displacement")));
        }
    }

    public static void importOutputFolder(ErosionManager manager, Properties properties) {
        if (properties.containsKey("output_folder")) {
            String prop = properties.getProperty("output_folder");
            if (!prop.endsWith("/") && !prop.endsWith("\\\\")) {
                prop = prop + "/";
            }
            manager.setOutputFolder(prop);
        }
    }

    public static void importOutputPrefix(ErosionManager manager, Properties properties) {
        if (properties.containsKey("output_prefix")) {
            manager.setOutputPrefix(properties.getProperty("output_prefix"));
        }
    }

    public static void importTerritoryShape(ErosionManager manager, Properties properties) {
        if (properties.containsKey("territory_shape")) {
            manager.setTerritoryShape(properties.getProperty("territory_shape"));
        }
    }

    public static void importTerritoryIDAttribute(ErosionManager manager, Properties properties) {
        if (properties.containsKey("territory_id_attribute")) {
            manager.setTerritoryIDAttribute(properties.getProperty("territory_id_attribute"));
        }
    }

    public static void importTerritoryIDValues(ErosionManager manager, Properties properties) {
        if (properties.containsKey("territory_id_values")) {
            String prop = properties.getProperty("territory_id_values");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            manager.setTerritoryIDValues(prop.split(";"));
        }
    }

    public static void importElevationFolder(ErosionManager manager, Properties properties) {
        if (properties.containsKey("elevation_folder")) {
            String[] elevations;
            String prop = properties.getProperty("elevation_folder").replace("{", "").replace("}", "");
            for (String elevation : elevations = prop.split(";")) {
                manager.addElevationFolder(elevation);
            }
        }
    }

    public static void importOsSource(ErosionManager manager, Properties properties) {
        if (properties.containsKey("os_source")) {
            manager.setOsSource(properties.getProperty("os_source"));
        }
    }

    public static void importSurfaceWoodShape(ErosionManager manager, Properties properties) {
        if (properties.containsKey("surface_wood_shape")) {
            String[] surfaces;
            String prop = properties.getProperty("surface_wood_shape").replace("{", "").replace("}", "");
            for (String wood : surfaces = prop.split(";")) {
                manager.addSurfaceWoodShape(wood);
            }
        }
    }

    public static void importSurfaceWoodAttribute(ErosionManager manager, Properties properties) {
        if (properties.containsKey("surface_wood_attribute")) {
            manager.setSurfaceWoodAttribute(properties.getProperty("surface_wood_attribute"));
        }
    }

    public static void importSurfaceWoodCode(ErosionManager manager, Properties properties) {
        if (properties.containsKey("surface_wood_code")) {
            String[] cc;
            String prop = properties.getProperty("surface_wood_code").replace("{", "").replace("}", "");
            for (String c : cc = prop.split(";")) {
                c = c.replace("(", "").replace(")", "");
                String[] vv = c.split(",");
                manager.addSurfaceWoodCode(vv[0], Integer.parseInt(vv[1]));
            }
        }
    }

    public static void importLinearWoodShape(ErosionManager manager, Properties properties) {
        if (properties.containsKey("linear_wood_shape")) {
            String[] linears;
            String prop = properties.getProperty("linear_wood_shape").replace("{", "").replace("}", "");
            for (String wood : linears = prop.split(";")) {
                manager.addLinearWoodShape(wood);
            }
        }
    }

    public static void importLinearWoodCode(ErosionManager manager, Properties properties) {
        if (properties.containsKey("linear_wood_code")) {
            String prop = properties.getProperty("linear_wood_code");
            manager.setLinearWoodCode(Integer.parseInt(prop));
        }
    }

    public static void importLinearRoadShape(ErosionManager manager, Properties properties) {
        if (properties.containsKey("linear_road_shape")) {
            String[] linears;
            String prop = properties.getProperty("linear_road_shape").replace("{", "").replace("}", "");
            for (String road : linears = prop.split(";")) {
                manager.addLinearRoadShape(road);
            }
        }
    }

    public static void importLinearRoadAttribute(ErosionManager manager, Properties properties) {
        if (properties.containsKey("linear_road_attribute")) {
            manager.setLinearRoadAttribute(properties.getProperty("linear_road_attribute"));
        }
    }

    public static void importLinearRoadCode(ErosionManager manager, Properties properties) {
        if (properties.containsKey("linear_road_code")) {
            String[] cc;
            String prop = properties.getProperty("linear_road_code").replace("{", "").replace("}", "");
            for (String c : cc = prop.split(";")) {
                c = c.replace("(", "").replace(")", "");
                String[] vv = c.split(",");
                manager.addLinearRoadCode(vv[0], Integer.parseInt(vv[1]));
            }
        }
    }

    public static void importLinearTrainShape(ErosionManager manager, Properties properties) {
        if (properties.containsKey("linear_train_shape")) {
            String[] linears;
            String prop = properties.getProperty("linear_train_shape").replace("{", "").replace("}", "");
            for (String train : linears = prop.split(";")) {
                manager.addLinearTrainShape(train);
            }
        }
    }

    public static void importLinearTrainCode(ErosionManager manager, Properties properties) {
        if (properties.containsKey("linear_train_code")) {
            String prop = properties.getProperty("linear_train_code");
            manager.setLinearTrainCode(Integer.parseInt(prop));
        }
    }

    public static void importSurfaceWaterShape(ErosionManager manager, Properties properties) {
        if (properties.containsKey("surface_water_shape")) {
            String[] surfaces;
            String prop = properties.getProperty("surface_water_shape").replace("{", "").replace("}", "");
            for (String water : surfaces = prop.split(";")) {
                manager.addSurfaceWaterShape(water);
            }
        }
    }

    public static void importSurfaceWaterCode(ErosionManager manager, Properties properties) {
        if (properties.containsKey("surface_water_code")) {
            String prop = properties.getProperty("surface_water_code");
            manager.setSurfaceWaterCode(Integer.parseInt(prop));
        }
    }

    public static void importLinearWaterShape(ErosionManager manager, Properties properties) {
        if (properties.containsKey("linear_water_shape")) {
            String[] linears;
            String prop = properties.getProperty("linear_water_shape").replace("{", "").replace("}", "");
            for (String water : linears = prop.split(";")) {
                manager.addLinearWaterShape(water);
            }
        }
    }

    public static void importLinearWaterCode(ErosionManager manager, Properties properties) {
        if (properties.containsKey("linear_water_code")) {
            String prop = properties.getProperty("linear_water_code");
            manager.setLinearWaterCode(Integer.parseInt(prop));
        }
    }

    public static void importInfiltrationMapFile(ErosionManager manager, Properties properties) throws NoParameterException {
        if (properties.containsKey("infiltration_map_file")) {
            manager.setInfiltrationMapFile(properties.getProperty("infiltration_map_file"));
            return;
        }
        throw new NoParameterException("infiltration_map_file");
    }

    public static void importErodibilityMapFile(ErosionManager manager, Properties properties) throws NoParameterException {
        if (properties.containsKey("erodibility_map_file")) {
            manager.setErodibilityMapFile(properties.getProperty("erodibility_map_file"));
            return;
        }
        throw new NoParameterException("erodibility_map_file");
    }
}

