/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.datainitialization;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.Erosion;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.ErosionManager;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.ErosionProcedure;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.ErosionProcedureFactory;

public class ERDataInitialization
extends ErosionProcedure {
    public ERDataInitialization(ErosionProcedureFactory factory, ErosionManager manager) {
        super(factory, manager);
    }

    @Override
    public void doInit() {
    }

    @Override
    public void doRun() {
        System.out.println("rasteurisation du bassin versant");
        Erosion.bvRasterization(this.manager().territory(), this.manager().elevationFolders(), this.manager().territoryShape(), this.manager().territoryIDAttribute(), this.manager().territoryIDValues());
        System.out.println("recuperation de l'altitude (RGE_alti, IGN)");
        Erosion.elevationConstruction(this.manager().elevation(), this.manager().territory(), this.manager().elevationFolders());
        System.out.println("recuperation de l'occupation des sols (OSO, Theia)");
        Erosion.osRecovery(this.manager().os(), this.manager().territory(), this.manager().osSource(), 2);
        Coverage osCov = CoverageManager.getCoverage(this.manager().os());
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        System.out.println(osEntete);
        System.out.println(osEntete.getEnvelope());
        CoverageManager.write(this.manager().os(), osData, osEntete);
        System.out.println("recuperation des boisements surfaciques (bd_topo, Zone de vegetation, IGN)");
        for (String sws : this.manager().surfaceWoodShapes()) {
            Erosion.surfaceWoodRasterization(this.manager().os(), sws, this.manager().surfaceWoodAttribute(), this.manager().surfaceWoodCodes());
        }
        System.out.println("recuperation des boisements lineaires (bd_topo, Haie, IGN)");
        for (String lws : this.manager().linearWoodShapes()) {
            Erosion.linearWoodRasterization(this.manager().os(), lws, this.manager().linearWoodCode());
        }
        System.out.println("recuperation des routes lineaires (bd_topo, troncon de route, IGN)");
        for (String lrs : this.manager().linearRoadShapes()) {
            Erosion.linearRoadRasterization(this.manager().os(), lrs, this.manager().linearRoadAttribute(), this.manager().linearRoadCodes());
        }
        System.out.println("recuperation des voies ferrees (bd_topo, troncon de voie ferree, IGN)");
        for (String lts : this.manager().linearTrainShapes()) {
            Erosion.linearTrainRasterization(this.manager().os(), lts, this.manager().linearTrainCode());
        }
        System.out.println("recuperation des surfaces hydrographiques (bd_topo, surface hydrographique, IGN)");
        for (String sws : this.manager().surfaceWaterShapes()) {
            Erosion.surfaceWaterRasterization(this.manager().os(), sws, this.manager().surfaceWaterCode());
        }
        System.out.println("recuperation des troncons hydrographiques (bd_topo, troncon hydrographique, IGN)");
        for (String lws : this.manager().linearWaterShapes()) {
            Erosion.linearWaterRasterization(this.manager().os(), lws, this.manager().linearWaterCode());
        }
    }
}

