/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure;

import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.ErosionManager;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.ErosionProcedure;
import java.util.HashMap;
import java.util.Map;

public abstract class ErosionProcedureFactory {
    private String name;
    private Map<String, ErosionProcedureFactory> parentFactories;

    public ErosionProcedureFactory(String name) {
        this.name = name;
        this.parentFactories = new HashMap<String, ErosionProcedureFactory>();
    }

    public String getName() {
        return this.name;
    }

    protected void addParentFactory(ErosionProcedureFactory parentFactory) {
        this.parentFactories.put(parentFactory.getName(), parentFactory);
    }

    public ErosionProcedureFactory parentFactory(String name) {
        return this.parentFactories.get(name);
    }

    protected boolean checkParents(ErosionManager manager) {
        for (ErosionProcedureFactory parentFactory : this.parentFactories.values()) {
            if (parentFactory.check(manager)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean check(ErosionManager var1);

    public abstract ErosionProcedure create(ErosionManager var1);
}

