/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure;

import fr.inrae.act.bagap.chloe.concept.erosion.analyse.ErosionEventType;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.ErosionProcedure;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.ErosionProcedureFactory;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.datainitialization.ERDataInitializationFactory;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.erodibilitygeneration.ERErodibilityGenerationFactory;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.erodibilityintensitygeneration.ERErodibilityIntensityGenerationFactory;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.erosioncalculation.ERErosionCalculationFactory;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.infiltrationgeneration.ERInfiltrationGenerationFactory;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.slopedetection.ERSlopeDetectionFactory;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.watermasscumulation.ERWaterMassCumulationFactory;
import fr.inrae.act.bagap.chloe.concept.erosion.analyse.procedure.watermassinitialization.ERWaterMassInitializationFactory;
import fr.inrae.act.bagap.chloe.util.Util;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ErosionManager {
    private ErosionProcedureFactory factory;
    private boolean force;
    private String outputFolder;
    private String outputPrefix;
    private String territory;
    private String territoryShape;
    private String territoryIDAttribute;
    private String[] territoryIDValues;
    private String os;
    private String osSource;
    private Set<String> surfaceWoodShapes;
    private String surfaceWoodAttribute;
    private Map<String, Integer> surfaceWoodCodes;
    private Set<String> linearWoodShapes;
    private int linearWoodCode;
    private Set<String> linearRoadShapes;
    private String linearRoadAttribute;
    private Map<String, Integer> linearRoadCodes;
    private Set<String> linearTrainShapes;
    private int linearTrainCode;
    private Set<String> surfaceWaterShapes;
    private int surfaceWaterCode;
    private Set<String> linearWaterShapes;
    private int linearWaterCode;
    private String elevation;
    private Set<String> elevationFolders;
    private String slopeIntensity;
    private String normSlopeIntensity;
    private String infiltrationMapFile;
    private String infiltration;
    private String erodibilityMapFile;
    private String erodibility;
    private ErosionEventType eventType;
    private String initialWaterMass;
    private String cumulWaterMass;
    private String erodibilityIntensity;
    private String sourceErosionIntensity;
    private String depositionErosionIntensity;
    private String bocageAmenagement;
    private int displacement;

    public ErosionManager(String treatment) {
        this.setTreatment(treatment);
        this.init();
    }

    private void setTreatment(String treatment) {
        switch (treatment) {
            case "data_initialization": {
                this.factory = new ERDataInitializationFactory();
                break;
            }
            case "infiltration_generation": {
                this.factory = new ERInfiltrationGenerationFactory();
                break;
            }
            case "erodibility_generation": {
                this.factory = new ERErodibilityGenerationFactory();
                break;
            }
            case "slope_detection": {
                this.factory = new ERSlopeDetectionFactory();
                break;
            }
            case "water_mass_initialization": {
                this.factory = new ERWaterMassInitializationFactory();
                break;
            }
            case "water_mass_cumulation": {
                this.factory = new ERWaterMassCumulationFactory();
                break;
            }
            case "erodibility_intensity_generation": {
                this.factory = new ERErodibilityIntensityGenerationFactory();
                break;
            }
            case "erosion_calculation": {
                this.factory = new ERErosionCalculationFactory();
                break;
            }
            default: {
                throw new IllegalArgumentException("treatment '" + treatment + "' do not exists");
            }
        }
    }

    private void init() {
        this.force = false;
        this.eventType = ErosionEventType.HARD;
        this.displacement = 1;
        this.outputFolder = new File(System.getProperty("java.io.tmpdir")).toString().replace("\\", "/") + "/erosion/";
        Util.createAccess(this.outputFolder);
        this.outputPrefix = "";
        this.territory = null;
        this.territoryShape = null;
        this.territoryIDAttribute = null;
        this.territoryIDValues = null;
        this.os = null;
        this.osSource = null;
        this.surfaceWoodShapes = new HashSet<String>();
        this.surfaceWoodAttribute = null;
        this.surfaceWoodCodes = new HashMap<String, Integer>();
        this.linearWoodShapes = new HashSet<String>();
        this.linearWoodCode = -1;
        this.linearRoadShapes = new HashSet<String>();
        this.linearRoadAttribute = null;
        this.linearRoadCodes = new HashMap<String, Integer>();
        this.linearTrainShapes = new HashSet<String>();
        this.linearTrainCode = -1;
        this.surfaceWaterShapes = new HashSet<String>();
        this.surfaceWaterCode = -1;
        this.linearWaterShapes = new HashSet<String>();
        this.linearWaterCode = -1;
        this.elevation = null;
        this.elevationFolders = new HashSet<String>();
        this.slopeIntensity = null;
        this.normSlopeIntensity = null;
        this.infiltrationMapFile = null;
        this.infiltration = null;
        this.erodibilityMapFile = null;
        this.erodibility = null;
        this.initialWaterMass = null;
        this.cumulWaterMass = null;
        this.erodibilityIntensity = null;
        this.sourceErosionIntensity = null;
        this.depositionErosionIntensity = null;
        this.bocageAmenagement = null;
    }

    public ErosionProcedure build() {
        if (this.factory.check(this)) {
            ErosionProcedure erProcedure = this.factory.create(this);
            return erProcedure;
        }
        throw new IllegalArgumentException("parameters are unconsistant");
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setTerritory(String territory) {
        Util.createAccess(territory);
        this.territory = territory;
    }

    public void setTerritoryShape(String territoryShape) {
        this.territoryShape = territoryShape;
    }

    public void setTerritoryIDAttribute(String territoryIDAttribute) {
        this.territoryIDAttribute = territoryIDAttribute;
    }

    public void setTerritoryIDValues(String ... territoryIDValues) {
        this.territoryIDValues = territoryIDValues;
    }

    public void setOutputFolder(String outputFolder) {
        Util.createAccess(outputFolder);
        this.outputFolder = outputFolder;
    }

    public void setOutputPrefix(String outputPrefix) {
        this.outputPrefix = outputPrefix;
    }

    public void setOs(String os) {
        Util.createAccess(os);
        this.os = os;
    }

    public void setOsSource(String osSource) {
        this.osSource = osSource;
    }

    public void addSurfaceWoodShape(String surfaceWoodShape) {
        this.surfaceWoodShapes.add(surfaceWoodShape);
    }

    public void setSurfaceWoodAttribute(String surfaceWoodAttribute) {
        this.surfaceWoodAttribute = surfaceWoodAttribute;
    }

    public void addSurfaceWoodCode(String attributeValue, int codeValue) {
        this.surfaceWoodCodes.put(attributeValue, codeValue);
    }

    public void addLinearWoodShape(String linearWoodShape) {
        this.linearWoodShapes.add(linearWoodShape);
    }

    public void setLinearWoodCode(int linearWoodCode) {
        this.linearWoodCode = linearWoodCode;
    }

    public void addLinearRoadShape(String linearRoadShape) {
        this.linearRoadShapes.add(linearRoadShape);
    }

    public void setLinearRoadAttribute(String linearRoadAttribute) {
        this.linearRoadAttribute = linearRoadAttribute;
    }

    public void addLinearRoadCode(String attributeValue, int codeValue) {
        this.linearRoadCodes.put(attributeValue, codeValue);
    }

    public void addLinearTrainShape(String linearTrainShape) {
        this.linearTrainShapes.add(linearTrainShape);
    }

    public void setLinearTrainCode(int linearTrainCode) {
        this.linearTrainCode = linearTrainCode;
    }

    public void addSurfaceWaterShape(String surfaceWaterShape) {
        this.surfaceWaterShapes.add(surfaceWaterShape);
    }

    public void setSurfaceWaterCode(int surfaceWaterCode) {
        this.surfaceWaterCode = surfaceWaterCode;
    }

    public void addLinearWaterShape(String linearWaterShape) {
        this.linearWaterShapes.add(linearWaterShape);
    }

    public void setLinearWaterCode(int linearWaterCode) {
        this.linearWaterCode = linearWaterCode;
    }

    public void setElevation(String elevation) {
        Util.createAccess(elevation);
        this.elevation = elevation;
    }

    public void addElevationFolder(String elevationFolder) {
        this.elevationFolders.add(elevationFolder);
    }

    public void setSlopeIntensity(String slopeIntensity) {
        Util.createAccess(slopeIntensity);
        this.slopeIntensity = slopeIntensity;
    }

    public void setNormSlopeIntensity(String normSlopeIntensity) {
        Util.createAccess(normSlopeIntensity);
        this.normSlopeIntensity = normSlopeIntensity;
    }

    public void setInfiltrationMapFile(String infiltrationMapFile) {
        this.infiltrationMapFile = infiltrationMapFile;
    }

    public void setInfiltration(String infiltration) {
        Util.createAccess(infiltration);
        this.infiltration = infiltration;
    }

    public void setErodibilityMapFile(String erodibilityMapFile) {
        this.erodibilityMapFile = erodibilityMapFile;
    }

    public void setErodibility(String erodibility) {
        Util.createAccess(erodibility);
        this.erodibility = erodibility;
    }

    public void setEventType(String eventType) {
        this.eventType = ErosionEventType.valueOf(eventType);
    }

    public void setInitialWaterMass(String initialWaterMass) {
        Util.createAccess(initialWaterMass);
        this.initialWaterMass = initialWaterMass;
    }

    public void setCumulWaterMass(String cumulWaterMass) {
        Util.createAccess(cumulWaterMass);
        this.cumulWaterMass = cumulWaterMass;
    }

    public void setErodibilityIntensity(String erodibilityIntensity) {
        Util.createAccess(erodibilityIntensity);
        this.erodibilityIntensity = erodibilityIntensity;
    }

    public void setSourceErosionIntensity(String sourceErosionIntensity) {
        Util.createAccess(sourceErosionIntensity);
        this.sourceErosionIntensity = sourceErosionIntensity;
    }

    public void setDepositionErosionIntensity(String depositionErosionIntensity) {
        Util.createAccess(depositionErosionIntensity);
        this.depositionErosionIntensity = depositionErosionIntensity;
    }

    public void setBocageAmenagement(String bocageAmenagement) {
        this.bocageAmenagement = bocageAmenagement;
    }

    public void setDisplacement(int displacement) {
        this.displacement = displacement;
    }

    public boolean force() {
        return this.force;
    }

    public String outputFolder() {
        return this.outputFolder;
    }

    public String outputPrefix() {
        return this.outputPrefix;
    }

    public String territory() {
        if (this.territory == null) {
            this.setTerritory(this.outputFolder() + this.outputPrefix() + "_territory.tif");
        }
        return this.territory;
    }

    public String territoryShape() {
        return this.territoryShape;
    }

    public String territoryIDAttribute() {
        return this.territoryIDAttribute;
    }

    public String[] territoryIDValues() {
        return this.territoryIDValues;
    }

    public String os() {
        if (this.os == null) {
            this.setOs(this.outputFolder() + this.outputPrefix() + "_os.tif");
        }
        return this.os;
    }

    public String osSource() {
        return this.osSource;
    }

    public Set<String> surfaceWoodShapes() {
        return this.surfaceWoodShapes;
    }

    public String surfaceWoodAttribute() {
        return this.surfaceWoodAttribute;
    }

    public Map<String, Integer> surfaceWoodCodes() {
        return this.surfaceWoodCodes;
    }

    public Set<String> linearWoodShapes() {
        return this.linearWoodShapes;
    }

    public int linearWoodCode() {
        return this.linearWoodCode;
    }

    public Set<String> linearRoadShapes() {
        return this.linearRoadShapes;
    }

    public String linearRoadAttribute() {
        return this.linearRoadAttribute;
    }

    public Map<String, Integer> linearRoadCodes() {
        return this.linearRoadCodes;
    }

    public Set<String> linearTrainShapes() {
        return this.linearTrainShapes;
    }

    public int linearTrainCode() {
        return this.linearTrainCode;
    }

    public Set<String> surfaceWaterShapes() {
        return this.surfaceWaterShapes;
    }

    public int surfaceWaterCode() {
        return this.surfaceWaterCode;
    }

    public Set<String> linearWaterShapes() {
        return this.linearWaterShapes;
    }

    public int linearWaterCode() {
        return this.linearWaterCode;
    }

    public String elevation() {
        if (this.elevation == null) {
            this.setElevation(this.outputFolder() + this.outputPrefix() + "_elevation.tif");
        }
        return this.elevation;
    }

    public Set<String> elevationFolders() {
        return this.elevationFolders;
    }

    public String slopeIntensity() {
        if (this.slopeIntensity == null) {
            this.setSlopeIntensity(this.outputFolder() + this.outputPrefix() + "_slope_intensity.tif");
        }
        return this.slopeIntensity;
    }

    public String normSlopeIntensity() {
        if (this.normSlopeIntensity == null) {
            this.setNormSlopeIntensity(this.outputFolder() + this.outputPrefix() + "_norm_slope_intensity.tif");
        }
        return this.normSlopeIntensity;
    }

    public String infiltrationMapFile() {
        return this.infiltrationMapFile;
    }

    public String infiltration() {
        if (this.infiltration == null) {
            this.setInfiltration(this.outputFolder() + this.outputPrefix() + "_infiltration.tif");
        }
        return this.infiltration;
    }

    public String erodibilityMapFile() {
        return this.erodibilityMapFile;
    }

    public String erodibility() {
        if (this.erodibility == null) {
            this.setErodibility(this.outputFolder() + this.outputPrefix() + "_erodibility.tif");
        }
        return this.erodibility;
    }

    public int waterQuantity() {
        return this.eventType.getWaterQuantity();
    }

    public String initialWaterMass() {
        if (this.initialWaterMass == null) {
            this.setInitialWaterMass(this.outputFolder() + this.outputPrefix() + "_" + this.eventType.name() + "_initial_water_mass.tif");
        }
        return this.initialWaterMass;
    }

    public String cumulWaterMass() {
        if (this.cumulWaterMass == null) {
            this.setCumulWaterMass(this.outputFolder() + this.outputPrefix() + "_" + this.eventType.name() + "_cumul_water_mass.tif");
        }
        return this.cumulWaterMass;
    }

    public String erodibilityIntensity() {
        if (this.erodibilityIntensity == null) {
            this.setErodibilityIntensity(this.outputFolder() + this.outputPrefix() + "_" + this.eventType.name() + "_erodibility_intensity.tif");
        }
        return this.erodibilityIntensity;
    }

    public String sourceErosionIntensity() {
        if (this.sourceErosionIntensity == null) {
            this.setSourceErosionIntensity(this.outputFolder() + this.outputPrefix() + "_" + this.eventType.name() + "_source_erosion_intensity.tif");
        }
        return this.sourceErosionIntensity;
    }

    public String depositionErosionIntensity() {
        if (this.depositionErosionIntensity == null) {
            this.setDepositionErosionIntensity(this.outputFolder() + this.outputPrefix() + "_" + this.eventType.name() + "_deposition_erosion_intensity.tif");
        }
        return this.depositionErosionIntensity;
    }

    public String bocageAmenagement() {
        return this.bocageAmenagement;
    }

    public int displacement() {
        return this.displacement;
    }
}

