/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.erosion.analyse;

import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.analysis.tab.SearchAndReplacePixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.converter.ShapeFile2CoverageConverter;
import fr.inrae.act.bagap.chloe.util.FileMap;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.WindowShapeType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysis;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Envelope;

public class Erosion {
    public static void bvRasterization(String bvRaster, Set<String> elevationFolders, String bvShape, String attributeID, String ... values) {
        Envelope envelope = ShapeFile2CoverageConverter.getEnvelope(bvShape, 0.0, attributeID, values);
        EnteteRaster refEntete = null;
        for (String ef : elevationFolders) {
            Coverage refCov = CoverageManager.getCoverage(ef);
            refEntete = refEntete == null ? refCov.getEntete() : EnteteRaster.sum(refEntete, refCov.getEntete());
            refCov.dispose();
        }
        refEntete.setNoDataValue(-1);
        EnteteRaster entete = EnteteRaster.getEntete(refEntete, envelope);
        HashMap<String, Integer> codes = new HashMap<String, Integer>();
        for (String v : values) {
            codes.put(v, 1);
        }
        Coverage cov = ShapeFile2CoverageConverter.getSurfaceCoverage(bvShape, attributeID, codes, entete, -1.0f);
        float[] data = cov.getData();
        cov.dispose();
        CoverageManager.write(bvRaster, data, entete);
    }

    public static void elevationConstruction(String elevation, String bv, Set<String> elevationFolders) {
        Coverage bvCov = CoverageManager.getCoverage(bv);
        EnteteRaster bvEntete = bvCov.getEntete();
        float[] bvData = bvCov.getData();
        Envelope bvEnvelope = bvEntete.getEnvelope();
        bvCov.dispose();
        float[] outData = new float[bvEntete.width() * bvEntete.height()];
        for (String ef : elevationFolders) {
            Coverage altCov = CoverageManager.getCoverage(ef);
            EnteteRaster altEntete = altCov.getEntete();
            float[] altData = altCov.getData(EnteteRaster.getROI(altEntete, bvEnvelope));
            altCov.dispose();
            for (int ind = 0; ind < outData.length; ++ind) {
                outData[ind] = Math.max(outData[ind], altData[ind]);
            }
        }
        for (int ind = 0; ind < outData.length; ++ind) {
            if (bvData[ind] != (float)bvEntete.noDataValue()) continue;
            outData[ind] = bvEntete.noDataValue();
        }
        CoverageManager.write(elevation, outData, bvEntete);
    }

    public static void osRecovery(String os, String territory, String osSource, int divisor) {
        Coverage ossCov = CoverageManager.getCoverage(osSource);
        Coverage bvCov = CoverageManager.getCoverage(territory);
        Coverage cov = Util.extendAndFill(ossCov, bvCov, divisor);
        ossCov.dispose();
        bvCov.dispose();
        CoverageManager.write(os, cov.getData(), cov.getEntete());
        cov.dispose();
    }

    public static void osRecovery(String os, EnteteRaster entete, String osSource, int divisor) {
        Coverage ossCov = CoverageManager.getCoverage(osSource);
        Coverage cov = Util.extendAndFill(ossCov, entete, divisor);
        ossCov.dispose();
        CoverageManager.write(os, cov.getData(), cov.getEntete());
        cov.dispose();
    }

    public static void surfaceWoodRasterization(String os, String surfaceWoodShape, String surfaceWoodAttribute, Map<String, Integer> surfaceWoodCodes) {
        Coverage osCov = CoverageManager.getCoverage(os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        Coverage cov = ShapeFile2CoverageConverter.getSurfaceCoverage(osData, osEntete, surfaceWoodShape, surfaceWoodAttribute, surfaceWoodCodes);
        cov.dispose();
        CoverageManager.write(os, osData, osEntete);
    }

    public static void linearWoodRasterization(String os, String linearWoodShape, int linearWoodCode) {
        Coverage osCov = CoverageManager.getCoverage(os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        Coverage cov = ShapeFile2CoverageConverter.getLinearCoverage(osData, osEntete, linearWoodShape, (float)linearWoodCode, 2.5);
        cov.dispose();
        CoverageManager.write(os, osData, osEntete);
    }

    public static void linearRoadRasterization(String os, String linearRoadShape, String linearRoadAttribute, Map<String, Integer> linearRoadCodes) {
        Coverage osCov = CoverageManager.getCoverage(os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        Coverage cov = ShapeFile2CoverageConverter.getLinearCoverage(osData, osEntete, linearRoadShape, linearRoadAttribute, linearRoadCodes, 2.5);
        cov.dispose();
        CoverageManager.write(os, osData, osEntete);
    }

    public static void linearTrainRasterization(String os, String linearTrainShape, int linearTrainCode) {
        Coverage osCov = CoverageManager.getCoverage(os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        Coverage cov = ShapeFile2CoverageConverter.getLinearCoverage(osData, osEntete, linearTrainShape, (float)linearTrainCode, 2.5);
        cov.dispose();
        CoverageManager.write(os, osData, osEntete);
    }

    public static void surfaceWaterRasterization(String os, String surfaceWaterShape, int surfaceWaterCode) {
        Coverage osCov = CoverageManager.getCoverage(os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        Coverage cov = ShapeFile2CoverageConverter.getSurfaceCoverage(osData, osEntete, surfaceWaterShape, (float)surfaceWaterCode);
        cov.dispose();
        CoverageManager.write(os, osData, osEntete);
    }

    public static void linearWaterRasterization(String os, String linearWaterShape, int linearWaterCode) {
        Coverage osCov = CoverageManager.getCoverage(os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        Coverage cov = ShapeFile2CoverageConverter.getLinearCoverage(osData, osEntete, linearWaterShape, (float)linearWaterCode, 2.5);
        cov.dispose();
        CoverageManager.write(os, osData, osEntete);
    }

    public static void sectionHydroRasterization(String os, String sectionHydroShape) {
        Coverage osCov = CoverageManager.getCoverage(os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        Coverage cov = ShapeFile2CoverageConverter.getLinearCoverage(osData, osEntete, sectionHydroShape, 1.0f, 0.0);
        float[] data = cov.getData();
        cov.dispose();
        CoverageManager.write(os, data, osEntete);
    }

    public static void slopeDetection(String slopeIntensity, String altitude) {
        Coverage altCov = CoverageManager.getCoverage(altitude);
        EnteteRaster entete = altCov.getEntete();
        float[] altData = altCov.getData();
        altCov.dispose();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterTab(altData);
        builder.setEntete(entete);
        builder.setWindowShapeType(WindowShapeType.SQUARE);
        builder.setUnfilters(new int[]{-1});
        builder.addMetric("slope-intensity");
        builder.setWindowSize(3);
        builder.addGeoTiffOutput("slope-intensity", slopeIntensity);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    public static void normalizeSlopeIntensity(String normSlopeIntensity, String slopeIntensity) {
        Coverage intCov = CoverageManager.getCoverage(slopeIntensity);
        float[] intData = intCov.getData();
        EnteteRaster entete = intCov.getEntete();
        intCov.dispose();
        float[] data = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{intData}){

            @Override
            protected float doTreat(float[] v) {
                float vi = v[0];
                if (vi == -1.0f) {
                    return -1.0f;
                }
                return Erosion.getSlopeIntensity(vi);
            }
        };
        cal.run();
        CoverageManager.write(normSlopeIntensity, data, entete);
    }

    private static float getSlopeIntensity(float slopIntMax) {
        float v = slopIntMax;
        if (v <= 45.0f) {
            return 1.0f;
        }
        if (v >= 135.0f) {
            return -1.0f;
        }
        return (float)((double)(90.0f - v) / 45.0);
    }

    public static void waterMassInitialization(String initialWaterMass, String os, int waterQuantity) {
        Coverage cov = CoverageManager.getCoverage(os);
        EnteteRaster entete = cov.getEntete();
        float[] bvData = cov.getData();
        cov.dispose();
        float masseInitiale = (float)((double)waterQuantity * Math.pow(entete.cellsize(), 2.0));
        float[] data = new float[entete.width() * entete.height()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = bvData[i] == -1.0f ? -1.0f : masseInitiale;
        }
        CoverageManager.write(initialWaterMass, data, entete);
    }

    public static void infiltrationGeneration(String infiltration, String os, String infiltrationMapFile) {
        Coverage osCov = CoverageManager.getCoverage(os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        FileMap fMap = new FileMap(infiltrationMapFile, "cover", "infiltration");
        float[] data = new float[osData.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(data, osData, fMap.getMap());
        cal.run();
        CoverageManager.write(infiltration, data, osEntete);
    }

    public static void infiltrationGeneration(String infiltration, String os, Map<Float, Float> infiltrationMap) {
        Coverage osCov = CoverageManager.getCoverage(os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        float[] data = new float[osData.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(data, osData, infiltrationMap);
        cal.run();
        CoverageManager.write(infiltration, data, osEntete);
    }

    public static void erodibilityGeneration(String erodibility, String os, String erodibilityMapFile) {
        Coverage osCov = CoverageManager.getCoverage(os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        FileMap fMap = new FileMap(erodibilityMapFile, "cover", "erodibility");
        float[] data = new float[osData.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(data, osData, fMap.getMap());
        cal.run();
        CoverageManager.write(erodibility, data, osEntete);
    }

    public static void erodibilityGeneration(String erodibility, String os, Map<Float, Float> erodibilityMap) {
        Coverage osCov = CoverageManager.getCoverage(os);
        EnteteRaster osEntete = osCov.getEntete();
        float[] osData = osCov.getData();
        osCov.dispose();
        float[] data = new float[osData.length];
        SearchAndReplacePixel2PixelTabCalculation cal = new SearchAndReplacePixel2PixelTabCalculation(data, osData, erodibilityMap);
        cal.run();
        CoverageManager.write(erodibility, data, osEntete);
    }

    public static void waterMassCumulation(String cumulWaterMass, String initialWaterMass, String altitude, String infltration, String slopeIntensity, int displacement, int windowSize) {
        Coverage massInitCov = CoverageManager.getCoverage(initialWaterMass);
        EnteteRaster entete = massInitCov.getEntete();
        float[] massInitData = massInitCov.getData();
        massInitCov.dispose();
        Coverage altCov = CoverageManager.getCoverage(altitude);
        float[] altData = altCov.getData();
        altCov.dispose();
        Coverage infilCov = CoverageManager.getCoverage(infltration);
        float[] infilData = infilCov.getData();
        infilCov.dispose();
        Coverage slopIntCov = CoverageManager.getCoverage(slopeIntensity);
        float[] slopIntData = slopIntCov.getData();
        slopIntCov.dispose();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterTabs(massInitData, altData, infilData, slopIntData);
        builder.setEntete(entete);
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setUnfilters(new int[]{-1});
        builder.addMetric("mass-cumul");
        builder.setWindowSize(windowSize);
        builder.setDisplacement(displacement);
        builder.addGeoTiffOutput("degat-mass-cumul", cumulWaterMass);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }

    public static void erodibilityIntensityGeneration(String erodibilityIntensity, String erodibility, String cumulWaterMass, String normSlopeIntensity, int displacement) {
        Coverage versCov = CoverageManager.getCoverage(erodibility);
        EnteteRaster outEntete = versCov.getEntete();
        float[] versData = versCov.getData();
        versCov.dispose();
        Coverage degatCov = CoverageManager.getCoverage(cumulWaterMass);
        EnteteRaster inEntete = degatCov.getEntete();
        float[] degatData = Util.extend(degatCov.getData(), inEntete, outEntete, displacement);
        degatCov.dispose();
        Coverage intCov = CoverageManager.getCoverage(normSlopeIntensity);
        float[] intData = intCov.getData();
        intCov.dispose();
        float[] data = new float[outEntete.width() * outEntete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(data, new float[][]{versData, degatData, intData}){

            @Override
            protected float doTreat(float[] v) {
                float vv = v[0];
                if (vv == -1.0f) {
                    return -1.0f;
                }
                float vd = v[1];
                float vi = v[2];
                if (vi > 0.0f && vd != -1.0f) {
                    return vv * vd * vi;
                }
                return 0.0f;
            }
        };
        cal.run();
        CoverageManager.write(erodibilityIntensity, data, outEntete);
    }

    public static void erosionCalculation(String sourceErosionIntensity, String depositionErosionIntensity, String elevation, String infiltration, String slopeIntensity, String erodibilityIntensity, int displacement, int windowSize) {
        Coverage intVersCov = CoverageManager.getCoverage(erodibilityIntensity);
        EnteteRaster entete = intVersCov.getEntete();
        float[] intVersData = intVersCov.getData();
        intVersCov.dispose();
        Coverage altCov = CoverageManager.getCoverage(elevation);
        float[] altData = altCov.getData();
        altCov.dispose();
        Coverage infilCov = CoverageManager.getCoverage(infiltration);
        float[] infilData = infilCov.getData();
        infilCov.dispose();
        Coverage slopIntCov = CoverageManager.getCoverage(slopeIntensity);
        float[] slopIntData = slopIntCov.getData();
        slopIntCov.dispose();
        LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
        builder.setRasterTabs(intVersData, altData, infilData, slopIntData);
        builder.setEntete(entete);
        builder.setWindowShapeType(WindowShapeType.FUNCTIONAL);
        builder.setUnfilters(new int[]{-1});
        builder.addMetric("mass-cumul");
        builder.setWindowSize(windowSize);
        builder.setDisplacement(displacement);
        builder.addGeoTiffOutput("mass-cumul", sourceErosionIntensity);
        builder.addGeoTiffOutput("degat-mass-cumul", depositionErosionIntensity);
        LandscapeMetricAnalysis analysis = builder.build();
        analysis.allRun();
    }
}

