/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.ecopaysage.script;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.EcoPaysage;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.csv.CsvWriter;

public class ScriptTestFuzzy {
    private static String path = "C:/Data/temp/gradient/";
    private static Map<Integer, float[]> covs = new TreeMap<Integer, float[]>();
    private static EnteteRaster entete;

    public static void main(String[] args) {
        ScriptTestFuzzy.fuzzyExtremeIndividual();
    }

    private static void fuzzyExtremeIndividual() {
    }

    private static void exportMedianInfo(String medianFile, String kmeanFile, String normFile) {
        try {
            int ki;
            BufferedWriter writer = new BufferedWriter(new FileWriter(medianFile));
            writer.write("classe");
            CsvReader crN = new CsvReader(normFile);
            crN.setDelimiter(';');
            crN.readHeaders();
            int num = crN.getHeaderCount();
            String[] metrics = new String[num];
            for (int ai = 0; ai < num; ++ai) {
                metrics[ai] = crN.getHeader(ai);
                writer.write(";" + metrics[ai]);
            }
            crN.close();
            writer.newLine();
            TreeMap<Integer, float[]> kmeans = new TreeMap<Integer, float[]>();
            CsvReader crI = new CsvReader(kmeanFile);
            crI.setDelimiter(';');
            crI.readHeaders();
            int nbk = 0;
            while (crI.readRecord()) {
                int k = Integer.parseInt(crI.get("classe"));
                float[] infos = new float[crI.getColumnCount() - 1];
                for (int i = 1; i < crI.getColumnCount(); ++i) {
                    infos[i - 1] = Float.parseFloat(crI.get(i));
                }
                kmeans.put(k, infos);
                nbk = Math.max(k, nbk);
            }
            crI.close();
            TreeMap individuals = new TreeMap();
            crN = new CsvReader(normFile);
            crN.setDelimiter(';');
            crN.readHeaders();
            while (crN.readRecord()) {
                float[] data = new float[num];
                for (int i = 0; i < num; ++i) {
                    data[i] = Float.parseFloat(crN.get(i));
                }
                float minDistance = Float.MAX_VALUE;
                int classe = -1;
                for (int ki2 = 1; ki2 <= nbk; ++ki2) {
                    float[] kmean = (float[])kmeans.get(ki2);
                    float d = EcoPaysage.distance(kmean, data);
                    if (!(d < minDistance)) continue;
                    minDistance = d;
                    classe = ki2;
                }
                if (!individuals.containsKey(classe)) {
                    individuals.put(classe, new HashSet());
                }
                ((Set)individuals.get(classe)).add(data);
            }
            TreeMap<Integer, float[]> kMedians = new TreeMap<Integer, float[]>();
            for (ki = 1; ki <= nbk; ++ki) {
                float[] median = ScriptTestFuzzy.getMedian((Set)individuals.get(ki), num);
                kMedians.put(ki, median);
            }
            for (ki = 1; ki <= nbk; ++ki) {
                writer.write(ki + "");
                for (float fi : (float[])kMedians.get(ki)) {
                    writer.write(";" + fi);
                }
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void analyseGradientMedians(String gradientCsv, String masqueFile, String medianFile, String normFile) {
        try {
            int k;
            CsvWriter cw = new CsvWriter(gradientCsv);
            cw.setDelimiter(';');
            cw.write("X");
            cw.write("Y");
            TreeMap<Integer, float[]> kmeans = new TreeMap<Integer, float[]>();
            CsvReader crI = new CsvReader(medianFile);
            crI.setDelimiter(';');
            crI.readHeaders();
            while (crI.readRecord()) {
                k = Integer.parseInt(crI.get("classe"));
                cw.write("ecop_" + crI.get("classe"));
                float[] infos = new float[crI.getColumnCount() - 1];
                for (int i = 1; i < crI.getColumnCount(); ++i) {
                    infos[i - 1] = Float.parseFloat(crI.get(i));
                }
                kmeans.put(k, infos);
            }
            cw.endRecord();
            crI.close();
            CsvReader crN = new CsvReader(normFile);
            crN.setDelimiter(';');
            crN.readHeaders();
            CsvReader crXY = new CsvReader(masqueFile);
            crXY.setDelimiter(';');
            crXY.readHeaders();
            boolean index = false;
            while (crN.readRecord() && crXY.readRecord()) {
                cw.write(crXY.get("X"));
                cw.write(crXY.get("Y"));
                float[] data = new float[crN.getColumnCount()];
                for (int i = 0; i < crN.getColumnCount(); ++i) {
                    data[i] = Float.parseFloat(crN.get(i));
                }
                for (k = 1; k < kmeans.size() + 1; ++k) {
                    float d = EcoPaysage.distance((float[])kmeans.get(k), data);
                    cw.write(d + "");
                }
                cw.endRecord();
            }
            crN.close();
            crXY.close();
            cw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static float[] getMedian(Set<float[]> individuals, int num) {
        float[] medians = new float[num];
        for (int m = 0; m < num; ++m) {
            float[] data = new float[individuals.size()];
            int i = 0;
            for (float[] ind : individuals) {
                data[i] = ind[m];
                ++i;
            }
            Arrays.sort(data);
            float median = data.length % 2 == 0 ? (data[data.length / 2] + data[data.length / 2 - 1]) / 2.0f : data[data.length / 2];
            medians[m] = median;
        }
        return medians;
    }

    public static void analyseGradientExtremes(String gradientCsv, String masqueFile, String extremeFile, String normFile) {
        try {
            int k;
            CsvWriter cw = new CsvWriter(gradientCsv);
            cw.setDelimiter(';');
            cw.write("X");
            cw.write("Y");
            TreeMap<Integer, float[]> kmeans = new TreeMap<Integer, float[]>();
            CsvReader crI = new CsvReader(extremeFile);
            crI.setDelimiter(';');
            crI.readHeaders();
            while (crI.readRecord()) {
                k = Integer.parseInt(crI.get("classe"));
                cw.write("ecop_" + crI.get("classe"));
                float[] infos = new float[crI.getColumnCount() - 1];
                for (int i = 1; i < crI.getColumnCount(); ++i) {
                    infos[i - 1] = Float.parseFloat(crI.get(i));
                }
                kmeans.put(k, infos);
            }
            cw.endRecord();
            crI.close();
            CsvReader crN = new CsvReader(normFile);
            crN.setDelimiter(';');
            crN.readHeaders();
            CsvReader crXY = new CsvReader(masqueFile);
            crXY.setDelimiter(';');
            crXY.readHeaders();
            boolean index = false;
            while (crN.readRecord() && crXY.readRecord()) {
                cw.write(crXY.get("X"));
                cw.write(crXY.get("Y"));
                float[] data = new float[crN.getColumnCount()];
                for (int i = 0; i < crN.getColumnCount(); ++i) {
                    data[i] = Float.parseFloat(crN.get(i));
                }
                for (k = 1; k < kmeans.size() + 1; ++k) {
                    float d = EcoPaysage.distance((float[])kmeans.get(k), data);
                    cw.write(d + "");
                }
                cw.endRecord();
            }
            crN.close();
            crXY.close();
            cw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void exportExtremeInfo(String extremeFile, String kmeanFile, String normFile) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(extremeFile));
            writer.write("classe");
            CsvReader crN = new CsvReader(normFile);
            crN.setDelimiter(';');
            crN.readHeaders();
            int num = crN.getHeaderCount();
            String[] metrics = new String[num];
            for (int ai = 0; ai < num; ++ai) {
                metrics[ai] = crN.getHeader(ai);
                writer.write(";" + metrics[ai]);
            }
            crN.close();
            writer.newLine();
            TreeMap<Integer, float[]> kmeans = new TreeMap<Integer, float[]>();
            CsvReader crI = new CsvReader(kmeanFile);
            crI.setDelimiter(';');
            crI.readHeaders();
            int nbk = 0;
            while (crI.readRecord()) {
                int k = Integer.parseInt(crI.get("classe"));
                float[] infos = new float[crI.getColumnCount() - 1];
                for (int i = 1; i < crI.getColumnCount(); ++i) {
                    infos[i - 1] = Float.parseFloat(crI.get(i));
                }
                kmeans.put(k, infos);
                nbk = Math.max(k, nbk);
            }
            crI.close();
            TreeMap<Integer, float[]> kExtremes = new TreeMap<Integer, float[]>();
            float[] maxDistances = new float[nbk + 1];
            crN = new CsvReader(normFile);
            crN.setDelimiter(';');
            crN.readHeaders();
            while (crN.readRecord()) {
                float d;
                float[] data = new float[num];
                for (int i = 0; i < num; ++i) {
                    data[i] = Float.parseFloat(crN.get(i));
                }
                float minDistance = Float.MAX_VALUE;
                int classe = -1;
                for (int ki = 1; ki <= nbk; ++ki) {
                    float[] kmean = (float[])kmeans.get(ki);
                    d = EcoPaysage.distance(kmean, data);
                    if (!(d < minDistance)) continue;
                    minDistance = d;
                    classe = ki;
                }
                minDistance = Float.MAX_VALUE;
                for (int li = 1; li <= nbk; ++li) {
                    if (classe == li) continue;
                    float[] lmean = (float[])kmeans.get(li);
                    d = EcoPaysage.distance(lmean, data);
                    minDistance = Math.min(d, minDistance);
                }
                if (!(minDistance > maxDistances[classe])) continue;
                maxDistances[classe] = minDistance;
                kExtremes.put(classe, data);
            }
            for (int ki = 1; ki <= nbk; ++ki) {
                writer.write(ki + "");
                for (float fi : (float[])kExtremes.get(ki)) {
                    writer.write(";" + fi);
                }
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void fuzzyPaul() {
        int k;
        for (k = 1; k <= 5; ++k) {
            Coverage cov = CoverageManager.getCoverage(path + "gradient_ecopaysages_essai_5classes_ecop" + k + "_500m.tif");
            entete = cov.getEntete();
            covs.put(k, cov.getData());
            cov.dispose();
        }
        for (k = 1; k <= 5; ++k) {
            ScriptTestFuzzy.generateFuzzyGradient(k);
        }
    }

    private static void generateFuzzyGradient(int k) {
        float[] data = new float[entete.width() * entete.height()];
        for (int ind = 0; ind < data.length; ++ind) {
            float gk = covs.get(k)[ind];
            float sum = 0.0f;
            for (int l = 1; l <= 5; ++l) {
                if (l == k) continue;
                float gl = covs.get(l)[ind];
                sum = (float)((double)sum + Math.pow(gk / gl, 2.0));
            }
            data[ind] = 1.0f / sum;
        }
        CoverageManager.write(path + "fuzzy_" + k + ".tif", data, entete);
    }
}

