/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.ecopaysage.script;

import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageManager;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageProcedure;
import java.io.File;
import java.util.HashSet;

public class ScriptEcopaysagesBretagne {
    public static void main(String[] args) {
        int[] scales = new int[]{3000};
        ScriptEcopaysagesBretagne.ecolandscape(scales);
    }

    private static void sumRuptures(String ruptureRaster, String folder) {
        EnteteRaster entete = null;
        HashSet<float[]> sets = new HashSet<float[]>();
        for (String file : new File(folder).list()) {
            System.out.println(file);
            Coverage cov = CoverageManager.getCoverage(folder + file);
            entete = cov.getEntete();
            sets.add(cov.getData());
            cov.dispose();
        }
        float[] outData = new float[entete.width() * entete.height()];
        Pixel2PixelTabCalculation cal = new Pixel2PixelTabCalculation(outData, (float[][])sets.toArray((T[])new float[sets.size()][])){

            @Override
            protected float doTreat(float[] v) {
                float value = 0.0f;
                for (float vv : v) {
                    value += Math.min(1.0f, vv) / (float)v.length;
                }
                return value;
            }
        };
        cal.run();
        CoverageManager.write(ruptureRaster, outData, entete);
    }

    private static void ecolandscape(int[] scales) {
        int[] codes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 22, 23};
        EcoPaysageManager epManager = new EcoPaysageManager("mapping");
        epManager.addInputRaster("F:/data/sig/bretagne/bretagne_2021_ebr_clean.tif");
        epManager.setScales(scales);
        epManager.setCodes(codes);
        epManager.setOutputFolder("F:/data/sig/bretagne/ecopaysages3/");
        epManager.setClasses(new int[]{15});
        EcoPaysageProcedure epProcedure = epManager.build();
        epProcedure.run();
    }
}

