/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.standardization;

import fr.inrae.act.bagap.apiland.util.Tool;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.EcoPaysage;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageManager;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageProcedure;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.calculmetrics.EPPCalculMetrics;
import java.io.File;

public class EPPStandardization
extends EcoPaysageProcedure {
    private int scale;

    public EPPStandardization(EcoPaysageManager manager) {
        super(manager);
    }

    public EPPStandardization(EcoPaysageManager manager, int specificScale) {
        this(manager);
        this.scale = specificScale;
    }

    @Override
    public void doInit() {
        if (this.scale == 0) {
            this.scale = this.manager().scale();
        }
        if (this.manager().force() || !new File(this.manager().metricsFile(this.scale)).exists()) {
            new EPPCalculMetrics(this.manager(), this.scale).run();
        }
        if (!new File(this.manager().xyFile()).exists()) {
            System.out.println("generation du fichier de masque XY");
            EcoPaysage.generateMask(this.manager().metricsFile(), this.manager().xyFile());
        }
    }

    @Override
    public void doRun() {
        System.out.println("split des donnees de composition et de configuration");
        EcoPaysage.splitCompoConfig(this.manager().metricsFiles(this.scale), this.manager().xyFile(), this.manager().compoFile(this.scale), this.manager().configFile(this.scale), this.manager().compoMetrics(), this.manager().configMetrics());
        System.out.println("standardisation des donnees de composition");
        float inertia = EcoPaysage.standardize(this.manager().compoFile(this.scale), this.manager().compoMetrics(), this.manager().importances(), this.scale);
        this.manager().setInertia("composition_" + this.scale + "m", inertia);
        System.out.println("standardisation des donnees de configuration");
        float[][] distances = null;
        inertia = EcoPaysage.standardize(this.manager().configFile(this.scale), this.manager().configMetrics(), this.manager().importances(), distances, this.scale);
        this.manager().setInertia("configuration_" + this.scale + "m", inertia);
        System.out.println("compilation des donnees standardisees de composition et de configuration");
        EcoPaysage.compileStdCompoConfig(this.manager().standardizedFile(this.scale), this.manager().compoFile(this.scale), this.manager().configFile(this.scale), this.manager().compoMetrics(), this.manager().configMetrics(), this.scale);
        Tool.deleteFile(this.manager().compoFile(this.scale));
        Tool.deleteFile(this.manager().configFile(this.scale));
        EcoPaysage.exportInertia(this.manager().inertiaFile(), this.manager().inerties());
    }
}

