/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.rupture;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.EcoPaysage;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageManager;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageProcedure;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.mapping.EPPMapping;
import java.io.File;

public class EPPRupture
extends EcoPaysageProcedure {
    public EPPRupture(EcoPaysageManager manager) {
        super(manager);
    }

    @Override
    public void doInit() {
        boolean force = this.manager().force();
        block0: for (String carto : this.manager().cartos().values()) {
            for (int k : this.manager().classes()) {
                if (new File(this.manager().mapFile(carto, k)).exists()) continue;
                force = true;
                continue block0;
            }
        }
        if (force) {
            new EPPMapping(this.manager()).run();
        }
    }

    @Override
    public void doRun() {
        System.out.println("recuperation de l'entete raster");
        EnteteRaster header = EcoPaysage.getHeader(this.manager().headerFile(), this.manager().noDataValue());
        System.out.println("generation des fichiers de distance thematique");
        for (int k : this.manager().classes()) {
            EcoPaysage.generateThematicDistanceFile(this.manager().infoFile(k), this.manager().thematicDistanceFile(k));
        }
        System.out.println("analyse de fronts de rupture");
        EcoPaysage.analyseRuptures(this.manager().ruptureFile(), this.manager().mapFiles(), this.manager().thematicDistanceFiles(), header);
    }
}

