/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.mapping;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.EcoPaysage;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageManager;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageProcedure;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.clustering.EPPClustering;
import java.io.File;

public class EPPMapping
extends EcoPaysageProcedure {
    public EPPMapping(EcoPaysageManager manager) {
        super(manager);
    }

    @Override
    public void doInit() {
        boolean force = this.manager().force();
        block0: for (String inputRaster : this.manager().inputRasters()) {
            String carto = this.manager().carto(inputRaster);
            for (int k : this.manager().classes()) {
                if (new File(this.manager().ecoFile(carto, k)).exists()) continue;
                force = true;
                continue block0;
            }
        }
        if (force) {
            new EPPClustering(this.manager()).run();
        }
    }

    @Override
    public void doRun() {
        System.out.println("recuperation de l'entete raster");
        EnteteRaster header = EcoPaysage.getHeader(this.manager().headerFile(), this.manager().noDataValue());
        for (String inputRaster : this.manager().inputRasters()) {
            String carto = this.manager().carto(inputRaster);
            for (int k : this.manager().classes()) {
                System.out.println("export cartographique vers " + this.manager().mapFile(carto, k));
                EcoPaysage.exportMap(this.manager().mapFile(carto, k), this.manager().ecoFile(carto, k), k, header);
            }
        }
    }
}

