/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.gradient;

import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.EcoPaysage;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageManager;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageProcedure;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.clustering.EPPClustering;
import java.io.File;

public class EPPGradient
extends EcoPaysageProcedure {
    public EPPGradient(EcoPaysageManager manager) {
        super(manager);
    }

    @Override
    public void doInit() {
        boolean force = this.manager().force();
        block0: for (String carto : this.manager().cartos().values()) {
            for (int k : this.manager().classes()) {
                if (new File(this.manager().ecoFile(carto, k)).exists()) continue;
                force = true;
                continue block0;
            }
        }
        if (force) {
            new EPPClustering(this.manager()).run();
        }
    }

    @Override
    public void doRun() {
        System.out.println("recuperation du masque");
        String[][] dataXY = EcoPaysage.importXY(this.manager().xyFile());
        if (!new File(this.manager().standardizedFile()).exists()) {
            if (this.manager().hasMultipleScales()) {
                EcoPaysage.compileFiles(this.manager().standardizedFile(), dataXY.length, this.manager().standardizedFiles());
            } else {
                this.manager().setStandardizedFile(this.manager().standardizedFile(this.manager().scale()));
            }
        }
        for (int k : this.manager().classes()) {
            System.out.println("analyse des distances aux clustering pour " + k + " classes");
            EcoPaysage.analyseGradient(this.manager().gradientFile(k), dataXY, this.manager().infoFile(k), this.manager().standardizedFile());
        }
        System.out.println("recuperation de l'entete raster");
        EnteteRaster header = EcoPaysage.getHeader(this.manager().headerFile(), this.manager().noDataValue());
        for (int k : this.manager().classes()) {
            for (int ik = 1; ik <= k; ++ik) {
                System.out.println("export cartographique vers " + this.manager().gradientMapFile(k, ik));
                EcoPaysage.exportMap(this.manager().gradientMapFile(k, ik), this.manager().gradientFile(k), ik, header);
            }
        }
    }
}

