/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.clustering;

import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.EcoPaysage;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageManager;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageProcedure;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.standardization.EPPStandardization;
import java.io.File;
import weka.clusterers.SimpleKMeans;
import weka.core.Instances;

public class EPPClustering
extends EcoPaysageProcedure {
    public EPPClustering(EcoPaysageManager manager) {
        super(manager);
    }

    @Override
    public void doInit() {
        for (int scale : this.manager().scales()) {
            if (!this.manager().force() && new File(this.manager().standardizedFile(scale)).exists()) continue;
            new EPPStandardization(this.manager(), scale).run();
        }
    }

    @Override
    public void doRun() {
        System.out.println("recuperation du masque");
        String[][] dataXY = EcoPaysage.importXY(this.manager().xyFile());
        if (!new File(this.manager().standardizedFile()).exists()) {
            if (this.manager().hasMultipleScales()) {
                EcoPaysage.compileFiles(this.manager().standardizedFile(), dataXY.length, this.manager().standardizedFiles());
            } else {
                this.manager().setStandardizedFile(this.manager().standardizedFile(this.manager().scale()));
            }
        }
        System.out.println("integration des donnees");
        Instances data = null;
        data = this.manager().factor() == 1 ? EcoPaysage.readData(this.manager().standardizedFile()) : EcoPaysage.readData(this.manager().standardizedFile(), dataXY, this.manager().factor(), this.manager().entete());
        for (int k : this.manager().classes()) {
            System.out.println("clusterisation a " + k + " classes");
            SimpleKMeans kmeans = EcoPaysage.kmeans(data, k);
            int index = 1;
            for (String inputRaster : this.manager().inputRasters()) {
                String carto = this.manager().carto(inputRaster);
                System.out.println("export en csv vers " + this.manager().ecoFile(carto, k));
                if (this.manager().factor() == 1) {
                    EcoPaysage.exportCSV(this.manager().ecoFile(carto, k), kmeans, k, dataXY, data, index);
                } else {
                    EcoPaysage.exportCSV(this.manager().ecoFile(carto, k), kmeans, k, dataXY, this.manager().standardizedFile(), data);
                }
                ++index;
            }
            System.out.println("export des infos vers " + this.manager().infoFile(k));
            EcoPaysage.exportInfo(this.manager().infoFile(k), kmeans, k, data, this.manager().importances());
        }
    }
}

