/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.EcoPaysage;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageProcedure;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.EcoPaysageProcedureFactory;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.calculmetrics.EPPCalculMetricsFactory;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.clustering.EPPClusteringFactory;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.gradient.EPPGradientFactory;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.mapping.EPPMappingFactory;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.rupture.EPPRuptureFactory;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.analyse.procedure.standardization.EPPStandardizationFactory;
import fr.inrae.act.bagap.chloe.util.Util;
import fr.inrae.act.bagap.chloe.window.WindowDistanceType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class EcoPaysageManager {
    private EcoPaysageProcedureFactory factory;
    private boolean force;
    private Map<String, Map<Integer, String>> metricsFiles;
    private String xyFile;
    private String carto;
    private Map<String, String> cartos;
    private Set<String> inputRasters;
    private String outputFolder;
    private Map<Integer, String> compoFiles;
    private Map<Integer, String> configFiles;
    private Map<Integer, String> stdFiles;
    private String stdFile;
    private String ruptureFile;
    private String inertiaFile;
    private int[] scales;
    private List<String> compoMetrics;
    private List<String> configMetrics;
    private int[] codes;
    private boolean initMetrics;
    private int[] classes;
    private int factor;
    private Map<String, Map<Integer, String>> ecoFiles;
    private Map<String, Map<Integer, String>> mapFiles;
    private Map<Integer, String> infoFiles;
    private Map<Integer, String> gradientFiles;
    private Map<Integer, String> thematicDistanceFiles;
    private Map<Integer, Map<Integer, String>> gradientMapFiles;
    private String headerFile;
    private int noDataValue;
    private int[] unfilters;
    private EnteteRaster inEntete;
    private int displacement;
    private WindowDistanceType distanceType;
    private String codeImportanceFile;
    private String metricImportanceFile;
    private Map<String, Float> importances;
    private Map<String, Float> inerties;

    public EcoPaysageManager(String treatment) {
        this.setTreatment(treatment);
        this.init();
    }

    private void setTreatment(String treatment) {
        switch (treatment) {
            case "calcul_metrics": {
                this.factory = new EPPCalculMetricsFactory();
                break;
            }
            case "standardization": {
                this.factory = new EPPStandardizationFactory();
                break;
            }
            case "clustering": {
                this.factory = new EPPClusteringFactory();
                break;
            }
            case "gradient": {
                this.factory = new EPPGradientFactory();
                break;
            }
            case "mapping": {
                this.factory = new EPPMappingFactory();
                break;
            }
            case "rupture": {
                this.factory = new EPPRuptureFactory();
                break;
            }
            default: {
                throw new IllegalArgumentException("treatment '" + treatment + "' do not exists");
            }
        }
    }

    private void init() {
        this.force = false;
        this.metricsFiles = new TreeMap<String, Map<Integer, String>>();
        this.xyFile = null;
        this.stdFile = null;
        this.inertiaFile = null;
        this.compoFiles = new TreeMap<Integer, String>();
        this.configFiles = new TreeMap<Integer, String>();
        this.stdFiles = new TreeMap<Integer, String>();
        this.ruptureFile = null;
        this.inputRasters = new TreeSet<String>();
        this.carto = "essai";
        this.cartos = new TreeMap<String, String>();
        this.scales = null;
        this.unfilters = null;
        this.codes = null;
        this.compoMetrics = null;
        this.configMetrics = null;
        this.outputFolder = null;
        this.classes = null;
        this.ecoFiles = new TreeMap<String, Map<Integer, String>>();
        this.mapFiles = new TreeMap<String, Map<Integer, String>>();
        this.infoFiles = new TreeMap<Integer, String>();
        this.gradientFiles = new TreeMap<Integer, String>();
        this.thematicDistanceFiles = new TreeMap<Integer, String>();
        this.gradientMapFiles = new TreeMap<Integer, Map<Integer, String>>();
        this.headerFile = null;
        this.factor = 1;
        this.noDataValue = -1;
        this.displacement = 20;
        this.distanceType = WindowDistanceType.FAST_GAUSSIAN;
        this.importances = null;
        this.codeImportanceFile = null;
        this.metricImportanceFile = null;
        this.inerties = new TreeMap<String, Float>();
    }

    public EcoPaysageProcedure build() {
        if (this.factory.check(this)) {
            if (this.codeImportanceFile != null) {
                this.importances = EcoPaysage.initImportanceByCode(this.codeImportanceFile, true, true, this.scales);
            } else if (this.metricImportanceFile != null) {
                this.importances = EcoPaysage.initImportanceByMetric(this.metricImportanceFile);
            } else {
                if (this.codes == null) {
                    this.initCodes();
                }
                this.initImportances(this.codes, this.scales);
            }
            EcoPaysageProcedure gbProcedure = this.factory.create(this);
            return gbProcedure;
        }
        throw new IllegalArgumentException("parameters are unconsistant");
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void addMetricsFile(String carto, int scale, String metricsFile) {
        Util.createAccess(metricsFile);
        if (!this.metricsFiles.containsKey(carto)) {
            this.metricsFiles.put(carto, new TreeMap());
        }
        this.metricsFiles.get(carto).put(scale, metricsFile);
    }

    public void setXYFile(String xyFile) {
        Util.createAccess(xyFile);
        this.xyFile = xyFile;
    }

    public void setInertiaFile(String inertiaFile) {
        Util.createAccess(inertiaFile);
        this.inertiaFile = inertiaFile;
    }

    public void addCompoFile(int scale, String compoFile) {
        Util.createAccess(compoFile);
        this.compoFiles.put(scale, compoFile);
    }

    public void addConfigFile(int scale, String configFile) {
        Util.createAccess(configFile);
        this.configFiles.put(scale, configFile);
    }

    public void setStandardizedFile(String stdFile) {
        Util.createAccess(stdFile);
        this.stdFile = stdFile;
    }

    public void setRuptureFile(String ruptureFile) {
        Util.createAccess(ruptureFile);
        this.ruptureFile = ruptureFile;
    }

    public void addStandardizedFile(int scale, String stdFile) {
        Util.createAccess(stdFile);
        this.stdFiles.put(scale, stdFile);
    }

    public void addInputRaster(String inputRaster) {
        this.inputRasters.add(inputRaster);
        if (this.inEntete == null) {
            Coverage cov = CoverageManager.getCoverage(inputRaster);
            this.inEntete = cov.getEntete();
            cov.dispose();
        }
        this.cartos.put(inputRaster, new File(inputRaster).getName().replace(".tif", "").replace(".asc", ""));
    }

    public void setOutputFolder(String outputFolder) {
        Util.createAccess(outputFolder);
        this.outputFolder = outputFolder;
    }

    public void setScale(int scale) {
        this.scales = new int[]{scale};
    }

    public void setScales(int[] scales) {
        this.scales = scales;
    }

    public void setUnfilters(int[] unfilters) {
        this.unfilters = unfilters;
    }

    public void setCodes(int[] codes) {
        this.codes = codes;
        this.setCompositionMetrics(codes);
        this.setConfigurationMetrics(codes);
        this.setInitMetrics(true);
    }

    private void initCodes() {
        Coverage cov = CoverageManager.getCoverage(this.inputRasters.iterator().next());
        int width = cov.getEntete().width();
        int height = cov.getEntete().height();
        int noDataValue = cov.getEntete().noDataValue();
        this.setCodes(Util.readValues(cov, width, height, noDataValue));
        cov.dispose();
    }

    private void initImportances(int[] codes, int[] scales) {
        this.importances = new TreeMap<String, Float>();
        for (int scale : scales) {
            for (int code1 : codes) {
                this.importances.put("pNV_" + code1 + "_" + scale + "m", Float.valueOf(1.0f));
                for (int code2 : codes) {
                    if (code1 >= code2) continue;
                    this.importances.put("pNC_" + code1 + "-" + code2 + "_" + scale + "m", Float.valueOf(1.0f));
                }
            }
        }
    }

    public void setNoDataValue(int noDataValue) {
        this.noDataValue = noDataValue;
    }

    private void setInitMetrics(boolean initMetrics) {
        this.initMetrics = initMetrics;
    }

    public boolean initMetrics() {
        return this.initMetrics;
    }

    public void setClasses(int[] classes) {
        this.classes = classes;
    }

    public void setFactor(int factor) {
        this.factor = factor;
    }

    public void addCompositionMetric(String metric) {
        if (this.compoMetrics == null) {
            this.compoMetrics = new ArrayList<String>();
        }
        this.compoMetrics.add(metric);
    }

    public void addConfigurationMetric(String metric) {
        if (this.configMetrics == null) {
            this.configMetrics = new ArrayList<String>();
        }
        this.configMetrics.add(metric);
    }

    public void removeCompositionMetric(String metric) {
        if (this.compoMetrics != null) {
            this.compoMetrics.remove(metric);
        }
    }

    public void removeConfigurationMetric(String metric) {
        if (this.configMetrics != null) {
            this.configMetrics.remove(metric);
        }
    }

    private void setCompositionMetrics(int[] codes) {
        this.compoMetrics = new ArrayList<String>();
        for (int c : codes) {
            this.compoMetrics.add("pNV_" + c);
        }
    }

    private void setConfigurationMetrics(int[] codes) {
        this.configMetrics = new ArrayList<String>();
        for (int c1 : codes) {
            for (int c2 : codes) {
                if (c1 >= c2) continue;
                this.configMetrics.add("pNC_" + c1 + "-" + c2);
            }
        }
    }

    public void setCodeImportanceFile(String codeImportanceFile) {
        this.codeImportanceFile = codeImportanceFile;
    }

    public void setMetricImportanceFile(String metricImportanceFile) {
        this.metricImportanceFile = metricImportanceFile;
    }

    public void addEcoFile(String carto, int k, String ecoFile) {
        Util.createAccess(ecoFile);
        if (!this.ecoFiles.containsKey(carto)) {
            this.ecoFiles.put(carto, new TreeMap());
        }
        this.ecoFiles.get(carto).put(k, ecoFile);
    }

    public void addMapFile(String carto, int k, String mapFile) {
        Util.createAccess(mapFile);
        if (!this.mapFiles.containsKey(carto)) {
            this.mapFiles.put(carto, new TreeMap());
        }
        this.mapFiles.get(carto).put(k, mapFile);
    }

    public void setInfoFile(int k, String infoFile) {
        Util.createAccess(infoFile);
        this.infoFiles.put(k, infoFile);
    }

    public void setThematicDistanceFile(int k, String thematicDistanceFile) {
        Util.createAccess(thematicDistanceFile);
        this.thematicDistanceFiles.put(k, thematicDistanceFile);
    }

    public void setGradientFile(int k, String gradientFile) {
        Util.createAccess(gradientFile);
        this.gradientFiles.put(k, gradientFile);
    }

    public void setGradientMapFile(int k, int ik, String gradientMapFile) {
        Util.createAccess(gradientMapFile);
        if (!this.gradientMapFiles.containsKey(k)) {
            this.gradientMapFiles.put(k, new TreeMap());
        }
        this.gradientMapFiles.get(k).put(ik, gradientMapFile);
    }

    public void setHeaderFile(String headerFile) {
        this.headerFile = headerFile;
    }

    public void setDisplacement(int displacement) {
        this.displacement = displacement;
    }

    public void setWindowDistanceType(WindowDistanceType distanceType) {
        this.distanceType = distanceType;
    }

    public void setInertia(String group, float inertia) {
        this.inerties.put(group, Float.valueOf(inertia));
    }

    public boolean force() {
        return this.force;
    }

    public String metricsFile() {
        return this.metricsFile(this.cartos.get(this.inputRasters.iterator().next()), this.scales[0]);
    }

    public String metricsFile(int scale) {
        String carto = this.cartos.get(this.inputRasters.iterator().next());
        return this.metricsFile(carto, scale);
    }

    public Set<String> metricsFiles(int scale) {
        TreeSet<String> files = new TreeSet<String>();
        for (String carto : this.cartos.values()) {
            files.add(this.metricsFile(carto, scale));
        }
        return files;
    }

    public String metricsFile(String carto, int scale) {
        if (!this.metricsFiles.containsKey(carto) || !this.metricsFiles.get(carto).containsKey(scale)) {
            this.addMetricsFile(carto, scale, this.outputFolder() + "metrics_" + carto + "_" + scale + "m.csv");
        }
        return this.metricsFiles.get(carto).get(scale);
    }

    public String ecoFile(String carto, int k) {
        if (!this.ecoFiles.containsKey(carto) || !this.ecoFiles.get(carto).containsKey(k)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.outputFolder() + "ecopaysages_" + carto + "_" + k + "classes");
            for (int scale : this.scales) {
                sb.append("_" + scale + "m");
            }
            sb.append(".csv");
            this.addEcoFile(carto, k, sb.toString());
        }
        return this.ecoFiles.get(carto).get(k);
    }

    public String mapFile(String carto, int k) {
        if (!this.mapFiles.containsKey(carto) || !this.mapFiles.get(carto).containsKey(k)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.outputFolder() + "ecopaysages_" + carto + "_" + k + "classes");
            for (int scale : this.scales) {
                sb.append("_" + scale + "m");
            }
            sb.append(".tif");
            this.addMapFile(carto, k, sb.toString());
        }
        return this.mapFiles.get(carto).get(k);
    }

    public String xyFile() {
        if (this.xyFile == null) {
            this.setXYFile(this.outputFolder() + "metrics_" + this.carto + "_XY.csv");
        }
        return this.xyFile;
    }

    public String compoFile(int scale) {
        if (!this.compoFiles.containsKey(scale)) {
            this.compoFiles.put(scale, this.outputFolder() + "composition_metrics_" + this.carto + "_" + scale + "m.csv");
        }
        return this.compoFiles.get(scale);
    }

    public String configFile(int scale) {
        if (!this.configFiles.containsKey(scale)) {
            this.configFiles.put(scale, this.outputFolder() + "configuration_metrics_" + this.carto + "_" + scale + "m.csv");
        }
        return this.configFiles.get(scale);
    }

    public String standardizedFile() {
        if (this.stdFile == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.outputFolder() + "standardized_metrics_" + this.carto);
            for (int scale : this.scales) {
                sb.append("_" + scale + "m");
            }
            sb.append(".csv");
            this.setStandardizedFile(sb.toString());
        }
        return this.stdFile;
    }

    public String inertiaFile() {
        if (this.inertiaFile == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.outputFolder() + "inertia_" + this.carto);
            sb.append(".csv");
            this.setInertiaFile(sb.toString());
        }
        return this.inertiaFile;
    }

    public String standardizedFile(int scale) {
        if (!this.stdFiles.containsKey(scale)) {
            this.stdFiles.put(scale, this.outputFolder() + "standardized_metrics_" + this.carto + "_" + scale + "m.csv");
        }
        return this.stdFiles.get(scale);
    }

    public String ruptureFile() {
        if (this.ruptureFile == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.outputFolder() + "rupture_" + this.carto);
            for (int scale : this.scales) {
                sb.append("_" + scale + "m");
            }
            sb.append(".tif");
            this.setRuptureFile(sb.toString());
        }
        return this.ruptureFile;
    }

    public Set<String> inputRasters() {
        return this.inputRasters;
    }

    public String carto() {
        return this.carto;
    }

    public Map<String, String> cartos() {
        return this.cartos;
    }

    public String carto(String inputRaster) {
        return this.cartos.get(inputRaster);
    }

    public String outputFolder() {
        return this.outputFolder;
    }

    public int scale() {
        return this.scales[0];
    }

    public int[] scales() {
        return this.scales;
    }

    public int[] unfilters() {
        if (this.unfilters == null) {
            this.unfilters = new int[]{this.noDataValue()};
        }
        return this.unfilters;
    }

    public int noDataValue() {
        return this.noDataValue;
    }

    public boolean hasMultipleScales() {
        return this.scales.length > 1;
    }

    public int[] codes() {
        return this.codes;
    }

    public List<String> compoMetrics() {
        return this.compoMetrics;
    }

    public List<String> configMetrics() {
        return this.configMetrics;
    }

    public int[] classes() {
        return this.classes;
    }

    public int factor() {
        return this.factor;
    }

    public EnteteRaster entete() {
        return this.inEntete;
    }

    public int displacement() {
        return this.displacement;
    }

    public WindowDistanceType windowDistanceType() {
        return this.distanceType;
    }

    public String infoFile(int k) {
        if (!this.infoFiles.containsKey(k)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.outputFolder() + "info_ecopaysages_" + this.carto + "_" + k + "classes");
            for (int scale : this.scales) {
                sb.append("_" + scale + "m");
            }
            sb.append(".csv");
            this.setInfoFile(k, sb.toString());
        }
        return this.infoFiles.get(k);
    }

    public String thematicDistanceFile(int k) {
        if (!this.thematicDistanceFiles.containsKey(k)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.outputFolder() + "distance_ecopaysages_" + this.carto + "_" + k + "classes");
            for (int scale : this.scales) {
                sb.append("_" + scale + "m");
            }
            sb.append(".txt");
            this.setThematicDistanceFile(k, sb.toString());
        }
        return this.thematicDistanceFiles.get(k);
    }

    public String gradientFile(int k) {
        if (!this.gradientFiles.containsKey(k)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.outputFolder() + "gradient_ecopaysages_" + this.carto + "_" + k + "classes");
            for (int scale : this.scales) {
                sb.append("_" + scale + "m");
            }
            sb.append(".csv");
            this.setGradientFile(k, sb.toString());
        }
        return this.gradientFiles.get(k);
    }

    public String gradientMapFile(int k, int ik) {
        if (!this.gradientMapFiles.containsKey(k) || !this.gradientMapFiles.get(k).containsKey(ik)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.outputFolder() + "gradient_ecopaysages_" + this.carto + "_" + k + "classes_ecop" + ik);
            for (int scale : this.scales) {
                sb.append("_" + scale + "m");
            }
            sb.append(".tif");
            this.setGradientMapFile(k, ik, sb.toString());
        }
        return this.gradientMapFiles.get(k).get(ik);
    }

    public String[] thematicDistanceFiles() {
        if (this.thematicDistanceFiles.size() == 0) {
            for (int k : this.classes()) {
                this.thematicDistanceFile(k);
            }
        }
        return this.thematicDistanceFiles.values().toArray(new String[this.thematicDistanceFiles.size()]);
    }

    public String[] mapFiles() {
        if (this.mapFiles.size() == 0) {
            for (String carto : this.cartos.values()) {
                for (int k : this.classes()) {
                    this.mapFile(carto, k);
                }
            }
        }
        return this.mapFiles.values().toArray(new String[this.mapFiles.size()]);
    }

    public String headerFile() {
        if (this.headerFile == null) {
            File f = new File(this.metricsFile());
            String name = f.getName().replace(".txt", "").replace(".csv", "");
            this.setHeaderFile(f.getParent() + "/" + name + "_header.txt");
        }
        return this.headerFile;
    }

    public Map<Integer, String> standardizedFiles() {
        return this.stdFiles;
    }

    public Map<String, Float> importances() {
        return this.importances;
    }

    public Map<String, Float> inerties() {
        return this.inerties;
    }
}

