/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.cluster.distance;

import fr.inrae.act.bagap.apiland.analysis.Analysis;
import fr.inrae.act.bagap.apiland.analysis.tab.Pixel2PixelTabCalculation;
import fr.inrae.act.bagap.chloe.cluster.chess.TabQueenClusteringAnalysis;
import java.util.HashSet;
import java.util.Set;

public class TabDistanceClusteringAnalysis
extends Analysis {
    private float[] inDatas;
    private float[] distanceDatas;
    private double distance;
    private int height;
    private int width;
    private Set<Float> interest;
    private int noDataValue;

    public TabDistanceClusteringAnalysis(float[] inDatas, float[] distanceDatas, int width, int height, int[] interest, double distance, int noDataValue) {
        this.inDatas = inDatas;
        this.distanceDatas = distanceDatas;
        this.distance = distance;
        this.width = width;
        this.height = height;
        this.interest = new HashSet<Float>();
        for (int v : interest) {
            this.interest.add(Float.valueOf(v));
        }
        this.noDataValue = noDataValue;
    }

    @Override
    protected void doRun() {
        this.setResult(this.overlay(this.queenClustering(this.classification())));
    }

    private float[] classification() {
        float[] outDatas = new float[this.width * this.height];
        Pixel2PixelTabCalculation classif = new Pixel2PixelTabCalculation(outDatas, (float[][])new float[][]{this.distanceDatas}){

            @Override
            protected float doTreat(float[] values) {
                double vd = values[0];
                if (vd == (double)TabDistanceClusteringAnalysis.this.noDataValue) {
                    return TabDistanceClusteringAnalysis.this.noDataValue;
                }
                if (vd >= 0.0 && vd <= TabDistanceClusteringAnalysis.this.distance / 2.0) {
                    return 1.0f;
                }
                return 0.0f;
            }
        };
        classif.run();
        return outDatas;
    }

    private float[] queenClustering(float[] classifDatas) {
        TabQueenClusteringAnalysis qa = new TabQueenClusteringAnalysis(classifDatas, this.width, this.height, new int[]{1}, this.noDataValue);
        float[] tabCluster = (float[])qa.allRun();
        return tabCluster;
    }

    private float[] overlay(float[] queenDatas) {
        float[] outDatas = new float[this.width * this.height];
        Pixel2PixelTabCalculation overl = new Pixel2PixelTabCalculation(outDatas, (float[][])new float[][]{this.inDatas, queenDatas}){

            @Override
            protected float doTreat(float[] values) {
                float v = values[0];
                if (v == (float)TabDistanceClusteringAnalysis.this.noDataValue) {
                    return TabDistanceClusteringAnalysis.this.noDataValue;
                }
                if (TabDistanceClusteringAnalysis.this.interest.contains(Float.valueOf(v))) {
                    return values[1];
                }
                return 0.0f;
            }
        };
        overl.run();
        return outDatas;
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doClose() {
        this.inDatas = null;
        this.distanceDatas = null;
    }
}

