/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.cluster.chess;

import fr.inrae.act.bagap.apiland.analysis.Analysis;
import fr.inrae.act.bagap.apiland.analysis.tab.SearchAndReplacePixel2PixelTabCalculation;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.apiland.raster.TileCoverage;
import fr.inrae.act.bagap.chloe.cluster.chess.TabQueenClusteringAnalysis;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TileQueenClusteringAnalysis
extends Analysis {
    private String outputFolder;
    private TileCoverage inCoverage;
    private int noDataValue;
    private int[] interest;

    public TileQueenClusteringAnalysis(String outputFolder, TileCoverage inCoverage, int[] interest, int noDataValue) {
        this.outputFolder = outputFolder;
        this.inCoverage = inCoverage;
        this.interest = interest;
        this.noDataValue = noDataValue;
    }

    @Override
    protected void doInit() {
    }

    @Override
    protected void doRun() {
        Map cluster;
        int numTile;
        Coverage localClusterCoverage;
        float[] localClusterData;
        EnteteRaster localEntete;
        float[] localData;
        Coverage localCoverage;
        System.out.println("calcul des clusters par tuile (independamment)");
        int ncols = this.inCoverage.ncols();
        int nrows = this.inCoverage.nrows();
        int width = this.inCoverage.tileWidth();
        for (int j = 0; j < nrows; ++j) {
            for (int i = 0; i < ncols; ++i) {
                localCoverage = this.inCoverage.getCoverage(i, j);
                if (localCoverage == null) continue;
                localData = localCoverage.getData();
                localEntete = localCoverage.getEntete();
                TabQueenClusteringAnalysis clustering = new TabQueenClusteringAnalysis(localData, width, width, this.interest, this.noDataValue);
                localClusterData = (float[])clustering.allRun();
                CoverageManager.writeGeotiff(this.outputFolder + "cluster_" + (int)localEntete.minx() / 1000 + "_" + (int)localEntete.maxy() / 1000 + ".tif", localClusterData, localEntete);
            }
        }
        TileCoverage covInitCluster = (TileCoverage)CoverageManager.getCoverage(this.outputFolder);
        System.out.println("calcul des correspondances");
        HashMap correspondances = new HashMap();
        for (int j = 0; j < nrows; ++j) {
            for (int i = 0; i < ncols; ++i) {
                int vvo;
                Map clustero;
                int vo;
                localClusterCoverage = covInitCluster.getCoverage(i, j);
                if (localClusterCoverage == null) continue;
                numTile = j * ncols + i;
                localClusterData = localClusterCoverage.getData();
                correspondances.put(numTile, new HashMap());
                for (float vc : localClusterData) {
                    if (!(vc > 0.0f) || ((Map)correspondances.get(numTile)).containsKey((int)vc)) continue;
                    ((Map)correspondances.get(numTile)).put((int)vc, new HashMap());
                    ((Map)((Map)correspondances.get(numTile)).get((int)vc)).put(numTile, new HashSet());
                    ((Set)((Map)((Map)correspondances.get(numTile)).get((int)vc)).get(numTile)).add((int)vc);
                }
                int v = (int)localClusterData[0];
                if (v > 0 && (localCoverage = covInitCluster.getCoverage(i - 1, j - 1)) != null && (vo = (int)(localData = localCoverage.getData())[width * width - 1]) > 0 && (cluster = (Map)((Map)correspondances.get(j * ncols + i)).get(v)) != (clustero = (Map)((Map)correspondances.get((j - 1) * ncols + (i - 1))).get(vo))) {
                    Object object = clustero.entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry entry = (Map.Entry)object.next();
                        if (!cluster.containsKey(entry.getKey())) {
                            cluster.put((Integer)entry.getKey(), new HashSet());
                        }
                        ((Set)cluster.get(entry.getKey())).addAll((Collection)entry.getValue());
                    }
                    for (Map.Entry entry : cluster.entrySet()) {
                        Iterator iterator = ((Set)entry.getValue()).iterator();
                        while (iterator.hasNext()) {
                            int vvo2 = (Integer)iterator.next();
                            ((Map)correspondances.get(entry.getKey())).put(vvo2, cluster);
                        }
                    }
                }
                if ((localCoverage = covInitCluster.getCoverage(i, j - 1)) != null) {
                    localData = localCoverage.getData();
                    for (int x = 0; x < width; ++x) {
                        Iterator vvo2;
                        v = (int)localClusterData[x];
                        if (v <= 0) continue;
                        if (x > 0 && (vo = (int)localData[(width - 1) * width + (x - 1)]) > 0 && (cluster = (Map)((Map)correspondances.get(j * ncols + i)).get(v)) != (clustero = (Map)((Map)correspondances.get((j - 1) * ncols + i)).get(vo))) {
                            for (Map.Entry entry : clustero.entrySet()) {
                                if (!cluster.containsKey(entry.getKey())) {
                                    cluster.put((Integer)entry.getKey(), new HashSet());
                                }
                                ((Set)cluster.get(entry.getKey())).addAll((Collection)entry.getValue());
                            }
                            for (Map.Entry entry : cluster.entrySet()) {
                                vvo2 = ((Set)entry.getValue()).iterator();
                                while (vvo2.hasNext()) {
                                    vvo = (Integer)vvo2.next();
                                    ((Map)correspondances.get(entry.getKey())).put(vvo, cluster);
                                }
                            }
                        }
                        if ((vo = (int)localData[(width - 1) * width + x]) > 0 && (cluster = (Map)((Map)correspondances.get(j * ncols + i)).get(v)) != (clustero = (Map)((Map)correspondances.get((j - 1) * ncols + i)).get(vo))) {
                            for (Map.Entry entry : clustero.entrySet()) {
                                if (!cluster.containsKey(entry.getKey())) {
                                    cluster.put((Integer)entry.getKey(), new HashSet());
                                }
                                ((Set)cluster.get(entry.getKey())).addAll((Collection)entry.getValue());
                            }
                            for (Map.Entry entry : cluster.entrySet()) {
                                vvo2 = ((Set)entry.getValue()).iterator();
                                while (vvo2.hasNext()) {
                                    vvo = (Integer)vvo2.next();
                                    ((Map)correspondances.get(entry.getKey())).put(vvo, cluster);
                                }
                            }
                        }
                        if (x >= width - 1 || (vo = (int)localData[(width - 1) * width + (x + 1)]) <= 0 || (cluster = (Map)((Map)correspondances.get(j * ncols + i)).get(v)) == (clustero = (Map)((Map)correspondances.get((j - 1) * ncols + i)).get(vo))) continue;
                        for (Map.Entry entry : clustero.entrySet()) {
                            if (!cluster.containsKey(entry.getKey())) {
                                cluster.put((Integer)entry.getKey(), new HashSet());
                            }
                            ((Set)cluster.get(entry.getKey())).addAll((Collection)entry.getValue());
                        }
                        for (Map.Entry entry2 : cluster.entrySet()) {
                            vvo2 = ((Set)entry2.getValue()).iterator();
                            while (vvo2.hasNext()) {
                                vvo = (Integer)vvo2.next();
                                ((Map)correspondances.get(entry2.getKey())).put(vvo, cluster);
                            }
                        }
                    }
                }
                if ((v = (int)localClusterData[width - 1]) > 0 && (localCoverage = covInitCluster.getCoverage(i + 1, j - 1)) != null && (vo = (int)(localData = localCoverage.getData())[(width - 1) * width]) > 0 && (cluster = (Map)((Map)correspondances.get(j * ncols + i)).get(v)) != (clustero = (Map)((Map)correspondances.get((j - 1) * ncols + (i + 1))).get(vo))) {
                    for (Map.Entry entry : clustero.entrySet()) {
                        if (!cluster.containsKey(entry.getKey())) {
                            cluster.put((Integer)entry.getKey(), new HashSet());
                        }
                        ((Set)cluster.get(entry.getKey())).addAll((Collection)entry.getValue());
                    }
                    for (Map.Entry entry : cluster.entrySet()) {
                        Iterator entry2 = ((Set)entry.getValue()).iterator();
                        while (entry2.hasNext()) {
                            int vvo3 = (Integer)entry2.next();
                            ((Map)correspondances.get(entry.getKey())).put(vvo3, cluster);
                        }
                    }
                }
                if ((localCoverage = covInitCluster.getCoverage(i - 1, j)) == null) continue;
                localData = localCoverage.getData();
                for (int y = 0; y < width * width; y += width) {
                    Iterator vvo3;
                    v = (int)localClusterData[y];
                    if (v <= 0) continue;
                    if (y > 0 && (vo = (int)localData[y - width + (width - 1)]) > 0 && (cluster = (Map)((Map)correspondances.get(j * ncols + i)).get(v)) != (clustero = (Map)((Map)correspondances.get(j * ncols + (i - 1))).get(vo))) {
                        for (Map.Entry entry : clustero.entrySet()) {
                            if (!cluster.containsKey(entry.getKey())) {
                                cluster.put((Integer)entry.getKey(), new HashSet());
                            }
                            ((Set)cluster.get(entry.getKey())).addAll((Collection)entry.getValue());
                        }
                        for (Map.Entry entry : cluster.entrySet()) {
                            vvo3 = ((Set)entry.getValue()).iterator();
                            while (vvo3.hasNext()) {
                                vvo = (Integer)vvo3.next();
                                ((Map)correspondances.get(entry.getKey())).put(vvo, cluster);
                            }
                        }
                    }
                    if ((vo = (int)localData[y + (width - 1)]) > 0 && (cluster = (Map)((Map)correspondances.get(j * ncols + i)).get(v)) != (clustero = (Map)((Map)correspondances.get(j * ncols + (i - 1))).get(vo))) {
                        for (Map.Entry entry : clustero.entrySet()) {
                            if (!cluster.containsKey(entry.getKey())) {
                                cluster.put((Integer)entry.getKey(), new HashSet());
                            }
                            ((Set)cluster.get(entry.getKey())).addAll((Collection)entry.getValue());
                        }
                        for (Map.Entry entry : cluster.entrySet()) {
                            vvo3 = ((Set)entry.getValue()).iterator();
                            while (vvo3.hasNext()) {
                                vvo = (Integer)vvo3.next();
                                ((Map)correspondances.get(entry.getKey())).put(vvo, cluster);
                            }
                        }
                    }
                    if (y >= (width - 1) * width || (vo = (int)localData[y + width + (width - 1)]) <= 0 || (cluster = (Map)((Map)correspondances.get(j * ncols + i)).get(v)) == (clustero = (Map)((Map)correspondances.get(j * ncols + (i - 1))).get(vo))) continue;
                    for (Map.Entry entry : clustero.entrySet()) {
                        if (!cluster.containsKey(entry.getKey())) {
                            cluster.put((Integer)entry.getKey(), new HashSet());
                        }
                        ((Set)cluster.get(entry.getKey())).addAll((Collection)entry.getValue());
                    }
                    for (Map.Entry entry : cluster.entrySet()) {
                        vvo3 = ((Set)entry.getValue()).iterator();
                        while (vvo3.hasNext()) {
                            vvo = (Integer)vvo3.next();
                            ((Map)correspondances.get(entry.getKey())).put(vvo, cluster);
                        }
                    }
                }
            }
        }
        System.out.println("mise en place de la numerotation globale");
        HashSet<Map> singleClusters = new HashSet<Map>();
        Iterator i = correspondances.keySet().iterator();
        while (i.hasNext()) {
            int nt = (Integer)i.next();
            Iterator iterator = ((Map)correspondances.get(nt)).keySet().iterator();
            while (iterator.hasNext()) {
                int nc = (Integer)iterator.next();
                cluster = (Map)((Map)correspondances.get(nt)).get(nc);
                singleClusters.add(cluster);
            }
        }
        HashMap numerotation = new HashMap();
        Iterator nt = correspondances.keySet().iterator();
        while (nt.hasNext()) {
            int n = (Integer)nt.next();
            numerotation.put(n, new HashMap());
        }
        correspondances = null;
        int index = 1;
        for (Map singleCluster : singleClusters) {
            for (Map.Entry entry : singleCluster.entrySet()) {
                Iterator iterator = ((Set)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    int ev = (Integer)iterator.next();
                    ((Map)numerotation.get(entry.getKey())).put(Float.valueOf(ev), Float.valueOf(index));
                }
            }
            ++index;
        }
        singleClusters = null;
        System.out.println("nombre de clusters totaux = " + (index + 1));
        System.out.println("reaffectation des identifications");
        for (int j = 0; j < nrows; ++j) {
            for (int i2 = 0; i2 < ncols; ++i2) {
                localClusterCoverage = covInitCluster.getCoverage(i2, j);
                if (localClusterCoverage == null) continue;
                localEntete = localClusterCoverage.getEntete();
                numTile = j * ncols + i2;
                localClusterData = localClusterCoverage.getData();
                localData = new float[width * width];
                SearchAndReplacePixel2PixelTabCalculation searchAndReplacePixel2PixelTabCalculation = new SearchAndReplacePixel2PixelTabCalculation(localData, localClusterData, (Map)numerotation.get(numTile));
                searchAndReplacePixel2PixelTabCalculation.run();
                CoverageManager.writeGeotiff(this.outputFolder + "cluster_" + (int)localEntete.minx() / 1000 + "_" + (int)localEntete.maxy() / 1000 + ".tif", localData, localEntete);
            }
        }
    }

    @Override
    protected void doClose() {
    }
}

