/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.cluster;

import fr.inrae.act.bagap.apiland.analysis.Analysis;

public class TabClusteringOutput
extends Analysis {
    private int[] initValues;
    private double totalSurface;
    private double totalSurfaceCarre;
    private int[] counts;
    private int[] sizes;
    private int[] values;
    private double maxSurface;
    private int nbPatch;
    private float[] tabCluster;
    private float[] tabCover;
    private double cellSize;
    private int[] nbPatches;
    private double[] totalSurfaces;
    private double[] totalSurfacesCarres;
    private double[] maxSurfaces;
    private int noDataValue;

    public TabClusteringOutput(float[] tabCluster, float[] tabCover, int[] initValues, double cellSize, int noDataValue) {
        this.tabCluster = tabCluster;
        this.tabCover = tabCover;
        this.initValues = initValues;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
    }

    public int getNbPatch() {
        return this.nbPatch;
    }

    public double getTotalSurface() {
        return this.totalSurface;
    }

    public double getTotalSurfaceCarre() {
        return this.totalSurfaceCarre;
    }

    public double getMaxSurface() {
        return this.maxSurface;
    }

    public int getNbPatch(int v) {
        return this.nbPatches[v];
    }

    public double getTotalSurface(int v) {
        return this.totalSurfaces[v];
    }

    public double getTotalSurfaceCarre(int v) {
        return this.totalSurfacesCarres[v];
    }

    public double getMaxSurface(int v) {
        return this.maxSurfaces[v];
    }

    @Override
    protected void doInit() {
        this.nbPatch = 0;
        this.totalSurface = 0.0;
        this.totalSurfaceCarre = 0.0;
        int vMax = 0;
        for (float vC : this.tabCluster) {
            if (vC == (float)this.noDataValue || vC == 0.0f) continue;
            vMax = Math.max(vMax, (int)vC);
        }
        this.counts = new int[vMax + 1];
        this.sizes = new int[vMax + 1];
        this.values = new int[vMax + 1];
        vMax = 0;
        for (int iv : this.initValues) {
            vMax = Math.max(vMax, iv);
        }
        this.nbPatches = new int[vMax + 1];
        this.totalSurfaces = new double[vMax + 1];
        this.totalSurfacesCarres = new double[vMax + 1];
        this.maxSurfaces = new double[vMax + 1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doRun() {
        void var4_7;
        int cover;
        int nbPixel = 0;
        int ind = 0;
        for (float vC : this.tabCluster) {
            if (vC != (float)this.noDataValue && vC != 0.0f) {
                this.counts[(int)vC] = 1;
                ++nbPixel;
                int n = (int)vC;
                this.sizes[n] = this.sizes[n] + 1;
                this.values[(int)vC] = cover = (int)this.tabCover[ind];
                int n2 = cover;
                this.totalSurfaces[n2] = this.totalSurfaces[n2] + 1.0;
            }
            ++ind;
        }
        for (int c : this.counts) {
            if (c != 1) continue;
            ++this.nbPatch;
        }
        for (int v : this.values) {
            if (v == 0) continue;
            int n = v;
            this.nbPatches[n] = this.nbPatches[n] + 1;
        }
        this.totalSurface = (double)nbPixel * Math.pow(this.cellSize, 2.0) / 10000.0;
        boolean bl = false;
        while (var4_7 < this.totalSurfaces.length) {
            void v3 = var4_7++;
            this.totalSurfaces[v3] = this.totalSurfaces[v3] * (Math.pow(this.cellSize, 2.0) / 10000.0);
        }
        this.maxSurface = 0.0;
        ind = 0;
        for (int s : this.sizes) {
            if (s > 0) {
                cover = this.values[ind];
                this.maxSurface = Math.max(this.maxSurface, (double)s);
                this.maxSurfaces[cover] = Math.max(this.maxSurfaces[cover], (double)s);
                double d = Math.pow((double)s * Math.pow(this.cellSize, 2.0) / 10000.0, 2.0);
                this.totalSurfaceCarre += d;
                int n = cover;
                this.totalSurfacesCarres[n] = this.totalSurfacesCarres[n] + d;
            }
            ++ind;
        }
        this.maxSurface *= Math.pow(this.cellSize, 2.0) / 10000.0;
        this.setResult(true);
    }

    @Override
    protected void doClose() {
        this.tabCluster = null;
        this.tabCover = null;
        this.counts = null;
        this.sizes = null;
        this.initValues = null;
        this.values = null;
    }
}

