/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.cluster;

import fr.inrae.act.bagap.apiland.analysis.Analysis;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.jumpmind.symmetric.csv.CsvWriter;

public class CsvClusteringOutput
extends Analysis {
    private String csvOutput;
    private float[] dataCluster;
    private float[] dataCover;
    private int[] initValues;
    private double cellSize;
    private int noDataValue;
    private Map<Integer, int[]> values;
    private int maxInitValues;

    public CsvClusteringOutput(String csvOutput, float[] dataCluster, float[] dataCover, int[] initValues, double cellSize, int noDataValue) {
        this.csvOutput = csvOutput;
        this.dataCluster = dataCluster;
        this.dataCover = dataCover;
        this.initValues = initValues;
        this.cellSize = cellSize;
        this.noDataValue = noDataValue;
    }

    @Override
    protected void doInit() {
        this.values = new TreeMap<Integer, int[]>();
        this.maxInitValues = 0;
        for (int iv : this.initValues) {
            this.maxInitValues = Math.max(this.maxInitValues, iv);
        }
    }

    @Override
    protected void doRun() {
        int index = 0;
        for (float vC : this.dataCluster) {
            if (vC != (float)this.noDataValue && vC != 0.0f) {
                if (!this.values.containsKey((int)vC)) {
                    this.values.put((int)vC, new int[this.maxInitValues + 1]);
                }
                int[] nArray = this.values.get((int)vC);
                int n = (int)this.dataCover[index];
                nArray[n] = nArray[n] + 1;
            }
            ++index;
        }
        this.setResult(true);
    }

    @Override
    protected void doClose() {
        try {
            CsvWriter cw = new CsvWriter(this.csvOutput);
            cw.setDelimiter(';');
            cw.write("id");
            cw.write("surface");
            for (int iv : this.initValues) {
                cw.write("surf_" + iv);
            }
            cw.endRecord();
            double[] lv = new double[this.initValues.length];
            for (Map.Entry<Integer, int[]> e : this.values.entrySet()) {
                cw.write(e.getKey() + "");
                double sum = 0.0;
                int index = 0;
                for (int iv : this.initValues) {
                    double v = (double)e.getValue()[iv] * Math.pow(this.cellSize, 2.0) / 1000.0;
                    sum += v;
                    lv[index++] = v;
                }
                cw.write(sum + "");
                for (double lvv : lv) {
                    cw.write(lvv + "");
                }
                cw.endRecord();
            }
            cw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

