/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.cluster;

import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.cluster.ClusterType;
import fr.inrae.act.bagap.chloe.cluster.CsvClusteringOutput;
import fr.inrae.act.bagap.chloe.cluster.chess.TabQueenClusteringAnalysis;
import fr.inrae.act.bagap.chloe.cluster.chess.TabRookClusteringAnalysis;
import fr.inrae.act.bagap.chloe.cluster.distance.TabDistanceClusteringAnalysis;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysis;
import java.io.IOException;
import java.util.Set;
import org.jumpmind.symmetric.csv.CsvWriter;

public class ClusterAnalysis
extends ChloeUtilAnalysis {
    private String outputRaster;
    private String outputCsv;
    private String inputRaster;
    private String inputDistance;
    private ClusterType clusterType;
    private int[] clusterSources;
    private double dMax;
    private float[] inData;
    private float[] distanceData;
    private float[] outData;
    private EnteteRaster entete;
    private CsvClusteringOutput outClustering;

    public ClusterAnalysis(String outputRaster, String outputCsv, String inputRaster, String inputDistance, ClusterType clusterType, Set<Integer> clusterSources, double dMax) {
        this.outputRaster = outputRaster;
        this.outputCsv = outputCsv;
        this.inputRaster = inputRaster;
        this.inputDistance = inputDistance;
        this.clusterType = clusterType;
        this.clusterSources = new int[clusterSources.size()];
        int index = 0;
        for (Integer s : clusterSources) {
            this.clusterSources[index++] = s;
        }
        this.dMax = dMax;
    }

    @Override
    protected void doInit() {
        Coverage cov = CoverageManager.getCoverage(this.inputRaster);
        this.entete = cov.getEntete();
        this.inData = cov.getData();
        cov.dispose();
        if (this.clusterType == ClusterType.DISTANCE) {
            Coverage covD = CoverageManager.getCoverage(this.inputDistance);
            this.distanceData = covD.getData();
            covD.dispose();
        }
    }

    @Override
    protected void doRun() {
        if (this.clusterType == ClusterType.QUEEN) {
            TabQueenClusteringAnalysis analysis = new TabQueenClusteringAnalysis(this.inData, this.entete.width(), this.entete.height(), this.clusterSources, this.entete.noDataValue());
            this.outData = (float[])analysis.allRun();
        } else if (this.clusterType == ClusterType.ROOK) {
            TabRookClusteringAnalysis analysis = new TabRookClusteringAnalysis(this.inData, this.entete.width(), this.entete.height(), this.clusterSources, this.entete.noDataValue());
            this.outData = (float[])analysis.allRun();
        } else if (this.clusterType == ClusterType.DISTANCE) {
            TabDistanceClusteringAnalysis analysis = new TabDistanceClusteringAnalysis(this.inData, this.distanceData, this.entete.width(), this.entete.height(), this.clusterSources, this.dMax, this.entete.noDataValue());
            this.outData = (float[])analysis.allRun();
        }
    }

    @Override
    protected void doClose() {
        if (this.outputRaster != null) {
            CoverageManager.write(this.outputRaster, this.outData, this.entete);
        }
        if (this.outputCsv != null) {
            this.outClustering = new CsvClusteringOutput(this.outputCsv, this.outData, this.inData, this.clusterSources, this.entete.cellsize(), this.entete.noDataValue());
            this.outClustering.allRun();
        }
        this.inputRaster = null;
        this.inputDistance = null;
        this.outputRaster = null;
        this.outputCsv = null;
        this.entete = null;
        this.clusterSources = null;
        this.inData = null;
        this.distanceData = null;
        this.outData = null;
    }

    private void writeCsvClustering(String outputCsv) {
        try {
            CsvWriter cw = new CsvWriter(outputCsv);
            cw.setDelimiter(';');
            cw.write("");
            cw.endRecord();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

