/*
 * Decompiled with CFR 0.152.
 */
package fr.inrae.act.bagap.chloe.api;

import fr.inrae.act.bagap.apiland.domain.Domain;
import fr.inrae.act.bagap.apiland.domain.DomainFactory;
import fr.inrae.act.bagap.apiland.raster.Coverage;
import fr.inrae.act.bagap.apiland.raster.CoverageManager;
import fr.inrae.act.bagap.apiland.raster.EnteteRaster;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysis;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisBuilder;
import fr.inrae.act.bagap.chloe.analysis.ChloeAnalysisType;
import fr.inrae.act.bagap.chloe.api.NoParameterException;
import fr.inrae.act.bagap.chloe.api.RasterTypeMime;
import fr.inrae.act.bagap.chloe.cluster.ClusterType;
import fr.inrae.act.bagap.chloe.concept.ecopaysage.api.EcoPaysageAPI;
import fr.inrae.act.bagap.chloe.concept.erosion.api.ErosionAPI;
import fr.inrae.act.bagap.chloe.concept.grainbocager.api.GrainBocagerAPI;
import fr.inrae.act.bagap.chloe.concept.grainbocager.api.GrainBocagerExploitationAPI;
import fr.inrae.act.bagap.chloe.distance.analysis.DistanceType;
import fr.inrae.act.bagap.chloe.util.analysis.ChloeUtilAnalysisBuilder;
import fr.inrae.act.bagap.chloe.window.WindowDistanceType;
import fr.inrae.act.bagap.chloe.window.WindowShapeType;
import fr.inrae.act.bagap.chloe.window.analysis.LandscapeMetricAnalysisBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;

public class ChloeAPI {
    public static void main(String[] args) {
        if (!args[0].endsWith(".properties")) {
            throw new IllegalArgumentException("argument " + args[0] + " is not recognize");
        }
        ChloeAPI.launchBatch(args[0]);
    }

    private static void launchBatch(String file) {
        try {
            Properties properties = new Properties();
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF8");
            properties.load(in);
            ((Reader)in).close();
            if (properties.containsKey("procedure")) {
                String procedure;
                switch (procedure = properties.getProperty("procedure")) {
                    case "grain_bocager": {
                        GrainBocagerAPI.launchBatch(file);
                        break;
                    }
                    case "grain_bocager_exploitation": {
                        GrainBocagerExploitationAPI.launchBatch(file);
                        break;
                    }
                    case "ecolandscape": {
                        EcoPaysageAPI.launchBatch(file);
                        break;
                    }
                    case "erosion": {
                        ErosionAPI.launchBatch(file);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("procedure " + procedure + " is not implemented yet");
                    }
                }
            } else if (properties.containsKey("treatment")) {
                String treatment;
                switch (treatment = properties.getProperty("treatment")) {
                    case "sliding": {
                        ChloeAPI.launchSliding(properties);
                        break;
                    }
                    case "selected": {
                        ChloeAPI.launchSelected(properties);
                        break;
                    }
                    case "grid": {
                        ChloeAPI.launchGrid(properties);
                        break;
                    }
                    case "map": {
                        ChloeAPI.launchMap(properties);
                        break;
                    }
                    case "entity": {
                        ChloeAPI.launchEntity(properties);
                        break;
                    }
                    case "combine": {
                        ChloeAPI.launchCombine(properties);
                        break;
                    }
                    case "search_and_replace": {
                        ChloeAPI.launchSearchAndReplace(properties);
                        break;
                    }
                    case "classification": {
                        ChloeAPI.launchClassification(properties);
                        break;
                    }
                    case "overlay": {
                        ChloeAPI.launchOverlay(properties);
                        break;
                    }
                    case "raster_from_csv": {
                        ChloeAPI.launchRasterFromCsv(properties);
                        break;
                    }
                    case "raster_from_shapefile": {
                        ChloeAPI.launchRasterFromShapefile(properties);
                        break;
                    }
                    case "distance": {
                        ChloeAPI.launchDistance(properties);
                        break;
                    }
                    case "cluster": {
                        ChloeAPI.launchCluster(properties);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("treatment " + treatment + " is not implemented yet");
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void launchSliding(Properties properties) {
        try {
            long begin = System.currentTimeMillis();
            LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.SLIDING);
            ChloeAPI.importInputRaster(builder, properties);
            ChloeAPI.importWindowShape(builder, properties);
            ChloeAPI.importWindowSizes(builder, true, properties);
            ChloeAPI.importDisplacement(builder, properties);
            ChloeAPI.importInterpolation(builder, properties);
            ChloeAPI.importMetrics(builder, properties);
            ChloeAPI.importWindowDistanceType(builder, properties);
            ChloeAPI.importWindowDistanceFunction(builder, properties);
            ChloeAPI.importFrictionRaster(builder, properties);
            ChloeAPI.importFilters(builder, properties);
            ChloeAPI.importUnfilters(builder, properties);
            ChloeAPI.importMaximumNoValueRate(builder, properties);
            ChloeAPI.importValues(builder, properties);
            ChloeAPI.importTypeMime(builder, properties);
            ChloeAPI.importOutputFolderForWindow(builder, properties);
            ChloeAPI.importOutputRaster(builder, properties);
            ChloeAPI.importOutputCsv(builder, properties);
            ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
            analysis.allRun();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchSelected(Properties properties) {
        try {
            long begin = System.currentTimeMillis();
            LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.SELECTED);
            ChloeAPI.importInputRaster(builder, properties);
            ChloeAPI.importWindowShape(builder, properties);
            ChloeAPI.importWindowSizes(builder, true, properties);
            ChloeAPI.importMetrics(builder, properties);
            ChloeAPI.importWindowDistanceType(builder, properties);
            ChloeAPI.importWindowDistanceFunction(builder, properties);
            ChloeAPI.importFrictionRaster(builder, properties);
            ChloeAPI.importPointsFilter(builder, properties);
            ChloeAPI.importWindowsPath(builder, properties);
            ChloeAPI.importTypeMime(builder, properties);
            ChloeAPI.importOutputFolderForWindow(builder, properties);
            ChloeAPI.importOutputRaster(builder, properties);
            ChloeAPI.importOutputCsv(builder, properties);
            ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
            analysis.allRun();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchGrid(Properties properties) {
        try {
            long begin = System.currentTimeMillis();
            LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.GRID);
            ChloeAPI.importInputRaster(builder, properties);
            ChloeAPI.importWindowSizes(builder, false, properties);
            ChloeAPI.importMetrics(builder, properties);
            ChloeAPI.importMaximumNoValueRate(builder, properties);
            ChloeAPI.importTypeMime(builder, properties);
            ChloeAPI.importOutputFolderForWindow(builder, properties);
            ChloeAPI.importOutputRaster(builder, properties);
            ChloeAPI.importOutputCsv(builder, properties);
            ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
            analysis.allRun();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchMap(Properties properties) {
        try {
            long begin = System.currentTimeMillis();
            LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.MAP);
            ChloeAPI.importInputRaster(builder, properties);
            ChloeAPI.importMetrics(builder, properties);
            ChloeAPI.importOutputCsv(builder, properties);
            ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
            analysis.allRun();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchEntity(Properties properties) {
        try {
            long begin = System.currentTimeMillis();
            LandscapeMetricAnalysisBuilder builder = new LandscapeMetricAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.ENTITY);
            ChloeAPI.importInputRaster(builder, properties);
            ChloeAPI.importEntityRaster(builder, properties);
            ChloeAPI.importMetrics(builder, properties);
            ChloeAPI.importTypeMime(builder, properties);
            ChloeAPI.importOutputFolderForWindow(builder, properties);
            ChloeAPI.importOutputRaster(builder, properties);
            ChloeAPI.importOutputCsv(builder, properties);
            ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
            analysis.allRun();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchCombine(Properties properties) {
        try {
            long begin = System.currentTimeMillis();
            ChloeUtilAnalysisBuilder builder = new ChloeUtilAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.COMBINE);
            ChloeAPI.importCombination(builder, properties);
            ChloeAPI.importInputNamesAndRasters(builder, properties);
            ChloeAPI.importOutputRaster(builder, properties);
            ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
            analysis.allRun();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchSearchAndReplace(Properties properties) {
        try {
            long begin = System.currentTimeMillis();
            ChloeUtilAnalysisBuilder builder = new ChloeUtilAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.SEARCHANDREPLACE);
            ChloeAPI.importInputRaster(builder, properties);
            ChloeAPI.importChanges(builder, properties);
            ChloeAPI.importNoDataValue(builder, properties);
            ChloeAPI.importOutputRaster(builder, properties);
            ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
            analysis.allRun();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchClassification(Properties properties) {
        try {
            long begin = System.currentTimeMillis();
            ChloeUtilAnalysisBuilder builder = new ChloeUtilAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.CLASSIFICATION);
            ChloeAPI.importInputRaster(builder, properties);
            ChloeAPI.importDomains(builder, properties);
            ChloeAPI.importOutputRaster(builder, properties);
            ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
            analysis.allRun();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchOverlay(Properties properties) {
        try {
            long begin = System.currentTimeMillis();
            ChloeUtilAnalysisBuilder builder = new ChloeUtilAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.OVERLAY);
            ChloeAPI.importInputRaster(builder, properties);
            ChloeAPI.importOutputRaster(builder, properties);
            ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
            analysis.allRun();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchRasterFromCsv(Properties properties) {
        try {
            long begin = System.currentTimeMillis();
            ChloeUtilAnalysisBuilder builder = new ChloeUtilAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.RASTER_FROM_CSV);
            ChloeAPI.importInputCsv(builder, properties);
            ChloeAPI.importVariables(builder, properties);
            ChloeAPI.importWidth(builder, properties);
            ChloeAPI.importHeight(builder, properties);
            ChloeAPI.importXMin(builder, properties);
            ChloeAPI.importYMin(builder, properties);
            ChloeAPI.importCellSize(builder, properties);
            ChloeAPI.importNoDataValue(builder, properties);
            ChloeAPI.importCRS(builder, properties);
            ChloeAPI.importEntete(builder, properties);
            ChloeAPI.importRefRaster(builder, properties);
            ChloeAPI.importOutputRaster(builder, properties);
            ChloeAPI.importOutputPrefix(builder, properties);
            ChloeAPI.importOutputFolder(builder, properties);
            ChloeAPI.importOutputSuffix(builder, properties);
            ChloeAPI.importTypeMime(builder, properties);
            ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
            analysis.allRun();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchRasterFromShapefile(Properties properties) {
        try {
            long begin = System.currentTimeMillis();
            ChloeUtilAnalysisBuilder builder = new ChloeUtilAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.RASTER_FROM_SHAPEFILE);
            ChloeAPI.importInputShapefile(builder, properties);
            ChloeAPI.importAttribute(builder, properties);
            ChloeAPI.importXMin(builder, properties);
            ChloeAPI.importXMax(builder, properties);
            ChloeAPI.importYMin(builder, properties);
            ChloeAPI.importYMax(builder, properties);
            ChloeAPI.importCellSize(builder, properties);
            ChloeAPI.importNoDataValue(builder, properties);
            ChloeAPI.importFillValue(builder, properties);
            ChloeAPI.importEntete(builder, properties);
            ChloeAPI.importRefRaster(builder, properties);
            ChloeAPI.importOutputRaster(builder, properties);
            ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
            analysis.allRun();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchDistance(Properties properties) {
        try {
            long begin = System.currentTimeMillis();
            ChloeUtilAnalysisBuilder builder = new ChloeUtilAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.DISTANCE);
            ChloeAPI.importInputRaster(builder, properties);
            ChloeAPI.importOutputRaster(builder, properties);
            ChloeAPI.importFrictionRaster(builder, properties);
            ChloeAPI.importDistanceSources(builder, properties);
            ChloeAPI.importDistanceType(builder, properties);
            ChloeAPI.importMaxDistance(builder, properties);
            ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
            analysis.allRun();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void launchCluster(Properties properties) {
        try {
            long begin = System.currentTimeMillis();
            ChloeUtilAnalysisBuilder builder = new ChloeUtilAnalysisBuilder();
            builder.setAnalysisType(ChloeAnalysisType.CLUSTER);
            ChloeAPI.importInputRaster(builder, properties);
            ChloeAPI.importClusterType(builder, properties);
            ChloeAPI.importClusterSources(builder, properties);
            ChloeAPI.importDistanceRaster(builder, properties);
            ChloeAPI.importMaxDistance(builder, properties);
            ChloeAPI.importOutputCsv(builder, properties);
            ChloeAPI.importOutputRaster(builder, properties);
            ChloeAnalysis analysis = ((ChloeAnalysisBuilder)builder).build();
            analysis.allRun();
            long end = System.currentTimeMillis();
            System.out.println("time computing : " + (end - begin));
        }
        catch (NoParameterException e) {
            e.printStackTrace();
        }
    }

    private static void importAttribute(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("attribute")) {
            String prop = properties.getProperty("attribute");
            builder.setAttribute(prop);
            return;
        }
        throw new NoParameterException("attribute");
    }

    public static void importInputRaster(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        String prop;
        if (properties.containsKey("input_raster")) {
            prop = properties.getProperty("input_raster").replace("{", "").replace("}", "");
            String[] rasters = prop.split(";");
            boolean ok = false;
            for (String raster : rasters) {
                if (!new File(raster).isFile()) continue;
                builder.addRasterFile(raster);
                ok = true;
            }
            if (ok) {
                return;
            }
        }
        if (properties.containsKey("input_tile_raster")) {
            prop = properties.getProperty("input_tile_raster");
            builder.setRasterTile(prop);
            return;
        }
        throw new NoParameterException("input_raster or input_tile_raster");
    }

    public static void importEntityRaster(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        String prop;
        if (properties.containsKey("entity_raster") && new File(prop = properties.getProperty("entity_raster")).isFile()) {
            builder.setEntityRasterFile(prop);
            return;
        }
        throw new NoParameterException("entity_raster");
    }

    public static void importInputShapefile(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        String prop;
        if (properties.containsKey("input_shapefile") && new File(prop = properties.getProperty("input_shapefile")).isFile() && prop.endsWith(".shp")) {
            builder.setShapefile(prop);
            return;
        }
        throw new NoParameterException("input_shapefile");
    }

    public static void importInputCsv(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        String prop;
        if (properties.containsKey("input_csv") && new File(prop = properties.getProperty("input_csv")).isFile()) {
            builder.setCsvFile(prop);
            return;
        }
        throw new NoParameterException("input_csv");
    }

    public static void importWindowSizes(ChloeAnalysisBuilder builder, boolean centered, Properties properties) throws NoParameterException {
        if (properties.containsKey("sizes")) {
            String[] ws;
            String prop = properties.getProperty("sizes");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            for (String w : ws = prop.split(";")) {
                int s = Integer.parseInt(w);
                if (centered && s % 2 == 0) {
                    ++s;
                }
                builder.addWindowSize(s);
            }
            return;
        }
        throw new NoParameterException("sizes");
    }

    private static void importDistanceSources(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("distance_sources")) {
            String[] ds;
            String prop = properties.getProperty("distance_sources");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            for (String s : ds = prop.split(";")) {
                builder.addSource(Integer.parseInt(s));
            }
            return;
        }
        throw new NoParameterException("distance_sources");
    }

    private static void importClusterSources(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("cluster_sources")) {
            String[] ds;
            String prop = properties.getProperty("cluster_sources");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            for (String s : ds = prop.split(";")) {
                builder.addSource(Integer.parseInt(s));
            }
            return;
        }
        throw new NoParameterException("cluster_sources");
    }

    private static void importDistanceType(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("distance_type")) {
            builder.setDistanceType(DistanceType.valueOf(properties.getProperty("distance_type").toUpperCase()));
            return;
        }
        throw new NoParameterException("distance_type");
    }

    private static void importClusterType(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("cluster_type")) {
            builder.setClusterType(ClusterType.valueOf(properties.getProperty("cluster_type").toUpperCase()));
            return;
        }
        throw new NoParameterException("cluster_type");
    }

    private static void importMaxDistance(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("max_distance")) {
            String prop = properties.getProperty("max_distance");
            builder.setMaxDistance(Float.parseFloat(prop));
        }
    }

    public static void importMetrics(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("metrics")) {
            String[] ms;
            String prop = properties.getProperty("metrics");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            for (String m : ms = prop.split(";")) {
                builder.addMetric(m);
            }
            return;
        }
        throw new NoParameterException("metrics");
    }

    public static void importVariables(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("variables")) {
            String[] ms;
            String prop = properties.getProperty("variables");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            for (String m : ms = prop.split(";")) {
                builder.addVariable(m);
            }
            return;
        }
        throw new NoParameterException("variables");
    }

    public static void importValues(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("values")) {
            String prop = properties.getProperty("values");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            String[] vs = prop.split(";");
            TreeSet<Integer> setValues = new TreeSet<Integer>();
            for (String v : vs) {
                setValues.add(Integer.parseInt(v));
            }
            StringBuilder sb = new StringBuilder();
            Iterator iterator = setValues.iterator();
            while (iterator.hasNext()) {
                int sv = (Integer)iterator.next();
                sb.append(sv + ",");
            }
            sb.deleteCharAt(sb.length() - 1);
            builder.setValues(sb.toString());
        }
    }

    public static void importWindowShape(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("shape")) {
            builder.setWindowShapeType(WindowShapeType.valueOf(properties.getProperty("shape")));
        }
    }

    public static void importWindowDistanceType(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("distance_type")) {
            builder.setWindowDistanceType(WindowDistanceType.valueOf(properties.getProperty("distance_type")));
        }
    }

    public static void importWindowDistanceFunction(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("distance_function")) {
            builder.setWindowDistanceFunction(properties.getProperty("distance_function"));
        }
    }

    public static void importDisplacement(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("displacement")) {
            builder.setDisplacement(Integer.parseInt(properties.getProperty("displacement")));
        }
    }

    public static void importInterpolation(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("interpolation")) {
            builder.setInterpolation(Boolean.parseBoolean(properties.getProperty("interpolation")));
        }
    }

    public static void importFrictionRaster(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("friction_raster")) {
            builder.setRasterFile2(properties.getProperty("friction_raster"));
        }
    }

    public static void importDistanceRaster(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("distance_raster")) {
            builder.setRasterFile2(properties.getProperty("distance_raster"));
        }
    }

    public static void importFilters(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("filters")) {
            String prop = properties.getProperty("filters");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            String[] fs = prop.split(";");
            int[] filters = new int[fs.length];
            int index = 0;
            for (String f : fs) {
                filters[index++] = Integer.parseInt(f);
            }
            builder.setFilters(filters);
        }
    }

    public static void importUnfilters(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("unfilters")) {
            String prop = properties.getProperty("unfilters");
            prop = prop.replace("{", "").replace("}", "").replace(" ", "");
            String[] fs = prop.split(";");
            int[] unfilters = new int[fs.length];
            int index = 0;
            for (String f : fs) {
                unfilters[index++] = Integer.parseInt(f);
            }
            builder.setUnfilters(unfilters);
        }
    }

    private static void importEntete(ChloeAnalysisBuilder builder, Properties properties) {
        if (properties.containsKey("entete")) {
            EnteteRaster entete = EnteteRaster.read(properties.getProperty("entete"));
            builder.setWidth(entete.width());
            builder.setHeight(entete.height());
            builder.setXMin(entete.minx());
            builder.setXMax(entete.maxx());
            builder.setYMin(entete.miny());
            builder.setYMax(entete.maxy());
            builder.setCellSize(entete.cellsize());
            builder.setNoDataValue(entete.noDataValue());
            builder.setCRS(entete.crs());
        }
    }

    private static void importRefRaster(ChloeAnalysisBuilder builder, Properties properties) {
        if (properties.containsKey("ref_raster")) {
            Coverage cov = CoverageManager.getCoverage(properties.getProperty("ref_raster"));
            EnteteRaster entete = cov.getEntete();
            cov.dispose();
            builder.setWidth(entete.width());
            builder.setHeight(entete.height());
            builder.setXMin(entete.minx());
            builder.setXMax(entete.maxx());
            builder.setYMin(entete.miny());
            builder.setYMax(entete.maxy());
            builder.setCellSize(entete.cellsize());
            builder.setNoDataValue(entete.noDataValue());
            builder.setCRS(entete.crs());
        }
    }

    public static void importOutputRaster(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("output_raster")) {
            String prop = properties.getProperty("output_raster");
            if (prop.endsWith(".asc")) {
                builder.addAsciiGridOutput(prop);
            } else if (prop.endsWith(".tif")) {
                builder.addGeoTiffOutput(prop);
            } else {
                throw new NoParameterException("output_raster : " + prop);
            }
        }
    }

    public static void importOutputCsv(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("output_csv")) {
            builder.addCsvOutput(properties.getProperty("output_csv"));
        }
    }

    public static void importWindowsPath(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("windows_path")) {
            String prop = properties.getProperty("windows_path");
            if (!prop.endsWith("/") && !prop.endsWith("\\\\")) {
                prop = prop + "/";
            }
            builder.setWindowsPath(prop);
        }
    }

    public static void importOutputPrefix(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("output_prefix")) {
            builder.setOutputPrefix(properties.getProperty("output_prefix"));
        }
    }

    public static void importOutputFolder(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("output_folder")) {
            String prop = properties.getProperty("output_folder");
            if (!prop.endsWith("/") && !prop.endsWith("\\\\")) {
                prop = prop + "/";
            }
            builder.setOutputFolder(prop);
        }
    }

    public static void importOutputSuffix(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("output_suffix")) {
            builder.setOutputSuffix(properties.getProperty("output_suffix"));
        }
    }

    public static void importTypeMime(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("type_mime")) {
            builder.setTypeMime(properties.getProperty("type_mime"));
        }
    }

    public static void importOutputFolderForWindow(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("output_folder")) {
            String prop = properties.getProperty("output_folder");
            if (!prop.endsWith("/") && !prop.endsWith("\\\\")) {
                prop = prop + "/";
            }
            boolean export_raster = true;
            if (properties.containsKey("export_raster")) {
                export_raster = Boolean.parseBoolean(properties.getProperty("export_raster"));
            }
            if (export_raster) {
                RasterTypeMime typeMime = builder.getTypeMime();
                if (typeMime == RasterTypeMime.ASCII_GRID) {
                    builder.setAsciiGridOutputFolder(prop);
                } else if (typeMime == RasterTypeMime.GEOTIFF) {
                    builder.setGeoTiffOutputFolder(prop);
                } else {
                    throw new NoParameterException("type_mime : '" + (Object)((Object)builder.getTypeMime()) + "' interpretation problem");
                }
            }
            boolean export_csv = true;
            if (properties.containsKey("export_csv")) {
                export_csv = Boolean.parseBoolean(properties.getProperty("export_csv"));
            }
            if (export_csv) {
                builder.setCsvOutputFolder(prop);
            }
        }
    }

    public static void importXOrigin(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("x_origin")) {
            builder.setROIX(Integer.parseInt(properties.getProperty("x_origin")));
        }
    }

    public static void importYOrigin(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("y_origin")) {
            builder.setROIY(Integer.parseInt(properties.getProperty("y_origin")));
        }
    }

    public static void importMaximumNoValueRate(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("maximum_rate_nodata_value")) {
            builder.setMinRate(1.0 / (Double.parseDouble(properties.getProperty("maximum_rate_nodata_value")) / 100.0));
        }
    }

    public static void importPointsFilter(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("points")) {
            builder.setPointsFilter(properties.getProperty("points"));
        }
    }

    public static void importPixelsFilter(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("pixels")) {
            builder.setPointsFilter(properties.getProperty("pixels"));
        }
    }

    public static void importInputNamesAndRasters(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("factors")) {
            String prop = properties.getProperty("factors").replace("{", "").replace("}", "");
            String[] ds = prop.split(";");
            TreeMap<String, String> factors = new TreeMap<String, String>();
            for (String d : ds) {
                d = d.replace("(", "").replace(")", "");
                String[] dd = d.split(",");
                factors.put(dd[1], dd[0]);
            }
            builder.setNamesAndRasters(factors);
            return;
        }
        throw new NoParameterException("factors");
    }

    private static void importCombination(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("combination")) {
            builder.setCombination(properties.getProperty("combination"));
            return;
        }
        throw new NoParameterException("combination");
    }

    public static void importChanges(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("changes")) {
            String prop = properties.getProperty("changes").replace("{", "").replace("}", "");
            String[] cc = prop.split(";");
            HashMap<Float, Float> changes = new HashMap<Float, Float>();
            for (String c : cc) {
                c = c.replace("(", "").replace(")", "");
                String[] vv = c.split(",");
                changes.put(Float.valueOf(Float.parseFloat(vv[0])), Float.valueOf(Float.parseFloat(vv[1])));
            }
            builder.setChanges(changes);
            return;
        }
        throw new NoParameterException("changes");
    }

    public static void importNoDataValue(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("nodata_value")) {
            builder.setNoDataValue(Integer.parseInt(properties.getProperty("nodata_value")));
        }
    }

    private static void importCRS(ChloeAnalysisBuilder builder, Properties properties) {
        if (properties.containsKey("crs")) {
            try {
                builder.setCRS(CRS.decode((String)properties.getProperty("crs")));
            }
            catch (FactoryException e) {
                e.printStackTrace();
            }
        }
    }

    public static void importFillValue(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("fill_value")) {
            builder.setFillValue(Float.parseFloat(properties.getProperty("fill_value")));
        }
    }

    public static void importCellSize(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("cellsize")) {
            builder.setCellSize(Float.parseFloat(properties.getProperty("cellsize")));
        }
    }

    public static void importHeight(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("height")) {
            builder.setHeight(Integer.parseInt(properties.getProperty("height")));
        }
    }

    public static void importWidth(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("width")) {
            builder.setWidth(Integer.parseInt(properties.getProperty("width")));
        }
    }

    public static void importXMin(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("xmin")) {
            builder.setXMin(Double.parseDouble(properties.getProperty("xmin")));
        }
    }

    public static void importXMax(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("xmax")) {
            builder.setXMax(Double.parseDouble(properties.getProperty("xmax")));
        }
    }

    public static void importYMin(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("ymin")) {
            builder.setYMin(Double.parseDouble(properties.getProperty("ymin")));
        }
    }

    public static void importYMax(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("ymax")) {
            builder.setYMax(Double.parseDouble(properties.getProperty("ymax")));
        }
    }

    private static void importDomains(ChloeAnalysisBuilder builder, Properties properties) throws NoParameterException {
        if (properties.containsKey("domains")) {
            String prop = properties.getProperty("domains").replace("{", "").replace("}", "");
            String[] ds = prop.split(";");
            HashMap<Domain<Float, Float>, Integer> domains = new HashMap<Domain<Float, Float>, Integer>();
            for (String d : ds) {
                d = d.replace("(", "").replace(")", "");
                String[] dd = d.split("-");
                domains.put(DomainFactory.getFloatDomain(dd[0]), Integer.parseInt(dd[1]));
            }
            builder.setDomains(domains);
            return;
        }
        throw new NoParameterException("domains");
    }
}

