/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableBatchProcessor;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.WekaException;
import weka.gui.FilePropertyMetadata;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="SerializedModelSaver", category="DataSinks", toolTipText="A step that saves models to the file system", iconPath="weka/gui/knowledgeflow/icons/SerializedModelSaver.gif")
public class SerializedModelSaver
extends BaseStep {
    private static final long serialVersionUID = -8343162241983197708L;
    protected Instances m_incrementalHeader;
    protected int m_incrementalSaveSchedule;
    protected boolean m_includeRelationName;
    private String m_filenamePrefix = "";
    private File m_directory = new File(System.getProperty("user.dir"));
    protected int m_counter;

    @FilePropertyMetadata(fileChooserDialogType=1, directoriesOnly=true)
    @OptionMetadata(displayName="Output directory", description="The directory to save models to", displayOrder=0)
    public void setOutputDirectory(File directory) {
        this.m_directory = directory;
    }

    public File getOutputDirectory() {
        return this.m_directory;
    }

    @OptionMetadata(displayName="Filename prefix", description="A prefix to prepend to the filename", displayOrder=1)
    public void setFilenamePrefix(String filenamePrefix) {
        this.m_filenamePrefix = filenamePrefix;
    }

    public String getFilenamePrefix() {
        return this.m_filenamePrefix;
    }

    @OptionMetadata(displayName="Incremental save schedule", description="How frequently to save incremental classifiers (<= 0 indicates that the save will happen just once, at the end of the stream", displayOrder=4)
    public void setIncrementalSaveSchedule(int schedule) {
        this.m_incrementalSaveSchedule = schedule;
    }

    public int getIncrementalSaveSchedule() {
        return this.m_incrementalSaveSchedule;
    }

    @OptionMetadata(displayName="Include relation name in file name", description="Whether to include the relation name of the data as part of the file name", displayOrder=2)
    public void setIncludeRelationNameInFilename(boolean includeRelationName) {
        this.m_includeRelationName = includeRelationName;
    }

    public boolean getIncludeRelationNameInFilename() {
        return this.m_includeRelationName;
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("batchClassifier");
        result.add("incrementalClassifier");
        result.add("batchClusterer");
        result.add("batchAssociator");
        return result;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return new ArrayList<String>();
    }

    @Override
    public void stepInit() {
        this.m_incrementalHeader = null;
        this.m_counter = 0;
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        Classifier modelToSave = null;
        Instances modelHeader = null;
        Integer setNum = null;
        Integer maxSetNum = null;
        if (data.getConnectionName().equals("incrementalClassifier")) {
            if (this.m_incrementalHeader == null && !this.getStepManager().isStreamFinished(data)) {
                this.m_incrementalHeader = ((Instance)data.getPayloadElement("aux_testInstance")).dataset();
            }
            if (this.getStepManager().isStreamFinished(data) || this.m_incrementalSaveSchedule > 0 && this.m_counter % this.m_incrementalSaveSchedule == 0 && this.m_counter > 0) {
                modelToSave = (Classifier)data.getPayloadElement("incrementalClassifier");
                modelHeader = this.m_incrementalHeader;
            }
        } else {
            modelToSave = (Classifier)data.getPayloadElement(data.getConnectionName());
            modelHeader = (Instances)data.getPayloadElement("aux_trainingSet");
            setNum = (Integer)data.getPayloadElement("aux_set_num");
            maxSetNum = (Integer)data.getPayloadElement("aux_max_set_num");
            if (modelHeader == null) {
                modelHeader = (Instances)data.getPayloadElement("aux_testsSet");
            }
        }
        if (modelToSave != null) {
            if (modelToSave instanceof UpdateableBatchProcessor) {
                try {
                    ((UpdateableBatchProcessor)((Object)modelToSave)).batchFinished();
                }
                catch (Exception ex) {
                    throw new WekaException(ex);
                }
            }
            if (modelHeader != null) {
                modelHeader = modelHeader.stringFreeStructure();
            }
            this.getStepManager().processing();
            String prefix = this.getStepManager().environmentSubstitute(this.m_filenamePrefix);
            String relationName = this.m_includeRelationName && modelHeader != null ? modelHeader.relationName() : "";
            String setSpec = maxSetNum != null && setNum != null ? "_" + setNum + "_" + maxSetNum + "_" : "";
            String modelName = modelToSave.getClass().getCanonicalName();
            modelName = modelName.substring(modelName.lastIndexOf(".") + 1, modelName.length());
            String filename = "" + prefix + relationName + setSpec + modelName;
            filename = SerializedModelSaver.sanitizeFilename(filename);
            String dirName = this.getStepManager().environmentSubstitute(this.m_directory.toString());
            File tempFile = new File(dirName);
            filename = tempFile.getAbsolutePath() + File.separator + filename;
            this.getStepManager().logBasic("Saving model " + modelToSave.getClass().getCanonicalName() + " to " + filename + ".model");
            this.getStepManager().statusMessage("Saving model: " + modelToSave.getClass().getCanonicalName());
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(new File(filename + ".model"))));
                oos.writeObject(modelToSave);
                if (modelHeader != null) {
                    oos.writeObject(modelHeader);
                }
                oos.close();
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
            finally {
                if (data.getConnectionName() != "incrementalClassifier" || this.getStepManager().isStreamFinished(data)) {
                    this.getStepManager().finished();
                }
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (Exception ex) {
                        throw new WekaException(ex);
                    }
                }
            }
        }
        ++this.m_counter;
    }

    protected static String sanitizeFilename(String filename) {
        return filename.replaceAll("\\\\", "_").replaceAll(":", "_").replaceAll("/", "_");
    }
}

