/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.ProgrammaticProperty;
import weka.gui.knowledgeflow.StepInteractiveViewer;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.LoggingLevel;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.BaseStepExtender;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.NotPersistable;
import weka.knowledgeflow.steps.Note;
import weka.knowledgeflow.steps.Step;

public abstract class BaseStep
implements Step,
BaseStepExtender,
Serializable {
    private static final long serialVersionUID = -1595753549991953141L;
    protected String m_stepName = "";
    protected transient StepManager m_stepManager;
    protected boolean m_stepIsResourceIntensive;

    public BaseStep() {
        Annotation[] annotations;
        String clazzName = this.getClass().getCanonicalName();
        clazzName = clazzName.substring(clazzName.lastIndexOf(".") + 1);
        this.setName(clazzName);
        for (Annotation a : annotations = this.getClass().getAnnotations()) {
            String name;
            if (!(a instanceof KFStep) || (name = ((KFStep)a).name()).length() <= 0) continue;
            this.setName(name);
            break;
        }
    }

    public String globalInfo() {
        Annotation[] annotations;
        for (Annotation a : annotations = this.getClass().getAnnotations()) {
            if (!(a instanceof KFStep)) continue;
            return ((KFStep)a).toolTipText();
        }
        return null;
    }

    @Override
    @NotPersistable
    public StepManager getStepManager() {
        return this.m_stepManager;
    }

    @Override
    public void setStepManager(StepManager manager) {
        this.m_stepManager = manager;
    }

    @ProgrammaticProperty
    public void setStepIsResourceIntensive(boolean isResourceIntensive) {
        this.getStepManager().setStepIsResourceIntensive(isResourceIntensive);
    }

    public boolean isResourceIntensive() {
        return this.getStepManager().stepIsResourceIntensive();
    }

    @ProgrammaticProperty
    public void setStepMustRunSingleThreaded(boolean mustRunSingleThreaded) {
        this.getStepManager().setStepMustRunSingleThreaded(mustRunSingleThreaded);
    }

    public boolean stepMustRunSingleThreaded() {
        return this.getStepManager().getStepMustRunSingleThreaded();
    }

    @Override
    public String getName() {
        return this.m_stepName;
    }

    @Override
    @ProgrammaticProperty
    public void setName(String name) {
        this.m_stepName = name;
    }

    @Override
    public void start() throws WekaException {
    }

    @Override
    public void stop() {
        if (!(this instanceof Note)) {
            this.getStepManager().statusMessage("INTERRUPTED");
            this.getStepManager().log("Interrupted", LoggingLevel.LOW);
        }
        ((StepManagerImpl)this.getStepManager()).setStopRequested(true);
        this.getStepManager().throughputUpdateEnd();
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        return this.outputStructureForConnectionType(connectionName, null);
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName, Environment env) throws WekaException {
        return null;
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
    }

    @Override
    public String getCustomEditorForStep() {
        return null;
    }

    @Override
    public Map<String, String> getInteractiveViewers() {
        return null;
    }

    @Override
    public Map<String, StepInteractiveViewer> getInteractiveViewersImpls() {
        return null;
    }

    @Override
    public Defaults getDefaultSettings() {
        return null;
    }

    public boolean isStopRequested() {
        return this.getStepManager().isStopRequested();
    }

    public String environmentSubstitute(String source) {
        return this.getStepManager().environmentSubstitute(source);
    }
}

