/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.ows20;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RangeClosureType implements Enumerator
{
    CLOSED(0, "closed", "closed"),
    OPEN(1, "open", "open"),
    OPEN_CLOSED(2, "openClosed", "open-closed"),
    CLOSED_OPEN(3, "closedOpen", "closed-open");

    public static final int CLOSED_VALUE = 0;
    public static final int OPEN_VALUE = 1;
    public static final int OPEN_CLOSED_VALUE = 2;
    public static final int CLOSED_OPEN_VALUE = 3;
    private static final RangeClosureType[] VALUES_ARRAY;
    public static final List<RangeClosureType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static RangeClosureType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            RangeClosureType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static RangeClosureType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            RangeClosureType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static RangeClosureType get(int value) {
        switch (value) {
            case 0: {
                return CLOSED;
            }
            case 1: {
                return OPEN;
            }
            case 2: {
                return OPEN_CLOSED;
            }
            case 3: {
                return CLOSED_OPEN;
            }
        }
        return null;
    }

    private RangeClosureType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new RangeClosureType[]{CLOSED, OPEN, OPEN_CLOSED, CLOSED_OPEN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

